/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ZipperUpdater;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.Alarm;
import com.jetbrains.nodejs.run.profile.heap.calculation.ByteArrayWrapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class V8IndexCatalogManager {
    private static final int ourIndexMagic = 32456;
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.nodejs.run.profile.heap.calculation.DigestsManager");
    private final Map<ByteArrayWrapper, File> myMap;
    private final Object myLock = new Object();
    private final ZipperUpdater myUpdater;
    private final File myIndex;
    private final File mySystemDir;
    private final Runnable myWriteIndexRunnable;
    private static final byte[] version = new byte[]{15};

    public V8IndexCatalogManager() {
        this.myMap = new com.intellij.util.containers.hash.HashMap();
        this.myUpdater = new ZipperUpdater(300, Alarm.ThreadToUse.POOLED_THREAD, (Disposable)ApplicationManager.getApplication());
        this.mySystemDir = V8IndexCatalogManager.getSystemDir();
        this.myIndex = new File(this.mySystemDir, "index");
        this.myWriteIndexRunnable = () -> this.writeIndex();
        this.readIndex();
    }

    public static V8IndexCatalogManager getInstance() {
        return (V8IndexCatalogManager)ServiceManager.getService(V8IndexCatalogManager.class);
    }

    public static <T extends Enum> Map<T, List<Pair<String, byte[]>>> readDigests(@NotNull File file, Class<T> clazz) throws IOException {
        if (file == null) {
            V8IndexCatalogManager.$$$reportNull$$$0(0);
        }
        if (!file.exists()) {
            return null;
        }
        byte[] bytes = FileUtil.loadFileBytes((File)file);
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ObjectInputStream is = new ObjectInputStream(bis);
        int num = is.readInt();
        HashMap<T, ArrayList<Pair>> map = new HashMap<T, ArrayList<Pair>>(num);
        for (int i = 0; i < num; ++i) {
            T category;
            String categoryCode = is.readUTF();
            try {
                category = Enum.valueOf(clazz, categoryCode);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            String fileName = is.readUTF();
            int size = is.readInt();
            byte[] digest = new byte[size];
            is.read(digest);
            ArrayList<Pair> list = (ArrayList<Pair>)map.get(category);
            if (list == null) {
                list = new ArrayList<Pair>();
                map.put(category, list);
            }
            list.add(Pair.create((Object)fileName, (Object)digest));
        }
        return map;
    }

    public static <T extends Enum> void writeDigests(@NotNull Map<T, List<File>> filesMap, @NotNull File file) throws IOException {
        List list;
        if (filesMap == null) {
            V8IndexCatalogManager.$$$reportNull$$$0(1);
        }
        if (file == null) {
            V8IndexCatalogManager.$$$reportNull$$$0(2);
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bytes);
        HashSet<Map.Entry<T, List<File>>> entries = new HashSet<Map.Entry<T, List<File>>>(filesMap.entrySet());
        int cnt = 0;
        for (Map.Entry entry : entries) {
            list = (List)entry.getValue();
            cnt += list.size();
        }
        out.writeInt(cnt);
        for (Map.Entry entry : entries) {
            list = (List)entry.getValue();
            for (File categoryFile : list) {
                byte[] digest = V8IndexCatalogManager.digestFile(categoryFile, new byte[0][]);
                if (digest == null) continue;
                out.writeUTF(((Enum)entry.getKey()).name());
                out.writeUTF(categoryFile.getName());
                out.writeInt(digest.length);
                out.write(digest);
            }
        }
        out.flush();
        FileUtil.writeToFile((File)file, (byte[])bytes.toByteArray());
    }

    public static byte[] digestFile(@NotNull File file, byte[] ... additional) throws IOException {
        if (file == null) {
            V8IndexCatalogManager.$$$reportNull$$$0(3);
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(version);
            md.update(file.getName().getBytes(CharsetToolkit.UTF8_CHARSET));
            md.update(String.valueOf(file.lastModified()).getBytes(CharsetToolkit.UTF8_CHARSET));
            md.update(String.valueOf(file.length()).getBytes(CharsetToolkit.UTF8_CHARSET));
            if (!V8IndexCatalogManager.checkBeginning(file, md)) {
                return null;
            }
            for (byte[] bytes : additional) {
                md.update(bytes);
            }
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    private static boolean checkBeginning(@NotNull File snapshotFile, MessageDigest md) throws IOException {
        if (snapshotFile == null) {
            V8IndexCatalogManager.$$$reportNull$$$0(4);
        }
        if (snapshotFile.length() > 10000L) {
            byte[] bytes = FileUtil.loadFirstAndClose((InputStream)new FileInputStream(snapshotFile), (int)1000);
            md.update(bytes);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public File getOrCreate(byte[] digest) {
        Object object = this.myLock;
        synchronized (object) {
            ByteArrayWrapper wrapper = new ByteArrayWrapper(digest);
            File file = this.myMap.get(wrapper);
            if (file == null) {
                try {
                    file = FileUtil.createTempDirectory((File)this.mySystemDir, (String)"v8", null, (boolean)false);
                    this.myMap.put(wrapper, file);
                    this.scheduleWriteIndex();
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                    return null;
                }
            }
            return file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readIndex() {
        Object object = this.myLock;
        synchronized (object) {
            this.myMap.clear();
            try {
                if (this.myIndex.exists()) {
                    byte[] bytes = FileUtil.loadFileBytes((File)this.myIndex);
                    ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
                    int control = ois.readInt();
                    if (control != 32456) {
                        this.clearIndexDirectory();
                        return;
                    }
                    boolean dirty = false;
                    int size = ois.readInt();
                    for (int i = 0; i < size; ++i) {
                        String folderName = ois.readUTF();
                        int digestSize = ois.readInt();
                        byte[] digest = new byte[digestSize];
                        ois.read(digest);
                        File folder = new File(this.mySystemDir, folderName);
                        if (folder.exists()) {
                            if (!folder.isDirectory()) {
                                this.clearIndexDirectory();
                                return;
                            }
                            this.myMap.put(new ByteArrayWrapper(digest), folder);
                            continue;
                        }
                        dirty = true;
                    }
                    if (dirty) {
                        this.scheduleWriteIndex();
                    }
                }
            }
            catch (IOException e) {
                this.clearIndexDirectory();
            }
        }
    }

    private void scheduleWriteIndex() {
        this.myUpdater.queue(this.myWriteIndexRunnable);
    }

    private void clearIndexDirectory() {
        FileUtil.delete((File)this.mySystemDir);
        this.mySystemDir.mkdirs();
        this.myMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIndex() {
        Object object = this.myLock;
        synchronized (object) {
            try {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                ObjectOutputStream stream = new ObjectOutputStream(bytes);
                stream.writeInt(32456);
                stream.writeInt(this.myMap.size());
                for (Map.Entry<ByteArrayWrapper, File> entry : this.myMap.entrySet()) {
                    stream.writeUTF(entry.getValue().getName());
                    ByteArrayWrapper wrapper = entry.getKey();
                    stream.writeInt(wrapper.getData().length);
                    stream.write(wrapper.getData());
                }
                stream.flush();
                FileUtil.writeToFile((File)this.myIndex, (byte[])bytes.toByteArray());
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
    }

    @NotNull
    public static File getSystemDir() {
        File file = new File(PathManager.getSystemPath(), ApplicationManager.getApplication().isUnitTestMode() ? "v8test" : "v8");
        if (file == null) {
            V8IndexCatalogManager.$$$reportNull$$$0(5);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesMap";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshotFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/run/profile/V8IndexCatalogManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/run/profile/V8IndexCatalogManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readDigests";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeDigests";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "digestFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkBeginning";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

