/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonListeners;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NotNull;

public class TogglePopupHintsAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.TogglePopupHintsAction");

    private static PsiFile getTargetFile(DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        VirtualFile[] files2 = FileEditorManager.getInstance((Project)project).getSelectedFiles();
        if (files2.length == 0) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(files2[0]);
        LOG.assertTrue(psiFile != null);
        return psiFile;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            TogglePopupHintsAction.$$$reportNull$$$0(0);
        }
        PsiFile psiFile = TogglePopupHintsAction.getTargetFile(e.getDataContext());
        e.getPresentation().setEnabled(psiFile != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        PsiFile psiFile;
        if (e == null) {
            TogglePopupHintsAction.$$$reportNull$$$0(1);
        }
        LOG.assertTrue((psiFile = TogglePopupHintsAction.getTargetFile(e.getDataContext())) != null);
        Project project = e.getProject();
        LOG.assertTrue(project != null);
        DaemonCodeAnalyzer codeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)project);
        codeAnalyzer.setImportHintsEnabled(psiFile, !codeAnalyzer.isImportHintsEnabled(psiFile));
        DaemonListeners.getInstance(project).updateStatusBar();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/TogglePopupHintsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

