/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.ide.actions.searcheverywhere.SEResultsEqualityProvider;
import com.intellij.ide.actions.searcheverywhere.SESearcher;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFilter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class MultithreadSearcher
implements SESearcher {
    private static final Logger LOG = Logger.getInstance(MultithreadSearcher.class);
    @NotNull
    private final SESearcher.Listener myListener;
    @NotNull
    private final Executor myNotificationExecutor;
    @NotNull
    private final SEResultsEqualityProvider myEqualityProvider;

    MultithreadSearcher(@NotNull SESearcher.Listener listener2, @NotNull Executor notificationExecutor, @NotNull Collection<? extends SEResultsEqualityProvider> equalityProviders) {
        if (listener2 == null) {
            MultithreadSearcher.$$$reportNull$$$0(0);
        }
        if (notificationExecutor == null) {
            MultithreadSearcher.$$$reportNull$$$0(1);
        }
        if (equalityProviders == null) {
            MultithreadSearcher.$$$reportNull$$$0(2);
        }
        this.myListener = listener2;
        this.myNotificationExecutor = notificationExecutor;
        this.myEqualityProvider = SEResultsEqualityProvider.composite(equalityProviders);
    }

    MultithreadSearcher(@NotNull SESearcher.Listener listener2, @NotNull Collection<? extends SEResultsEqualityProvider> equalityProviders) {
        if (listener2 == null) {
            MultithreadSearcher.$$$reportNull$$$0(3);
        }
        if (equalityProviders == null) {
            MultithreadSearcher.$$$reportNull$$$0(4);
        }
        this(listener2, Runnable::run, equalityProviders);
    }

    @Override
    public ProgressIndicator search(Map<SearchEverywhereContributor<?>, Integer> contributorsAndLimits, String pattern, boolean useNonProjectItems, Function<SearchEverywhereContributor<?>, SearchEverywhereContributorFilter<?>> filterSupplier) {
        LOG.debug("Search started for pattern [", new Object[]{pattern, "]"});
        final Phaser phaser = new Phaser();
        final FullSearchResultsAccumulator accumulator = new FullSearchResultsAccumulator(contributorsAndLimits, this.myEqualityProvider, this.myListener, this.myNotificationExecutor);
        ProgressIndicatorBase indicator = new ProgressIndicatorBase(){

            @Override
            protected void onRunningChange() {
                if (this.isCanceled()) {
                    accumulator.stop();
                    phaser.forceTermination();
                }
            }
        };
        indicator.start();
        Runnable finisherTask = MultithreadSearcher.createFinisherTask(phaser, accumulator, indicator);
        for (SearchEverywhereContributor<?> contributor : contributorsAndLimits.keySet()) {
            SearchEverywhereContributorFilter<?> filter = filterSupplier.apply(contributor);
            phaser.register();
            Runnable task = MultithreadSearcher.createSearchTask(pattern, useNonProjectItems, accumulator, indicator, contributor, filter, () -> phaser.arrive());
            ApplicationManager.getApplication().executeOnPooledThread(task);
        }
        ApplicationManager.getApplication().executeOnPooledThread(finisherTask);
        return indicator;
    }

    @Override
    public ProgressIndicator findMoreItems(Map<SearchEverywhereContributor<?>, Collection<SESearcher.ElementInfo>> alreadyFound, String pattern, boolean useNonProjectItems, SearchEverywhereContributor<?> contributorToExpand, int newLimit, Function<SearchEverywhereContributor<?>, SearchEverywhereContributorFilter<?>> filterSupplier) {
        ShowMoreResultsAccumulator accumulator = new ShowMoreResultsAccumulator(alreadyFound, this.myEqualityProvider, contributorToExpand, newLimit, this.myListener, this.myNotificationExecutor);
        SearchEverywhereContributorFilter<?> filter = filterSupplier.apply(contributorToExpand);
        ProgressIndicatorBase indicator = new ProgressIndicatorBase();
        indicator.start();
        Runnable task = MultithreadSearcher.createSearchTask(pattern, useNonProjectItems, accumulator, indicator, contributorToExpand, filter, () -> indicator.stop());
        ApplicationManager.getApplication().executeOnPooledThread(task);
        return indicator;
    }

    @NotNull
    private static <F> Runnable createSearchTask(String pattern, boolean useNonProjectItems, ResultsAccumulator accumulator, ProgressIndicator indicator, SearchEverywhereContributor<F> contributor, SearchEverywhereContributorFilter<?> filter, Runnable finalCallback) {
        ContributorSearchTask task = new ContributorSearchTask(contributor, pattern, filter, useNonProjectItems, accumulator, indicator, finalCallback);
        Runnable runnable2 = ConcurrencyUtil.underThreadNameRunnable((String)"SE-SearchTask", task);
        if (runnable2 == null) {
            MultithreadSearcher.$$$reportNull$$$0(5);
        }
        return runnable2;
    }

    private static Runnable createFinisherTask(Phaser phaser, FullSearchResultsAccumulator accumulator, ProgressIndicator indicator) {
        phaser.register();
        return ConcurrencyUtil.underThreadNameRunnable((String)"SE-FinisherTask", () -> {
            phaser.arriveAndAwaitAdvance();
            if (!indicator.isCanceled()) {
                accumulator.searchFinished();
            }
            indicator.stop();
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationExecutor";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equalityProviders";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/MultithreadSearcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/MultithreadSearcher";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FullSearchResultsAccumulator
    extends ResultsAccumulator {
        private final Map<SearchEverywhereContributor<?>, Integer> sectionsLimits;
        private final Map<SearchEverywhereContributor<?>, Condition> conditionsMap;
        private final Map<SearchEverywhereContributor<?>, Boolean> hasMoreMap = new ConcurrentHashMap();
        private final Set<SearchEverywhereContributor<?>> finishedContributorsSet = ContainerUtil.newConcurrentSet();
        private final Lock lock = new ReentrantLock();
        private volatile boolean mySearchFinished = false;

        FullSearchResultsAccumulator(Map<SearchEverywhereContributor<?>, Integer> contributorsAndLimits, SEResultsEqualityProvider equalityProvider, SESearcher.Listener listener2, Executor notificationExecutor) {
            super(contributorsAndLimits.entrySet().stream().collect(Collectors.toMap(entry -> (SearchEverywhereContributor)entry.getKey(), entry -> new ArrayList((Integer)entry.getValue()))), equalityProvider, listener2, notificationExecutor);
            this.sectionsLimits = contributorsAndLimits;
            this.conditionsMap = contributorsAndLimits.keySet().stream().collect(Collectors.toMap(Function.identity(), c -> this.lock.newCondition()));
        }

        @Override
        public void setContributorHasMore(SearchEverywhereContributor<?> contributor, boolean hasMore) {
            this.hasMoreMap.put(contributor, hasMore);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addElement(Object element, SearchEverywhereContributor<?> contributor, int priority, ProgressIndicator indicator) throws InterruptedException {
            SESearcher.ElementInfo newElementInfo = new SESearcher.ElementInfo(element, priority, contributor);
            Condition condition = this.conditionsMap.get(contributor);
            Collection section = (Collection)this.sections.get(contributor);
            int limit = this.sectionsLimits.get(contributor);
            this.lock.lock();
            try {
                while (section.size() >= limit && !this.mySearchFinished) {
                    indicator.checkCanceled();
                    condition.await(100L, TimeUnit.MILLISECONDS);
                }
                if (this.mySearchFinished) {
                    boolean bl = false;
                    return bl;
                }
                Map<SEResultsEqualityProvider.Action, Collection<SESearcher.ElementInfo>> otherElementsMap = this.getActionsWithOtherElements(newElementInfo);
                if (otherElementsMap.get((Object)SEResultsEqualityProvider.Action.REPLACE).isEmpty() && !otherElementsMap.get((Object)SEResultsEqualityProvider.Action.SKIP).isEmpty()) {
                    LOG.debug(String.format("Element %s for contributor %s was skipped", element.toString(), contributor.getSearchProviderId()));
                    boolean bl = true;
                    return bl;
                }
                section.add(newElementInfo);
                this.myNotificationExecutor.execute(() -> this.myListener.elementsAdded(Collections.singletonList(newElementInfo)));
                ArrayList<SESearcher.ElementInfo> toRemove2 = new ArrayList<SESearcher.ElementInfo>(otherElementsMap.get((Object)SEResultsEqualityProvider.Action.REPLACE));
                toRemove2.forEach(info -> {
                    Collection list2 = (Collection)this.sections.get(info.getContributor());
                    Condition listCondition = this.conditionsMap.get(info.getContributor());
                    list2.remove(info);
                    LOG.debug(String.format("Element %s for contributor %s is removed", info.getElement().toString(), info.getContributor().getSearchProviderId()));
                    listCondition.signal();
                });
                this.myNotificationExecutor.execute(() -> this.myListener.elementsRemoved(toRemove2));
                if (section.size() >= limit) {
                    this.stopSearchIfNeeded();
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void contributorFinished(SearchEverywhereContributor<?> contributor) {
            this.lock.lock();
            try {
                this.finishedContributorsSet.add(contributor);
                this.stopSearchIfNeeded();
            }
            finally {
                this.lock.unlock();
            }
        }

        public void searchFinished() {
            this.myNotificationExecutor.execute(() -> this.myListener.searchFinished(this.hasMoreMap));
        }

        public void stop() {
            this.lock.lock();
            try {
                this.mySearchFinished = true;
                this.conditionsMap.values().forEach(Condition::signalAll);
            }
            finally {
                this.lock.unlock();
            }
        }

        private void stopSearchIfNeeded() {
            if (this.sections.keySet().stream().allMatch(contributor -> this.isContributorFinished((SearchEverywhereContributor<?>)contributor))) {
                this.mySearchFinished = true;
                this.conditionsMap.values().forEach(Condition::signalAll);
            }
        }

        private boolean isContributorFinished(SearchEverywhereContributor<?> contributor) {
            if (this.finishedContributorsSet.contains(contributor)) {
                return true;
            }
            return ((Collection)this.sections.get(contributor)).size() >= this.sectionsLimits.get(contributor);
        }
    }

    private static class ShowMoreResultsAccumulator
    extends ResultsAccumulator {
        private final SearchEverywhereContributor<?> myExpandedContributor;
        private final int myNewLimit;
        private volatile boolean hasMore;

        ShowMoreResultsAccumulator(Map<SearchEverywhereContributor<?>, Collection<SESearcher.ElementInfo>> alreadyFound, SEResultsEqualityProvider equalityProvider, SearchEverywhereContributor<?> contributor, int newLimit, SESearcher.Listener listener2, Executor notificationExecutor) {
            super(new ConcurrentHashMap(alreadyFound), equalityProvider, listener2, notificationExecutor);
            this.myExpandedContributor = contributor;
            this.myNewLimit = newLimit;
        }

        @Override
        public boolean addElement(Object element, SearchEverywhereContributor<?> contributor, int priority, ProgressIndicator indicator) {
            assert (contributor == this.myExpandedContributor);
            Collection section = (Collection)this.sections.get(contributor);
            SESearcher.ElementInfo newElementInfo = new SESearcher.ElementInfo(element, priority, contributor);
            if (section.size() >= this.myNewLimit) {
                return false;
            }
            Map<SEResultsEqualityProvider.Action, Collection<SESearcher.ElementInfo>> otherElementsMap = this.getActionsWithOtherElements(newElementInfo);
            if (otherElementsMap.get((Object)SEResultsEqualityProvider.Action.REPLACE).isEmpty() && !otherElementsMap.get((Object)SEResultsEqualityProvider.Action.SKIP).isEmpty()) {
                LOG.debug(String.format("Element %s for contributor %s was skipped", element.toString(), contributor.getSearchProviderId()));
                return true;
            }
            section.add(newElementInfo);
            this.myNotificationExecutor.execute(() -> this.myListener.elementsAdded(Collections.singletonList(newElementInfo)));
            ArrayList<SESearcher.ElementInfo> toRemove2 = new ArrayList<SESearcher.ElementInfo>(otherElementsMap.get((Object)SEResultsEqualityProvider.Action.REPLACE));
            toRemove2.forEach(info -> {
                Collection list2 = (Collection)this.sections.get(info.getContributor());
                list2.remove(info);
                LOG.debug(String.format("Element %s for contributor %s is removed", info.getElement().toString(), info.getContributor().getSearchProviderId()));
            });
            this.myNotificationExecutor.execute(() -> this.myListener.elementsRemoved(toRemove2));
            return true;
        }

        @Override
        public void setContributorHasMore(SearchEverywhereContributor<?> contributor, boolean hasMore) {
            assert (contributor == this.myExpandedContributor);
            this.hasMore = hasMore;
        }

        @Override
        public void contributorFinished(SearchEverywhereContributor<?> contributor) {
            this.myNotificationExecutor.execute(() -> this.myListener.searchFinished(Collections.singletonMap(contributor, this.hasMore)));
        }
    }

    private static abstract class ResultsAccumulator {
        protected final Map<SearchEverywhereContributor<?>, Collection<SESearcher.ElementInfo>> sections;
        protected final SESearcher.Listener myListener;
        protected final Executor myNotificationExecutor;
        protected final SEResultsEqualityProvider myEqualityProvider;

        ResultsAccumulator(Map<SearchEverywhereContributor<?>, Collection<SESearcher.ElementInfo>> sections, SEResultsEqualityProvider equalityProvider, SESearcher.Listener listener2, Executor notificationExecutor) {
            this.sections = sections;
            this.myEqualityProvider = equalityProvider;
            this.myListener = listener2;
            this.myNotificationExecutor = notificationExecutor;
        }

        protected Map<SEResultsEqualityProvider.Action, Collection<SESearcher.ElementInfo>> getActionsWithOtherElements(SESearcher.ElementInfo newElement) {
            EnumMap<SEResultsEqualityProvider.Action, Collection<SESearcher.ElementInfo>> res2 = new EnumMap<SEResultsEqualityProvider.Action, Collection<SESearcher.ElementInfo>>(SEResultsEqualityProvider.Action.class);
            res2.put(SEResultsEqualityProvider.Action.REPLACE, new ArrayList());
            res2.put(SEResultsEqualityProvider.Action.SKIP, new ArrayList());
            this.sections.values().stream().flatMap(Collection::stream).forEach(info -> {
                SEResultsEqualityProvider.Action action = this.myEqualityProvider.compareItems(newElement, (SESearcher.ElementInfo)info);
                if (action != SEResultsEqualityProvider.Action.DO_NOTHING) {
                    ((Collection)res2.get((Object)action)).add(info);
                }
            });
            return res2;
        }

        public abstract boolean addElement(Object var1, SearchEverywhereContributor<?> var2, int var3, ProgressIndicator var4) throws InterruptedException;

        public abstract void contributorFinished(SearchEverywhereContributor<?> var1);

        public abstract void setContributorHasMore(SearchEverywhereContributor<?> var1, boolean var2);
    }

    private static class ContributorSearchTask<F>
    implements Runnable {
        private final ResultsAccumulator myAccumulator;
        private final Runnable finishCallback;
        private final SearchEverywhereContributor<F> myContributor;
        private final SearchEverywhereContributorFilter<F> filter;
        private final String myPattern;
        private final boolean myUseNonProjectItems;
        private final ProgressIndicator myIndicator;

        private ContributorSearchTask(SearchEverywhereContributor<F> contributor, String pattern, SearchEverywhereContributorFilter<F> filter, boolean everywhere, ResultsAccumulator accumulator, ProgressIndicator indicator, Runnable callback2) {
            this.myContributor = contributor;
            this.myPattern = pattern;
            this.filter = filter;
            this.myUseNonProjectItems = everywhere;
            this.myAccumulator = accumulator;
            this.myIndicator = indicator;
            this.finishCallback = callback2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.debug("Search task started for contributor ", new Object[]{this.myContributor});
            try {
                SensitiveProgressWrapper wrapperIndicator;
                boolean repeat = false;
                do {
                    wrapperIndicator = new SensitiveProgressWrapper(this.myIndicator);
                    try {
                        this.myContributor.fetchElements(this.myPattern, this.myUseNonProjectItems, this.filter, (ProgressIndicator)wrapperIndicator, element -> {
                            try {
                                if (element == null) {
                                    LOG.debug("Skip null element");
                                    return true;
                                }
                                int priority = this.myContributor.getElementPriority(element, this.myPattern);
                                boolean added = this.myAccumulator.addElement(element, this.myContributor, priority, wrapperIndicator);
                                if (!added) {
                                    this.myAccumulator.setContributorHasMore(this.myContributor, true);
                                }
                                return added;
                            }
                            catch (InterruptedException e) {
                                LOG.warn("Search task was interrupted");
                                return false;
                            }
                        });
                    }
                    catch (ProcessCanceledException processCanceledException) {
                        // empty catch block
                    }
                } while (repeat = !this.myIndicator.isCanceled() && wrapperIndicator.isCanceled());
                if (this.myIndicator.isCanceled()) {
                    return;
                }
                this.myAccumulator.contributorFinished(this.myContributor);
            }
            finally {
                this.finishCallback.run();
            }
            LOG.debug("Search task finished for contributor ", new Object[]{this.myContributor});
        }
    }
}

