/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.notification.NotificationDisplayType;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NotificationSettings {
    private final String myGroupId;
    private final NotificationDisplayType myDisplayType;
    private final boolean myShouldLog;
    private final boolean myShouldReadAloud;

    public NotificationSettings(String groupId, NotificationDisplayType displayType, boolean shouldLog, boolean shouldReadAloud) {
        this.myGroupId = groupId;
        this.myDisplayType = displayType;
        this.myShouldLog = shouldLog;
        this.myShouldReadAloud = shouldReadAloud;
    }

    @NotNull
    public String getGroupId() {
        String string = this.myGroupId;
        if (string == null) {
            NotificationSettings.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public NotificationDisplayType getDisplayType() {
        NotificationDisplayType notificationDisplayType = this.myDisplayType;
        if (notificationDisplayType == null) {
            NotificationSettings.$$$reportNull$$$0(1);
        }
        return notificationDisplayType;
    }

    public boolean isShouldLog() {
        return this.myShouldLog;
    }

    public NotificationSettings withShouldLog(boolean shouldLog) {
        return new NotificationSettings(this.myGroupId, this.myDisplayType, shouldLog, this.myShouldReadAloud);
    }

    public boolean isShouldReadAloud() {
        return this.myShouldReadAloud;
    }

    public NotificationSettings withShouldReadAloud(boolean shouldReadAloud) {
        return new NotificationSettings(this.myGroupId, this.myDisplayType, this.myShouldLog, shouldReadAloud);
    }

    public NotificationSettings withDisplayType(NotificationDisplayType displayType) {
        return new NotificationSettings(this.myGroupId, displayType, this.myShouldLog, this.myShouldReadAloud);
    }

    @Nullable
    public static NotificationSettings load(@NotNull Element element) {
        if (element == null) {
            NotificationSettings.$$$reportNull$$$0(2);
        }
        String displayTypeString = element.getAttributeValue("displayType");
        NotificationDisplayType displayType = NotificationDisplayType.BALLOON;
        boolean shouldLog = !"false".equals(element.getAttributeValue("shouldLog"));
        boolean shouldReadAloud = "true".equals(element.getAttributeValue("shouldReadAloud"));
        if ("BALLOON_ONLY".equals(displayTypeString)) {
            shouldLog = false;
            displayType = NotificationDisplayType.BALLOON;
        } else if (displayTypeString != null) {
            try {
                displayType = NotificationDisplayType.valueOf((String)displayTypeString.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        String groupId = element.getAttributeValue("groupId");
        return groupId != null ? new NotificationSettings(groupId, displayType, shouldLog, shouldReadAloud) : null;
    }

    @NotNull
    public Element save() {
        Element result2 = new Element("notification");
        result2.setAttribute("groupId", this.getGroupId());
        NotificationDisplayType displayType = this.getDisplayType();
        if (displayType != NotificationDisplayType.BALLOON) {
            result2.setAttribute("displayType", displayType.toString());
        }
        if (!this.myShouldLog) {
            result2.setAttribute("shouldLog", "false");
        }
        if (this.myShouldReadAloud) {
            result2.setAttribute("shouldReadAloud", "true");
        }
        Element element = result2;
        if (element == null) {
            NotificationSettings.$$$reportNull$$$0(3);
        }
        return element;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NotificationSettings)) {
            return false;
        }
        NotificationSettings settings = (NotificationSettings)o;
        if (this.myShouldLog != settings.myShouldLog) {
            return false;
        }
        if (this.myShouldReadAloud != settings.myShouldReadAloud) {
            return false;
        }
        if (this.myDisplayType != settings.myDisplayType) {
            return false;
        }
        return this.myGroupId.equals(settings.myGroupId);
    }

    public int hashCode() {
        int result2 = this.myGroupId.hashCode();
        result2 = 31 * result2 + this.myDisplayType.hashCode();
        result2 = 31 * result2 + (this.myShouldLog ? 1 : 0);
        result2 = 31 * result2 + (this.myShouldReadAloud ? 1 : 0);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/notification/impl/NotificationSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/notification/impl/NotificationSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "save";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

