/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.Gray;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.border.Border;

abstract class ContentLayout {
    static final Color TAB_BORDER_ACTIVE_WINDOW = new Color(38, 63, 106);
    static final Color TAB_BORDER_PASSIVE_WINDOW = new Color(130, 120, 111);
    static final Color TAB_BG_ACTIVE_WND_SELECTED_FROM = Gray._111;
    static final Color TAB_BG_ACTIVE_WND_SELECTED_TO = Gray._164;
    static final Color TAB_BG_ACTIVE_WND_UNSELECTED_FROM = Gray._130;
    static final Color TAB_BG_ACTIVE_WND_UNSELECTED_TO = Gray._85;
    static final Color TAB_BG_PASSIVE_WND_FROM = new Color(152, 143, 134);
    static final Color TAB_BG_PASSIVE_WND_TO = new Color(165, 157, 149);
    static final int TAB_ARC = 2;
    static final int TAB_SHIFT = 2;
    ToolWindowContentUi myUi;
    BaseLabel myIdLabel;

    ContentLayout(ToolWindowContentUi ui) {
        this.myUi = ui;
    }

    public abstract void init();

    public abstract void reset();

    public abstract void layout();

    public abstract void paintComponent(Graphics var1);

    public abstract void paintChildren(Graphics var1);

    public abstract void update();

    public abstract void rebuild();

    public abstract int getMinimumWidth();

    public abstract void contentAdded(ContentManagerEvent var1);

    public abstract void contentRemoved(ContentManagerEvent var1);

    protected void updateIdLabel(BaseLabel label2) {
        String title = this.myUi.myWindow.getStripeTitle();
        String suffix = this.getTitleSuffix();
        if (suffix != null) {
            title = title + suffix;
        }
        label2.setText(title);
        label2.setBorder((Border)JBUI.Borders.empty((int)0, (int)2, (int)0, (int)7));
        label2.setVisible(this.shouldShowId());
    }

    private String getTitleSuffix() {
        switch (this.myUi.myManager.getContentCount()) {
            case 0: {
                return null;
            }
            case 1: {
                Content content = this.myUi.myManager.getContent(0);
                if (content == null) {
                    return null;
                }
                String text = content.getDisplayName();
                if (text != null && text.trim().length() > 0 && this.myUi.myManager.canCloseContents()) {
                    return ":";
                }
                return null;
            }
        }
        return ":";
    }

    protected void fillTabShape(Graphics2D g2d, Shape shape, boolean isSelected, Rectangle bounds2) {
        if (this.myUi.myWindow.isActive()) {
            if (isSelected) {
                g2d.setPaint(UIUtil.getGradientPaint((float)bounds2.x, (float)bounds2.y, (Color)TAB_BG_ACTIVE_WND_SELECTED_FROM, (float)bounds2.x, (float)((float)bounds2.getMaxY()), (Color)TAB_BG_ACTIVE_WND_SELECTED_TO));
            } else {
                g2d.setPaint(UIUtil.getGradientPaint((float)bounds2.x, (float)bounds2.y, (Color)TAB_BG_ACTIVE_WND_UNSELECTED_FROM, (float)bounds2.x, (float)((float)bounds2.getMaxY()), (Color)TAB_BG_ACTIVE_WND_UNSELECTED_TO));
            }
        } else {
            g2d.setPaint(UIUtil.getGradientPaint((float)bounds2.x, (float)bounds2.y, (Color)TAB_BG_PASSIVE_WND_FROM, (float)bounds2.x, (float)((float)bounds2.getMaxY()), (Color)TAB_BG_PASSIVE_WND_TO));
        }
        g2d.fill(shape);
    }

    public abstract void showContentPopup(ListPopup var1);

    public abstract RelativeRectangle getRectangleFor(Content var1);

    public abstract Component getComponentFor(Content var1);

    public abstract String getCloseActionName();

    public abstract String getCloseAllButThisActionName();

    public abstract String getPreviousContentActionName();

    public abstract String getNextContentActionName();

    protected boolean shouldShowId() {
        JComponent component = this.myUi.myWindow.getComponent();
        return component != null && !"true".equals(component.getClientProperty("HideIdLabel"));
    }

    boolean isIdVisible() {
        return this.myIdLabel.isVisible();
    }
}

