/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class PendingTasksRunner {
    private final List<Runnable> myPendingTasks;
    private final AtomicBoolean myReady;
    private final Alarm myAlarm;

    /*
     * WARNING - void declaration
     */
    public PendingTasksRunner(long awaitTimeout, @NotNull Project project) {
        void project2;
        if (project == null) {
            PendingTasksRunner.$$$reportNull$$$0(0);
        }
        this.myPendingTasks = new ArrayList<Runnable>();
        this.myReady = new AtomicBoolean(false);
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)project2);
        this.myAlarm.addRequest(() -> this.setReady(), awaitTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(@NotNull Runnable task) {
        if (task == null) {
            PendingTasksRunner.$$$reportNull$$$0(1);
        }
        if (this.myReady.get()) {
            task.run();
        } else {
            List<Runnable> list2 = this.myPendingTasks;
            synchronized (list2) {
                this.myPendingTasks.add(task);
            }
            if (this.myReady.get()) {
                this.runPendingTasks();
            }
        }
    }

    public void setReady() {
        if (this.myReady.compareAndSet(false, true)) {
            Disposer.dispose((Disposable)this.myAlarm);
            this.runPendingTasks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPendingTasks() {
        ArrayList<Runnable> tasks;
        List<Runnable> list2 = this.myPendingTasks;
        synchronized (list2) {
            tasks = new ArrayList<Runnable>(this.myPendingTasks);
            this.myPendingTasks.clear();
        }
        for (Runnable task : tasks) {
            task.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        objectArray2[1] = "com/intellij/terminal/PendingTasksRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

