/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.injection;

import com.intellij.lang.Language;
import com.intellij.lexer.EmbeddedTokenTypesProvider;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.intellij.plugins.markdown.injection.CodeFenceLanguageProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum LanguageGuesser {
    INSTANCE;

    private final NotNullLazyValue<List<EmbeddedTokenTypesProvider>> embeddedTokenTypeProviders = new NotNullLazyValue<List<EmbeddedTokenTypesProvider>>(){

        @NotNull
        protected List<EmbeddedTokenTypesProvider> compute() {
            List list = EmbeddedTokenTypesProvider.EXTENSION_POINT_NAME.getExtensionList();
            if (list == null) {
                1.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/injection/LanguageGuesser$1", "compute"));
        }
    };
    private final ClearableLazyValue<List<CodeFenceLanguageProvider>> codeFenceLanguageProviders = new ClearableLazyValue<List<CodeFenceLanguageProvider>>(){

        @NotNull
        protected List<CodeFenceLanguageProvider> compute() {
            List list = CodeFenceLanguageProvider.EP_NAME.getExtensionList();
            if (list == null) {
                2.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/injection/LanguageGuesser$2", "compute"));
        }
    };
    private final NotNullLazyValue<Map<String, Language>> langIdToLanguage = new NotNullLazyValue<Map<String, Language>>(){

        @NotNull
        protected Map<String, Language> compute() {
            HashMap<String, Language> result = new HashMap<String, Language>();
            for (Language language : Language.getRegisteredLanguages()) {
                if (language.getID().isEmpty()) continue;
                result.put(language.getID().toLowerCase(Locale.US), language);
            }
            Language javascriptLanguage = (Language)result.get("javascript");
            if (javascriptLanguage != null) {
                result.put("js", javascriptLanguage);
            }
            HashMap<String, Language> hashMap = result;
            if (hashMap == null) {
                3.$$$reportNull$$$0(0);
            }
            return hashMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/injection/LanguageGuesser$3", "compute"));
        }
    };

    @NotNull
    public Map<String, Language> getLangToLanguageMap() {
        Map<String, Language> map = Collections.unmodifiableMap((Map)this.langIdToLanguage.getValue());
        if (map == null) {
            LanguageGuesser.$$$reportNull$$$0(0);
        }
        return map;
    }

    @NotNull
    public List<CodeFenceLanguageProvider> getCodeFenceLanguageProviders() {
        List list = (List)this.codeFenceLanguageProviders.getValue();
        if (list == null) {
            LanguageGuesser.$$$reportNull$$$0(1);
        }
        return list;
    }

    public void resetCodeFenceLanguageProviders() {
        this.codeFenceLanguageProviders.drop();
    }

    @Nullable
    public Language guessLanguage(@NotNull String languageName) {
        if (languageName == null) {
            LanguageGuesser.$$$reportNull$$$0(2);
        }
        for (CodeFenceLanguageProvider provider : (List)this.codeFenceLanguageProviders.getValue()) {
            Language languageByProvider = provider.getLanguageByInfoString(languageName);
            if (languageByProvider == null) continue;
            return languageByProvider;
        }
        Language languageFromMap = (Language)((Map)this.langIdToLanguage.getValue()).get(languageName.toLowerCase(Locale.US));
        if (languageFromMap != null) {
            return languageFromMap;
        }
        for (EmbeddedTokenTypesProvider provider : (List)this.embeddedTokenTypeProviders.getValue()) {
            if (!provider.getName().equalsIgnoreCase(languageName)) continue;
            return provider.getElementType().getLanguage();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/markdown/injection/LanguageGuesser";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLangToLanguageMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeFenceLanguageProviders";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/markdown/injection/LanguageGuesser";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "guessLanguage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

