/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlExecutionFlowAnalyzer;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.ThreeState;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DatabaseAccessController {
    @NotNull
    public Token requestAccess(@NotNull String var1);

    @NotNull
    public static DatabaseAccessController alwaysSuccess() {
        DatabaseAccessController databaseAccessController = query -> Token.success();
        if (databaseAccessController == null) {
            DatabaseAccessController.$$$reportNull$$$0(0);
        }
        return databaseAccessController;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/DatabaseAccessController", "alwaysSuccess"));
    }

    public static class Token {
        public final boolean success;
        public final String message;
        public final String logMessage;

        Token(@Nullable String message2, @Nullable String logMessage, boolean success) {
            this.success = success;
            this.message = message2;
            this.logMessage = logMessage;
        }

        @NotNull
        static Token success() {
            Token token = new Token(null, null, true);
            if (token == null) {
                Token.$$$reportNull$$$0(0);
            }
            return token;
        }

        static Token rejected(@NotNull String message2, @NotNull String logMessage) {
            if (message2 == null) {
                Token.$$$reportNull$$$0(1);
            }
            if (logMessage == null) {
                Token.$$$reportNull$$$0(2);
            }
            return new Token(message2, logMessage, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/DatabaseAccessController$Token";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "success";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/DatabaseAccessController$Token";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "rejected";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class PsiBasedReadOnly
    implements DatabaseAccessController {
        private final Project myProject;
        private final SqlLanguageDialect myLanguage;
        private final DbDataSource mySource;
        private final Supplier<SearchPath> myPath;

        public PsiBasedReadOnly(@NotNull Project project, @NotNull SqlLanguageDialect language, @NotNull DbDataSource source, @NotNull Supplier<SearchPath> path) {
            if (project == null) {
                PsiBasedReadOnly.$$$reportNull$$$0(0);
            }
            if (language == null) {
                PsiBasedReadOnly.$$$reportNull$$$0(1);
            }
            if (source == null) {
                PsiBasedReadOnly.$$$reportNull$$$0(2);
            }
            if (path == null) {
                PsiBasedReadOnly.$$$reportNull$$$0(3);
            }
            this.myProject = project;
            this.myLanguage = language;
            this.mySource = source;
            this.myPath = path;
        }

        @Override
        @NotNull
        public Token requestAccess(@NotNull String query) {
            SqlExecutionFlowAnalyzer analyzer;
            SqlExecutionFlowAnalyzer.Flow first;
            if (query == null) {
                PsiBasedReadOnly.$$$reportNull$$$0(4);
            }
            Couple message2 = (first = (SqlExecutionFlowAnalyzer.Flow)this.traverser(query, (SqlExecutionFlowAnalyzer<PsiElement>)(analyzer = SqlPsiFacade.getInstance((Project)this.myProject).getExecutionFlowAnalyzer())).traverse().filter(e -> analyzer.isAcceptable(e)).map(e -> analyzer.analyze(e)).filter(Conditions.notNull()).filter(f -> f.isPure() != ThreeState.YES).first()) == null ? null : (Couple)first.transform((SqlExecutionFlowAnalyzer.FlowTransformer)MyTransformer.INSTANCE);
            Token token = message2 == null ? Token.success() : Token.rejected((String)message2.first, (String)message2.second);
            if (token == null) {
                PsiBasedReadOnly.$$$reportNull$$$0(5);
            }
            return token;
        }

        @NotNull
        private SyntaxTraverser<PsiElement> traverser(@NotNull CharSequence text2, @NotNull SqlExecutionFlowAnalyzer<PsiElement> analyzer) {
            if (text2 == null) {
                PsiBasedReadOnly.$$$reportNull$$$0(6);
            }
            if (analyzer == null) {
                PsiBasedReadOnly.$$$reportNull$$$0(7);
            }
            SqlFile psi = SqlPsiFacade.getInstance((Project)this.myProject).createROFile(this.myLanguage, text2);
            psi.putUserData(DatabaseDataKeys.DATA_SOURCE_KEY, (Object)this.mySource);
            psi.putUserData(DatabaseDataKeys.SEARCH_PATH_KEY, (Object)this.myPath.get());
            SyntaxTraverser syntaxTraverser = (SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)psi).expand(e -> {
                if (analyzer == null) {
                    PsiBasedReadOnly.$$$reportNull$$$0(9);
                }
                return !analyzer.isAcceptable(e);
            });
            if (syntaxTraverser == null) {
                PsiBasedReadOnly.$$$reportNull$$$0(8);
            }
            return syntaxTraverser;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "query";
                    break;
                }
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/DatabaseAccessController$PsiBasedReadOnly";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "analyzer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/DatabaseAccessController$PsiBasedReadOnly";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "requestAccess";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "traverser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "requestAccess";
                    break;
                }
                case 5: 
                case 8: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "traverser";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$traverser$3";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class MyTransformer
        implements SqlExecutionFlowAnalyzer.FlowTransformer<Couple<String>> {
            static final MyTransformer INSTANCE = new MyTransformer();
            static final String DML = "%s to execute a statement that leads to modification of data during a read-only connection";
            static final String DDL = "%s to execute a DDL statement during a read-only connection";
            static final String ROUTINE = "%s to execute a routine that may cause side effects during a read-only connection";
            static final String COMMON = "%s to execute a statement that may cause side effects during a read-only connection";

            private MyTransformer() {
            }

            public Couple<String> common() {
                return MyTransformer.messages(COMMON);
            }

            public Couple<String> dml() {
                return MyTransformer.messages(DML);
            }

            public Couple<String> ddl() {
                return MyTransformer.messages(DDL);
            }

            public Couple<String> routine() {
                return MyTransformer.messages(ROUTINE);
            }

            @NotNull
            private static Couple<String> messages(@NotNull String mask) {
                if (mask == null) {
                    MyTransformer.$$$reportNull$$$0(0);
                }
                Couple couple = Couple.of((Object)String.format(mask, "You are attempting"), (Object)String.format(mask, "Attempt"));
                if (couple == null) {
                    MyTransformer.$$$reportNull$$$0(1);
                }
                return couple;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "mask";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/console/DatabaseAccessController$PsiBasedReadOnly$MyTransformer";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/console/DatabaseAccessController$PsiBasedReadOnly$MyTransformer";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "messages";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "messages";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }

    public static class DataSourceBased
    implements DatabaseAccessController {
        private final DbDataSource myDataSource;
        private final DatabaseAccessController myDelegate;

        public DataSourceBased(@NotNull DbDataSource source, @NotNull DatabaseAccessController delegate) {
            if (source == null) {
                DataSourceBased.$$$reportNull$$$0(0);
            }
            if (delegate == null) {
                DataSourceBased.$$$reportNull$$$0(1);
            }
            this.myDataSource = source;
            this.myDelegate = delegate;
        }

        @Override
        @NotNull
        public Token requestAccess(@NotNull String query) {
            if (query == null) {
                DataSourceBased.$$$reportNull$$$0(2);
            }
            Token token = this.myDataSource.isWritable() ? Token.success() : this.myDelegate.requestAccess(query);
            if (token == null) {
                DataSourceBased.$$$reportNull$$$0(3);
            }
            return token;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "query";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/DatabaseAccessController$DataSourceBased";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/DatabaseAccessController$DataSourceBased";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "requestAccess";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "requestAccess";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

