/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgres.model;

import com.intellij.database.dialects.postgres.model.PgCheck;
import com.intellij.database.dialects.postgres.model.PgForeignTableColumn;
import com.intellij.database.dialects.postgres.model.PgRule;
import com.intellij.database.dialects.postgres.model.PgSchema;
import com.intellij.database.dialects.postgres.model.PgTable;
import com.intellij.database.dialects.postgres.model.PgTrigger;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.properties.PropertyConverter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PgForeignTable
extends PgTable {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.FOREIGN_TABLE;
        if (objectKind == null) {
            PgForeignTable.$$$reportNull$$$0(0);
        }
        return objectKind;
    }

    @Override
    @Nullable
    public PgSchema getSchema();

    @Override
    @Nullable
    default public PgSchema getParent() {
        return this.getSchema();
    }

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends PgForeignTable> getParentFamily() {
        return null;
    }

    @Override
    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends PgRule> getRules();

    @NotNull
    public @NotNull PositioningNamingFamily<@NotNull ? extends PgForeignTableColumn> getColumns();

    @Override
    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends PgCheck> getChecks();

    @Override
    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends PgTrigger> getTriggers();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Arrays.asList(ObjectKind.RULE, ObjectKind.COLUMN, ObjectKind.CHECK, ObjectKind.TRIGGER);
        if (list == null) {
            PgForeignTable.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List<Family> list = Arrays.asList(this.getRules(), this.getColumns(), this.getChecks(), this.getTriggers());
        if (list == null) {
            PgForeignTable.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    @Nullable
    default public String getOwner() {
        return null;
    }

    @Override
    default public boolean isFaceless() {
        return false;
    }

    @Override
    default public boolean isSystem() {
        return false;
    }

    @Override
    default public long getStateNumber() {
        return 0L;
    }

    @Override
    default public boolean isTemporary() {
        return false;
    }

    @Override
    @NotNull
    default public List<Long> getAncestorIds() {
        List<Long> list = Collections.emptyList();
        if (list == null) {
            PgForeignTable.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @NotNull
    default public Set<Long> getSuccessorIds() {
        Set<Long> set = Collections.emptySet();
        if (set == null) {
            PgForeignTable.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Override
    default public boolean isPartitioned() {
        return false;
    }

    @Override
    default public boolean isPartition() {
        return false;
    }

    @Override
    @Nullable
    default public String getPartitionKey() {
        return null;
    }

    @Override
    @Nullable
    default public String getPartitionExpression() {
        return null;
    }

    @Nullable
    default public String getServer() {
        return null;
    }

    @NotNull
    default public List<String> getOptions() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            PgForeignTable.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer2) {
        List<String> options;
        String server;
        String partitionExpression;
        String partitionKey;
        boolean partition;
        boolean partitioned;
        Set<Long> successorIds;
        List<Long> ancestorIds;
        boolean temporary;
        long stateNumber;
        boolean system;
        boolean faceless;
        String owner;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name;
        long objectId;
        if (consumer2 == null) {
            PgForeignTable.$$$reportNull$$$0(6);
        }
        if ((objectId = this.getObjectId()) != Long.MIN_VALUE) {
            consumer2.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer2.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer2.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer2.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer2.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer2.accept("Comment", PropertyConverter.export(comment));
        }
        if ((owner = this.getOwner()) != null) {
            consumer2.accept("Owner", PropertyConverter.export(owner));
        }
        if (faceless = this.isFaceless()) {
            consumer2.accept("Faceless", PropertyConverter.export(faceless));
        }
        if (system = this.isSystem()) {
            consumer2.accept("System", PropertyConverter.export(system));
        }
        if ((stateNumber = this.getStateNumber()) != 0L) {
            consumer2.accept("StateNumber", PropertyConverter.export(stateNumber));
        }
        if (temporary = this.isTemporary()) {
            consumer2.accept("Temporary", PropertyConverter.export(temporary));
        }
        if (!(ancestorIds = this.getAncestorIds()).isEmpty()) {
            consumer2.accept("AncestorIds", PropertyConverter.exportListOfLong(ancestorIds));
        }
        if (!(successorIds = this.getSuccessorIds()).isEmpty()) {
            consumer2.accept("SuccessorIds", PropertyConverter.exportSetOfLong(successorIds));
        }
        if (partitioned = this.isPartitioned()) {
            consumer2.accept("Partitioned", PropertyConverter.export(partitioned));
        }
        if (partition = this.isPartition()) {
            consumer2.accept("Partition", PropertyConverter.export(partition));
        }
        if ((partitionKey = this.getPartitionKey()) != null) {
            consumer2.accept("PartitionKey", PropertyConverter.export(partitionKey));
        }
        if ((partitionExpression = this.getPartitionExpression()) != null) {
            consumer2.accept("PartitionExpression", PropertyConverter.export(partitionExpression));
        }
        if ((server = this.getServer()) != null) {
            consumer2.accept("Server", PropertyConverter.export(server));
        }
        if (!(options = this.getOptions()).isEmpty()) {
            consumer2.accept("Options", PropertyConverter.exportListOfString(options));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "Owner", "Faceless", "System", "StateNumber", "Temporary", "AncestorIds", "SuccessorIds", "Partitioned", "Partition", "PartitionKey", "PartitionExpression", "Server", "Options");
        if (list == null) {
            PgForeignTable.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/postgres/model/PgForeignTable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAncestorIds";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuccessorIds";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/postgres/model/PgForeignTable";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNames";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

