/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.basic;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.properties.SourceError;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.script.SingleFragmentText;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BasicModSourceAware
extends BasicSourceAware,
BasicModElement {
    public void setSourceTextLength(int var1);

    default public void setSourceText(@Nullable CompositeText sourceText) {
        BasicModel model = this.getModel();
        this.setSourceTextLength(sourceText != null ? sourceText.getLength() : 0);
        model.saveSourceText(this, sourceText);
    }

    @Deprecated
    default public void setOriginalSourceText(@Nullable String sourceText) {
        BasicModel model = this.getModel();
        if (sourceText != null && sourceText.length() > 0) {
            this.setSourceTextLength(sourceText.length());
            model.saveSourceText(this, new SimpleCompositeText(sourceText, CompositeText.Kind.ORIGINAL_TEXT));
        } else {
            this.setSourceTextLength(0);
            model.saveSourceText(this, null);
        }
    }

    @Override
    @Nullable
    default public CompositeText getSourceText() {
        int length = this.getSourceTextLength();
        if (length == 0) {
            return null;
        }
        BasicModel model = this.getModel();
        CompositeText compositeText = model.loadSourceText(this);
        if (compositeText == null || compositeText.getLength() < 3) {
            String ersatz = String.format("-- The source text lost (family: %s, kind: %s, name:%s, source text length: %d)", model.getDbms().getName(), this.getKind().code(), this.getRealName(), length);
            return new SingleFragmentText(ersatz, CompositeText.Kind.COMMENT);
        }
        return compositeText;
    }

    default public void setInvalid(boolean invalid) {
    }

    default public void setErrors(@NotNull List<SourceError> errors) {
        if (errors == null) {
            BasicModSourceAware.$$$reportNull$$$0(0);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/database/model/basic/BasicModSourceAware", "setErrors"));
    }
}

