/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.mq;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.mq.MqPatchDetails;
import org.zmlx.hg4idea.util.HgUtil;

public class HgMqAdditionalPatchReader {
    private static final String NODE_ID = "# Node ID ";
    private static final String PARENT_ID = "# Parent ";
    private static final String DATE = "# Date ";
    private static final String BRANCH = "# Branch ";
    private static final String USER = "# User ";
    private static final String DIFF_INFO = "diff -";

    @NotNull
    public static MqPatchDetails readMqPatchInfo(@Nullable VirtualFile root, @Nullable File patchFile) {
        if (patchFile == null) {
            MqPatchDetails mqPatchDetails = MqPatchDetails.EMPTY_PATCH_DETAILS;
            if (mqPatchDetails == null) {
                HgMqAdditionalPatchReader.$$$reportNull$$$0(0);
            }
            return mqPatchDetails;
        }
        String context = DvcsUtil.tryLoadFileOrReturn((File)patchFile, (String)"");
        MqPatchDetails mqPatchDetails = HgMqAdditionalPatchReader.parseAdditionalMqInfo(root == null ? HgUtil.getNearestHgRoot(VfsUtil.findFileByIoFile((File)patchFile, (boolean)true)) : root, context);
        if (mqPatchDetails == null) {
            HgMqAdditionalPatchReader.$$$reportNull$$$0(1);
        }
        return mqPatchDetails;
    }

    @NotNull
    private static MqPatchDetails parseAdditionalMqInfo(@Nullable VirtualFile root, @NotNull String context) {
        if (context == null) {
            HgMqAdditionalPatchReader.$$$reportNull$$$0(2);
        }
        String[] lines = StringUtil.splitByLines((String)context, (boolean)false);
        String user = null;
        Date date = null;
        String branch = null;
        ArrayList messageLines = ContainerUtil.newArrayList();
        String nodeId = null;
        String parent = null;
        for (String line : lines) {
            if (line.startsWith(DIFF_INFO)) break;
            if (line.startsWith(NODE_ID)) {
                nodeId = HgMqAdditionalPatchReader.extractField(line, NODE_ID);
                continue;
            }
            if (line.startsWith(PARENT_ID)) {
                parent = HgMqAdditionalPatchReader.extractField(line, PARENT_ID);
                continue;
            }
            if (line.startsWith(DATE)) {
                date = HgMqAdditionalPatchReader.tryParseDate(HgMqAdditionalPatchReader.extractField(line, DATE));
                continue;
            }
            if (line.startsWith(BRANCH)) {
                branch = HgMqAdditionalPatchReader.extractField(line, BRANCH);
                continue;
            }
            if (line.startsWith(USER)) {
                user = HgMqAdditionalPatchReader.extractField(line, USER);
                continue;
            }
            if (line.startsWith("# ")) continue;
            messageLines.add(line);
        }
        MqPatchDetails mqPatchDetails = new MqPatchDetails(nodeId, parent, date, root, branch, StringUtil.join((Collection)messageLines, (String)"\n"), user);
        if (mqPatchDetails == null) {
            HgMqAdditionalPatchReader.$$$reportNull$$$0(3);
        }
        return mqPatchDetails;
    }

    @NotNull
    private static String extractField(@NotNull String line, @NotNull String prefix) {
        if (line == null) {
            HgMqAdditionalPatchReader.$$$reportNull$$$0(4);
        }
        if (prefix == null) {
            HgMqAdditionalPatchReader.$$$reportNull$$$0(5);
        }
        String string = line.substring(prefix.length()).trim();
        if (string == null) {
            HgMqAdditionalPatchReader.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    private static Date tryParseDate(@NotNull String substring) {
        if (substring == null) {
            HgMqAdditionalPatchReader.$$$reportNull$$$0(7);
        }
        try {
            return new Date(NumberFormat.getInstance().parse(substring).longValue() * 1000L);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public boolean isMqPatch(@NotNull File file) {
        if (file == null) {
            HgMqAdditionalPatchReader.$$$reportNull$$$0(8);
        }
        return DvcsUtil.tryLoadFileOrReturn((File)file, (String)"").startsWith("# HG changeset patch");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/mq/HgMqAdditionalPatchReader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substring";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "readMqPatchInfo";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/mq/HgMqAdditionalPatchReader";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAdditionalMqInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "extractField";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseAdditionalMqInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "extractField";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "tryParseDate";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isMqPatch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

