/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.v8.protocol;

import gnu.trove.TIntObjectHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.jsonProtocol.JsonParseMethod;
import org.jetbrains.v8.protocol.AfterCompileBody;
import org.jetbrains.v8.protocol.BacktraceCommandBody;
import org.jetbrains.v8.protocol.BreakEventBody;
import org.jetbrains.v8.protocol.ChangeLiveBody;
import org.jetbrains.v8.protocol.ContextData;
import org.jetbrains.v8.protocol.FlagsBody;
import org.jetbrains.v8.protocol.FrameInfo;
import org.jetbrains.v8.protocol.IncomingMessage;
import org.jetbrains.v8.protocol.ProtocolResponseReader;
import org.jetbrains.v8.protocol.RestartFrameBody;
import org.jetbrains.v8.protocol.ScopeBody;
import org.jetbrains.v8.protocol.ScriptCollectedBody;
import org.jetbrains.v8.protocol.ScriptHandle;
import org.jetbrains.v8.protocol.ValueHandle;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H'J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H'J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H'J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H'J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H'J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H'J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0007H'J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u0007H'J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u0007H'J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u0007H'J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0006\u001a\u00020\u0007H'J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0006\u001a\u00020\u0007H'J\u0010\u0010%\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u0007H'\u00a8\u0006&"}, d2={"Lorg/jetbrains/v8/protocol/V8ProtocolReader;", "Lorg/jetbrains/v8/protocol/ProtocolResponseReader;", "()V", "asScripts", "", "Lorg/jetbrains/v8/protocol/ScriptHandle;", "reader", "Lorg/jetbrains/io/JsonReaderEx;", "readAfterCompile", "Lorg/jetbrains/v8/protocol/AfterCompileBody;", "readBacktraceResult", "Lorg/jetbrains/v8/protocol/BacktraceCommandBody;", "readBreakEvent", "Lorg/jetbrains/v8/protocol/BreakEventBody;", "readChangeLive", "Lorg/jetbrains/v8/protocol/ChangeLiveBody;", "readContextData", "Lorg/jetbrains/v8/protocol/ContextData;", "readFlagsResult", "Lorg/jetbrains/v8/protocol/FlagsBody;", "readFrameResult", "Lorg/jetbrains/v8/protocol/FrameInfo;", "readIncomingMessage", "Lorg/jetbrains/v8/protocol/IncomingMessage;", "readLookupResult", "Lgnu/trove/TIntObjectHashMap;", "Lorg/jetbrains/v8/protocol/ValueHandle;", "readRestartFrameResult", "Lorg/jetbrains/v8/protocol/RestartFrameBody;", "readResult", "", "methodName", "", "readScopeResult", "Lorg/jetbrains/v8/protocol/ScopeBody;", "readScriptCollected", "Lorg/jetbrains/v8/protocol/ScriptCollectedBody;", "readValueHandle", "intellij.javascript.v8.protocol"})
public abstract class V8ProtocolReader
implements ProtocolResponseReader {
    @JsonParseMethod
    @NotNull
    public abstract IncomingMessage readIncomingMessage(@NotNull JsonReaderEx var1);

    @JsonParseMethod
    @NotNull
    public abstract ContextData readContextData(@NotNull JsonReaderEx var1);

    @JsonParseMethod
    @NotNull
    public abstract ValueHandle readValueHandle(@NotNull JsonReaderEx var1);

    @JsonParseMethod
    @NotNull
    public abstract ScopeBody readScopeResult(@NotNull JsonReaderEx var1);

    @JsonParseMethod
    @NotNull
    public abstract List<ScriptHandle> asScripts(@NotNull JsonReaderEx var1);

    @JsonParseMethod
    @NotNull
    public abstract FlagsBody readFlagsResult(@NotNull JsonReaderEx var1);

    @JsonParseMethod
    @NotNull
    public abstract RestartFrameBody readRestartFrameResult(@NotNull JsonReaderEx var1);

    @JsonParseMethod
    @NotNull
    public abstract BacktraceCommandBody readBacktraceResult(@NotNull JsonReaderEx var1);

    @JsonParseMethod
    @NotNull
    public abstract BreakEventBody readBreakEvent(@NotNull JsonReaderEx var1);

    @JsonParseMethod
    @NotNull
    public abstract ScriptCollectedBody readScriptCollected(@NotNull JsonReaderEx var1);

    @JsonParseMethod
    @NotNull
    public abstract AfterCompileBody readAfterCompile(@NotNull JsonReaderEx var1);

    @JsonParseMethod
    @NotNull
    public abstract FrameInfo readFrameResult(@NotNull JsonReaderEx var1);

    @JsonParseMethod
    @NotNull
    public abstract ChangeLiveBody readChangeLive(@NotNull JsonReaderEx var1);

    @Override
    @Nullable
    public Object readResult(@NotNull String methodName, @NotNull JsonReaderEx reader) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)methodName, (String)"methodName");
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        switch (methodName) {
            case "scope": {
                object = this.readScopeResult(reader);
                break;
            }
            case "lookup": {
                object = this.readLookupResult(reader);
                break;
            }
            case "evaluate": {
                JsonReaderEx subReader = reader.subReader();
                if (subReader != null) {
                    subReader.beginObject();
                    String nextName = subReader.nextName();
                    if (Intrinsics.areEqual((Object)"result", (Object)nextName) || Intrinsics.areEqual((Object)"objects", (Object)nextName)) {
                        return ProtocolResponseReader.DefaultImpls.readResult(this, methodName, reader);
                    }
                }
                object = this.readValueHandle(reader);
                break;
            }
            case "setVariableValue": {
                reader.beginObject();
                while (reader.hasNext()) {
                    CharSequence name = reader.nextNameAsCharSequence();
                    if (!Intrinsics.areEqual((Object)name, (Object)"newValue")) continue;
                    return this.readValueHandle(reader);
                }
                reader.endObject();
                object = Unit.INSTANCE;
                break;
            }
            case "scripts": {
                object = this.asScripts(reader);
                break;
            }
            case "flags": {
                object = this.readFlagsResult(reader);
                break;
            }
            case "restartframe": {
                object = this.readRestartFrameResult(reader);
                break;
            }
            case "backtrace": {
                object = this.readBacktraceResult(reader);
                break;
            }
            case "frame": {
                object = this.readFrameResult(reader);
                break;
            }
            case "changelive": {
                object = this.readChangeLive(reader);
                break;
            }
            default: {
                object = ProtocolResponseReader.DefaultImpls.readResult(this, methodName, reader);
            }
        }
        return object;
    }

    @NotNull
    public final TIntObjectHashMap<ValueHandle> readLookupResult(@NotNull JsonReaderEx reader) {
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        TIntObjectHashMap map = new TIntObjectHashMap();
        reader.beginObject();
        while (reader.hasNext()) {
            map.put(Integer.parseInt(reader.nextName()), (Object)this.readValueHandle(reader));
        }
        reader.endObject();
        return map;
    }
}

