/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.bundler;

import b.h.la;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionMode;
import com.intellij.execution.ExecutionModes;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PairConsumer;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.gem.bundler.BundlerGemDependencyResolver;
import org.jetbrains.plugins.ruby.gem.bundler.BundlerGitLockReader;
import org.jetbrains.plugins.ruby.gem.module.GemInfrastructure;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.gem.util.GemDependencyResolver;
import org.jetbrains.plugins.ruby.gem.util.GemSearchUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;

public class BundlerGemInfrastructure
extends GemInfrastructure {
    private static final Key<Boolean> c;
    public static final String GEMFILE_HAS_MISSING_GEMS_ID = "GEMFILE_HAS_MISSING_GEMS";
    private static final Logger b;
    private static final PairConsumer<ExecutionMode, String> a;
    private static final long d;

    @Override
    public boolean isApplicable(Module module) {
        return BundlerUtil.hasGemfile(module);
    }

    @Override
    public GemDependencyResolver getDependencyResolver(@NotNull Module module, Collection<GemInfo> sdkGems, Set<GemDependency> dependencies) {
        BundlerGitLockReader bundlerGitLockReader;
        if (module == null) {
            BundlerGemInfrastructure.b(0);
        }
        if (!(bundlerGitLockReader = BundlerGitLockReader.getInstance(module)).isLocked()) {
            return super.getDependencyResolver(module, sdkGems, dependencies);
        }
        HashMap<String, GemDependency> hashMap = new HashMap<String, GemDependency>();
        for (GemDependency object : dependencies) {
            hashMap.put(object.getName(), object);
        }
        for (Map.Entry entry : bundlerGitLockReader.getDependencies().entrySet()) {
            if (hashMap.containsKey(entry.getKey())) continue;
            hashMap.put((String)entry.getKey(), (GemDependency)entry.getValue());
        }
        return new BundlerGemDependencyResolver(module, sdkGems, new HashSet<GemDependency>(hashMap.values()));
    }

    @Override
    protected void runInstall(Module module, Sdk sdk, Collection<GemDependency> dependencies, Runnable callback) {
        long l2 = d ^ 0x249DDFE5D36L;
        if (BundlerUtil.hasGemfile(module)) {
            int n2;
            GemInfo gemInfo = GemSearchUtil.findGem(module, sdk, "bundler");
            if (!BundlerUtil.isNewBundler(gemInfo) && (n2 = Messages.showYesNoDialog((Project)module.getProject(), (String)"No bundler gem found, but Gemfile is present. \nWould you like to install bundler and use it to install missing gems?", (String)"No Bundler Gem Found", (Icon)Messages.getQuestionIcon())) == 0 && !BundlerUtil.installBundler(module, sdk)) {
                return;
            }
            AnAction anAction = ActionManager.getInstance().getAction("org.jetbrains.plugins.ruby.gem.bundler.actions.RunBundlerInstallAction");
            AnActionEvent anActionEvent = AnActionEvent.createFromAnAction((AnAction)anAction, null, (String)"unknown", (DataContext)SimpleDataContext.getSimpleContext((String)LangDataKeys.MODULE.getName(), (Object)module));
            anAction.beforeActionPerformedUpdate(anActionEvent);
            anAction.update(anActionEvent);
            if (anActionEvent.getPresentation().isEnabled() && anActionEvent.getPresentation().isVisible()) {
                anAction.actionPerformed(anActionEvent);
            }
        }
    }

    @Override
    public Boolean hasMissingGems(@Nullable Sdk sdk, @NotNull Module module, boolean inspectionMode) {
        Application application;
        boolean bl2;
        long l2 = d ^ 0x27E75FD53CFCL;
        if (module == null) {
            BundlerGemInfrastructure.b(1);
        }
        if (!(bl2 = (application = ApplicationManager.getApplication()).isHeadlessEnvironment())) {
            b.assertTrue(application.isDispatchThread() || !application.isReadAccessAllowed(), (Object)"invokeAndWait ahead, do not take read actions!");
        }
        VirtualFile virtualFile = BundlerUtil.getGemfile(module);
        String string = (String)ReadAction.compute(() -> {
            if (module == null) {
                BundlerGemInfrastructure.b(9);
            }
            return BundlerUtil.getBundlerScriptPath(sdk, module);
        });
        if (string == null || virtualFile == null) {
            return super.hasMissingGems(sdk, module, inspectionMode);
        }
        if (!inspectionMode) {
            application.invokeAndWait(() -> application.runWriteAction(() -> FileDocumentManager.getInstance().saveAllDocuments()));
        }
        if (!RubySdkUtil.isRubyInterpreterExist(sdk)) {
            return null;
        }
        String string2 = (String)ReadAction.compute(() -> {
            if (module == null) {
                BundlerGemInfrastructure.b(8);
            }
            return BundlerGemInfrastructure.a(module, virtualFile);
        });
        try {
            RubyGemExecutionContext rubyGemExecutionContext = (RubyGemExecutionContext)((RubyGemExecutionContext)((RubyGemExecutionContext)((RubyGemExecutionContext)((RubyGemExecutionContext)RubyGemExecutionContext.create(sdk, "bundler").withGemScriptName("bundle").withModule(module)).withWorkingDirPath(string2)).withExecutionMode((ExecutionMode)new ExecutionModes.SameThreadMode(false, "", 30, a))).withArguments("check")).withExecutionID(GEMFILE_HAS_MISSING_GEMS_ID);
            BundlerUtil.addBundlerEnvironment(rubyGemExecutionContext.getAdditionalEnvs(), sdk, module, virtualFile);
            ProcessOutput processOutput = rubyGemExecutionContext.executeScript();
            if (!inspectionMode) {
                application.invokeAndWait(() -> {
                    if (module == null) {
                        BundlerGemInfrastructure.b(6);
                    }
                    application.runWriteAction(() -> {
                        if (module == null) {
                            BundlerGemInfrastructure.b(7);
                        }
                        if (module.isDisposed()) {
                            return;
                        }
                        VirtualFile virtualFile = BundlerUtil.getGemfileLockWithRefresh(module);
                        if (virtualFile != null) {
                            virtualFile.refresh(false, false);
                        }
                    });
                });
            }
            boolean bl3 = processOutput != null && !processOutput.getStdout().contains("dependencies are satisfied");
            ApplicationManager.getApplication().invokeLater(() -> BundlerGemInfrastructure.a(virtualFile, bl3));
            return bl3;
        }
        catch (ExecutionException executionException) {
            return null;
        }
    }

    private static void a(@NotNull VirtualFile virtualFile, boolean bl2) {
        if (virtualFile == null) {
            BundlerGemInfrastructure.b(2);
        }
        virtualFile.putUserData(c, (Object)bl2);
    }

    public static boolean hasMissingGems(@NotNull VirtualFile virtualFile) {
        Boolean bl2;
        if (virtualFile == null) {
            BundlerGemInfrastructure.b(3);
        }
        return (bl2 = (Boolean)c.get((UserDataHolder)virtualFile)) != null && bl2 != false;
    }

    @Override
    public String getMissingGemMessage(Module module) {
        long l2 = d ^ 0x2D285ABE121DL;
        BundlerGitLockReader bundlerGitLockReader = BundlerGitLockReader.getInstance(module);
        if (!bundlerGitLockReader.isLocked()) {
            return super.getMissingGemMessage(module);
        }
        return RBundle.message((String)"gems.not.activated.bundler");
    }

    @Nullable
    private static String a(@NotNull Module module, @NotNull VirtualFile virtualFile) {
        if (module == null) {
            BundlerGemInfrastructure.b(4);
        }
        if (virtualFile == null) {
            BundlerGemInfrastructure.b(5);
        }
        if (module.isDisposed()) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile.getParent();
        String string = virtualFile2 != null ? VfsUtilCore.urlToPath((String)virtualFile2.getUrl()) : null;
        VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (string == null && virtualFileArray.length > 0) {
            string = virtualFileArray[0].getPath();
        }
        return string;
    }

    static {
        d = la.a(-8233494475176910564L, -7641473406073381187L, MethodHandles.lookup().lookupClass()).a(184374439267054L);
        long l2 = d ^ 0x62DFFB3BF56CL;
        c = Key.create((String)GEMFILE_HAS_MISSING_GEMS_ID);
        b = Logger.getInstance(BundlerGemInfrastructure.class);
        a = (executionMode, string) -> {
            long l2 = d ^ 0x36872ED1CB36L;
            b.warn("Timeout (" + executionMode.getTimeout() + " sec) on executing: " + string);
        };
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = d ^ 0x271CEE8DCF4DL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/gem/bundler/BundlerGemInfrastructure";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getDependencyResolver";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hasMissingGems";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setHasMissingGems";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getBundleCheckPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$hasMissingGems$6";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$5";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$hasMissingGems$4";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$hasMissingGems$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

