/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.extractSuperclass;

import b.h.la;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RSuperClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.refactoring.RubyRefactoringUtil;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyClassMembersPsiHelper;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyClassMembersRefactoringSupport;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyClassRefactoringHandlerBase;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyMemberInfo;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyMemberInfoStorage;
import org.jetbrains.plugins.ruby.ruby.refactoring.extractSuperclass.ExtractSuperclassDialog;

public class RubyExtractSuperclassHandler
extends RubyClassRefactoringHandlerBase {
    private static final Logger a;
    private static final long b;

    protected void showDialog(Project project, PsiElement element, Editor editor, PsiFile file, DataContext dataContext) {
        RClass rClass = RubyPsiUtil.getContainingRClass(element);
        if (rClass == null) {
            String string = RefactoringBundle.getCannotRefactorMessage((String)this.getInvalidPositionMessage());
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)string, (String)this.getTitle(), (String)this.getHelpId());
            return;
        }
        RubyMemberInfoStorage rubyMemberInfoStorage = RubyClassMembersRefactoringSupport.getSelectedMemberInfos((RContainer)rClass, element);
        if (ApplicationManagerEx.getApplicationEx().isUnitTestMode()) {
            return;
        }
        ExtractSuperclassDialog extractSuperclassDialog = new ExtractSuperclassDialog(project, (RContainer)rClass, rubyMemberInfoStorage);
        if (extractSuperclassDialog.showAndGet()) {
            RubyExtractSuperclassHandler.extractSuperclass(rClass, extractSuperclassDialog.getSelectedMemberInfos(), extractSuperclassDialog.getSuperBaseName(), extractSuperclassDialog.getTargetDirectory());
        }
    }

    static void extractSuperclass(RClass clazz, Collection<RubyMemberInfo> selectedMemberInfos, String superBaseName, VirtualFile targetDirectory) {
        long l2 = b ^ 0x786865D1DC0L;
        Project project = clazz.getProject();
        CommandProcessor.getInstance().executeCommand(project, () -> PostprocessReformattingAspect.getInstance((Project)project).postponeFormattingInside(() -> WriteAction.run(() -> {
            try {
                RubyExtractSuperclassHandler.navigate((PsiElement)RubyExtractSuperclassHandler.a(clazz, selectedMemberInfos, superBaseName, targetDirectory));
            }
            catch (IOException iOException) {
                a.error((Throwable)iOException);
            }
        })), RefactoringBundle.message((String)"extract.superclass.command.name", (Object[])new Object[]{superBaseName, DescriptiveNameUtil.getDescriptiveName((PsiElement)clazz)}), null);
    }

    private static PsiElement a(RClass rClass, Collection<RubyMemberInfo> collection, String string, VirtualFile virtualFile) throws IOException {
        long l2 = b ^ 0x1A5F5CD957D5L;
        Project project = rClass.getProject();
        Pair<String, RFile> pair = RubyExtractSuperclassHandler.a(rClass);
        String string2 = RubyClassMembersPsiHelper.prepareContainerStatements(string, collection, "class", false);
        RFile rFile = RubyClassMembersPsiHelper.createTargetFile(project, virtualFile, RubyRefactoringUtil.getNewFileName(string), string2);
        RubyClassMembersPsiHelper.removeMembers(collection);
        RubyClassMembersPsiHelper.insertRequire(rClass.getContainingFile(), rFile);
        RClass rClass2 = (RClass)RubyClassMembersPsiHelper.findPrepared(rFile, string);
        RubyExtractSuperclassHandler.b(rClass);
        if (pair.first != null) {
            RubyExtractSuperclassHandler.a(rClass2, (String)pair.first);
        }
        if (pair.second != null) {
            RubyClassMembersPsiHelper.insertRequire((PsiFile)rFile, (RFile)pair.second);
        }
        RubyExtractSuperclassHandler.a(rClass, string);
        return rClass2;
    }

    private static void b(RClass rClass) {
        RSuperClass rSuperClass = rClass.getPsiSuperClass();
        if (rSuperClass == null) {
            return;
        }
        List<PsiElement> list2 = RubyExtractSuperclassHandler.a((RPsiElement)rSuperClass);
        RubyPsiUtil.removeElements(list2.toArray(PsiElement.EMPTY_ARRAY));
    }

    private static void a(RClass rClass, String string) {
        long l2 = b ^ 0x2CD4DDB4F94CL;
        String string2 = "class Foo < " + string + "\nend";
        RClass rClass2 = (RClass)RubyElementFactory.createElementFromText((PsiElement)rClass, string2);
        List<PsiElement> list2 = RubyExtractSuperclassHandler.a((RPsiElement)rClass2.getPsiSuperClass());
        RubyPsiUtil.addBeforeInParent(rClass.getClassName().getNextSibling(), list2.toArray(PsiElement.EMPTY_ARRAY));
    }

    private static List<PsiElement> a(RPsiElement rPsiElement) {
        if (rPsiElement == null) {
            return Collections.emptyList();
        }
        ArrayList<PsiElement> arrayList = new ArrayList<PsiElement>();
        arrayList.add((PsiElement)rPsiElement);
        for (PsiElement psiElement = rPsiElement.getPrevSibling(); psiElement != null && (psiElement instanceof PsiWhiteSpace || "<".equals(psiElement.getText())); psiElement = psiElement.getPrevSibling()) {
            arrayList.add(0, psiElement);
        }
        return arrayList;
    }

    private static Pair<String, RFile> a(RClass rClass) {
        PsiElement psiElement;
        ClassModuleSymbol classModuleSymbol = (ClassModuleSymbol)SymbolUtil.getSymbolByContainer((RElementWithFQN)rClass);
        assert (classModuleSymbol != null);
        Symbol symbol = classModuleSymbol.getSuperClassSymbol((PsiElement)rClass);
        PsiElement psiElement2 = psiElement = symbol != null ? symbol.getPsiElement() : null;
        if (psiElement == null) {
            RSuperClass rSuperClass = rClass.getPsiSuperClass();
            return Pair.create((Object)(rSuperClass != null ? rSuperClass.getText() : null), null);
        }
        return Pair.create((Object)symbol.getFQNWithNesting().getFullPath(), (Object)((RFile)psiElement.getContainingFile()));
    }

    protected String getHelpId() {
        long l2 = b ^ 0x75693EE115DDL;
        return "refactoring.extractSuperclass";
    }

    protected String getTitle() {
        long l2 = b ^ 0x39D39D768AC8L;
        return RefactoringBundle.message((String)"extract.superclass.title");
    }

    protected String getInvalidPositionMessage() {
        long l2 = b ^ 0x7F70A3670D6FL;
        return RefactoringBundle.message((String)"error.wrong.caret.position.class");
    }

    public boolean isEnabledOnElements(PsiElement[] elements) {
        return elements.length == 1 && elements[0] instanceof RClass;
    }

    static {
        b = la.a(2237787905010323520L, -1311598488468775338L, MethodHandles.lookup().lookupClass()).a(154898734032648L);
        a = Logger.getInstance(RubyExtractSuperclassHandler.class);
    }
}

