/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.branch;

import com.intellij.dvcs.branch.DvcsBranchUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.CompareBranchesDialog;
import com.intellij.dvcs.ui.CompareBranchesHelper;
import com.intellij.dvcs.util.CommitCompareInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.action.HgCompareWithBranchAction;
import org.zmlx.hg4idea.branch.HgCompareBranchesHelper;
import org.zmlx.hg4idea.branch.HgMultiRootBranchConfig;
import org.zmlx.hg4idea.log.HgCommit;
import org.zmlx.hg4idea.log.HgHistoryUtil;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgUtil;

public class HgBranchWorker {
    private static final String CURRENT_REVISION = ".";
    private static final Logger LOG = Logger.getInstance(HgBranchWorker.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProgressIndicator myIndicator;

    HgBranchWorker(@NotNull Project project, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            HgBranchWorker.$$$reportNull$$$0(0);
        }
        if (indicator == null) {
            HgBranchWorker.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myIndicator = indicator;
    }

    public void compare(@NotNull String branchName, @NotNull List<HgRepository> repositories, @NotNull HgRepository selectedRepository) {
        if (branchName == null) {
            HgBranchWorker.$$$reportNull$$$0(2);
        }
        if (repositories == null) {
            HgBranchWorker.$$$reportNull$$$0(3);
        }
        if (selectedRepository == null) {
            HgBranchWorker.$$$reportNull$$$0(4);
        }
        try {
            CommitCompareInfo myCompareInfo = this.loadCommitsToCompare(repositories, branchName);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (branchName == null) {
                    HgBranchWorker.$$$reportNull$$$0(16);
                }
                if (repositories == null) {
                    HgBranchWorker.$$$reportNull$$$0(17);
                }
                if (selectedRepository == null) {
                    HgBranchWorker.$$$reportNull$$$0(18);
                }
                this.displayCompareDialog(branchName, HgBranchWorker.getCurrentBranchOrRev(repositories), myCompareInfo, selectedRepository);
            });
        }
        catch (VcsException e) {
            VcsNotifier.getInstance((Project)this.myProject).notifyError("Can't Compare with Branch", e.getMessage());
        }
    }

    private void displayCompareDialog(@NotNull String branchName, @NotNull String currentBranch, @NotNull CommitCompareInfo compareInfo, @NotNull HgRepository selectedRepository) {
        if (branchName == null) {
            HgBranchWorker.$$$reportNull$$$0(5);
        }
        if (currentBranch == null) {
            HgBranchWorker.$$$reportNull$$$0(6);
        }
        if (compareInfo == null) {
            HgBranchWorker.$$$reportNull$$$0(7);
        }
        if (selectedRepository == null) {
            HgBranchWorker.$$$reportNull$$$0(8);
        }
        if (compareInfo.isEmpty()) {
            Messages.showInfoMessage((Project)this.myProject, (String)String.format("<html>There are no changes between <code>%s</code> and <code>%s</code></html>", currentBranch, branchName), (String)"No Changes Detected");
        } else {
            new CompareBranchesDialog((CompareBranchesHelper)new HgCompareBranchesHelper(this.myProject), branchName, currentBranch, compareInfo, (Repository)selectedRepository, false).show();
        }
    }

    @NotNull
    private static String getCurrentBranchOrRev(@NotNull Collection<HgRepository> repositories) {
        String currentBranch;
        if (repositories == null) {
            HgBranchWorker.$$$reportNull$$$0(9);
        }
        if (repositories.size() > 1) {
            HgMultiRootBranchConfig multiRootBranchConfig = new HgMultiRootBranchConfig(repositories);
            currentBranch = multiRootBranchConfig.getCurrentBranch();
        } else {
            assert (!repositories.isEmpty()) : "No repositories passed to HgBranchOperationsProcessor.";
            HgRepository repository = repositories.iterator().next();
            currentBranch = repository.getCurrentBranchName();
        }
        String string = currentBranch == null ? CURRENT_REVISION : currentBranch;
        if (string == null) {
            HgBranchWorker.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    private CommitCompareInfo loadCommitsToCompare(List<HgRepository> repositories, String branchName) throws VcsException {
        CommitCompareInfo compareInfo = new CommitCompareInfo();
        for (HgRepository repository : repositories) {
            List<HgCommit> headToBranch = this.loadCommitsBetween(repository, CURRENT_REVISION, branchName);
            List<HgCommit> branchToHead = this.loadCommitsBetween(repository, branchName, CURRENT_REVISION);
            compareInfo.put((Repository)repository, headToBranch, branchToHead);
            compareInfo.putTotalDiff((Repository)repository, HgBranchWorker.loadTotalDiff(repository, branchName));
        }
        CommitCompareInfo commitCompareInfo = compareInfo;
        if (commitCompareInfo == null) {
            HgBranchWorker.$$$reportNull$$$0(11);
        }
        return commitCompareInfo;
    }

    @NotNull
    private List<HgCommit> loadCommitsBetween(HgRepository repository, String fromRev, String toRev) throws VcsException {
        List<String> parameters = Arrays.asList("-r", "reverse(\"" + toRev + "\"%\"" + fromRev + "\")");
        List<HgCommit> list = HgHistoryUtil.history(this.myProject, repository.getRoot(), -1, parameters, true);
        if (list == null) {
            HgBranchWorker.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    private static Collection<Change> loadTotalDiff(@NotNull HgRepository repository, @NotNull String branchName) throws VcsException {
        if (repository == null) {
            HgBranchWorker.$$$reportNull$$$0(13);
        }
        if (branchName == null) {
            HgBranchWorker.$$$reportNull$$$0(14);
        }
        HgRevisionNumber branchRevisionNumber = HgCompareWithBranchAction.getBranchRevisionNumber(repository, branchName);
        VirtualFile root = repository.getRoot();
        List<Change> changes = HgUtil.getDiff(repository.getProject(), root, VcsUtil.getFilePath((VirtualFile)root), branchRevisionNumber, null);
        List list = DvcsBranchUtil.swapRevisions(changes);
        if (list == null) {
            HgBranchWorker.$$$reportNull$$$0(15);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 2: 
            case 5: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 3: 
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 4: 
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedRepository";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentBranch";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compareInfo";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/branch/HgBranchWorker";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/branch/HgBranchWorker";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentBranchOrRev";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "loadCommitsToCompare";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "loadCommitsBetween";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "loadTotalDiff";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "displayCompareDialog";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentBranchOrRev";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadTotalDiff";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$compare$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

