/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules;

import com.intellij.javascript.JSFileReference;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.javascript.nodejs.reference.NodeFileModulePsiReferenceBase;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.frameworks.modules.JSExactFileReference;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.SyntheticFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileSystemItemUtil;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiFileSystemItemProcessor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSModuleReferenceBase
extends JSFileReference {
    public JSModuleReferenceBase(String text, int offset, TextRange textRange, @NotNull FileReferenceSet fileReferenceSet) {
        if (fileReferenceSet == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(0);
        }
        super(text, offset, textRange, fileReferenceSet);
    }

    public JSModuleReferenceBase(String text, int offset, TextRange textRange, @NotNull FileReferenceSet fileReferenceSet, String[] implicitExtensions) {
        if (fileReferenceSet == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(1);
        }
        super(text, offset, textRange, fileReferenceSet, implicitExtensions);
    }

    @NotNull
    protected ResolveResult[] innerResolve(boolean caseSensitive, @NotNull PsiFile containingFile) {
        if (containingFile == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(2);
        }
        ResolveResult[] results = super.innerResolve(caseSensitive, containingFile);
        for (int i = 0; i < results.length; ++i) {
            PsiDirectory result2;
            VirtualFile canonicalFile;
            VirtualFile file2;
            JSFile psiFile = (JSFile)ObjectUtils.tryCast((Object)results[i].getElement(), JSFile.class);
            VirtualFile virtualFile = file2 = psiFile != null ? psiFile.getVirtualFile() : null;
            if (file2 == null || file2.equals(canonicalFile = JSModuleReferenceBase.getCanonicalPreferredFile(psiFile.getProject(), file2))) continue;
            PsiManager manager = psiFile.getManager();
            Object object = result2 = canonicalFile.isDirectory() ? manager.findDirectory(canonicalFile) : manager.findFile(canonicalFile);
            if (result2 == null) continue;
            results[i] = new PsiElementResolveResult((PsiElement)result2);
        }
        if (results == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(3);
        }
        return results;
    }

    protected Object createLookupItem(PsiElement candidate) {
        PsiDirectory directory;
        PsiDirectory parentDirectory;
        if (candidate instanceof PsiDirectory && (parentDirectory = (directory = (PsiDirectory)candidate).getParent()) != null && "node_modules".equals(parentDirectory.getName())) {
            VirtualFile context = PsiUtilCore.getVirtualFile((PsiElement)this.getElement());
            CompletionModuleInfo module = new CompletionModuleInfo(directory.getName(), directory.getVirtualFile(), ModuleType.NODE_MODULES_DIR);
            return NodeFileModulePsiReferenceBase.createLookupElement(context, module, directory.getProject());
        }
        return JSCompletionUtil.createLookupElementForJSModule(candidate);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiElement psiElement;
        if (element == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(4);
        }
        if ((psiElement = this.processBindFromExtendedCompletion(element)) != null) {
            return psiElement;
        }
        return super.bindToElement(element);
    }

    protected PsiElement processBindFromExtendedCompletion(@NotNull PsiElement element) {
        PsiFile contextFile;
        String path;
        if (element == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(5);
        }
        if (!this.isExtendedCompletion(element)) {
            return null;
        }
        PsiElement context = this.getElement();
        if (JSCodeStyleSettings.isUseAbsolutePath(context)) {
            String path2 = JSModuleReferenceBase.getPathFromDefaultContext(this.getFileReferenceSet(), element, false);
            if (path2 != null) {
                return this.trimPathExtension(path2);
            }
        } else if (element instanceof PsiFile && (path = PsiFileSystemItemUtil.findRelativePath((PsiFileSystemItem)(contextFile = context.getContainingFile()), (PsiFileSystemItem)((PsiFile)element))) != null) {
            return this.trimPathExtension(path.startsWith(".") ? path : "./" + path);
        }
        return null;
    }

    private PsiElement trimPathExtension(String path) {
        String[] extensions = this.getSortedByLengthImplicitExtensions();
        String extension = JSFileReference.findExtension(path, extensions);
        return this.rename(extension == null ? path : path.substring(0, path.length() - extension.length()));
    }

    private boolean isExtendedCompletion(@NotNull PsiElement element) {
        if (element == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(6);
        }
        if (!(element instanceof PsiFile)) {
            return false;
        }
        PsiFile psiFile = (PsiFile)element;
        FileReferenceSet referenceSet = this.getFileReferenceSet();
        String pathString = referenceSet.getPathString();
        if (!StringUtil.equals((CharSequence)pathString, (CharSequence)psiFile.getName())) {
            return false;
        }
        Object[] types = referenceSet.getSuitableFileTypes();
        return types == FileType.EMPTY_ARRAY || ArrayUtil.contains((Object)psiFile.getFileType(), (Object[])types);
    }

    @Override
    protected void innerResolveInContext(@NotNull String referenceText, @NotNull PsiFileSystemItem context, Collection<ResolveResult> results, boolean caseSensitive) {
        if (referenceText == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(7);
        }
        if (context == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(8);
        }
        super.innerResolveInContext(referenceText, context, results, caseSensitive);
        this.innerResolveScopedPackagesInsideTypesModule(referenceText, context, results);
    }

    private void innerResolveScopedPackagesInsideTypesModule(@NotNull String referenceText, @NotNull PsiFileSystemItem context, @NotNull Collection<ResolveResult> results) {
        if (referenceText == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(9);
        }
        if (context == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(10);
        }
        if (results == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(11);
        }
        if (referenceText.startsWith("@") && !this.isLast() && "@types".equals(context.getName())) {
            results.add((ResolveResult)new PsiElementResolveResult((PsiElement)this.createFakeScopeFileElement(referenceText, context)));
        }
    }

    @NotNull
    private SyntheticFileSystemItem createFakeScopeFileElement(final @NotNull String referenceText, final @NotNull PsiFileSystemItem context) {
        if (referenceText == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(12);
        }
        if (context == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(13);
        }
        final String scopePrefix = referenceText.substring(1) + "__";
        SyntheticFileSystemItem syntheticFileSystemItem = new SyntheticFileSystemItem(this.getElement().getProject()){

            public PsiFileSystemItem getParent() {
                return context;
            }

            public VirtualFile getVirtualFile() {
                return context.getVirtualFile();
            }

            @NotNull
            public String getName() {
                String string = referenceText;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor) {
                PsiFileSystemItem parent = this.getParent();
                if (parent == null) {
                    return true;
                }
                return parent.processChildren(el -> {
                    String elName = el.getName();
                    if (elName.startsWith(scopePrefix)) {
                        String subPackageName = elName.substring(scopePrefix.length());
                        if (processor instanceof PsiFileSystemItemProcessor) {
                            if (((PsiFileSystemItemProcessor)processor).acceptItem(subPackageName, el.isDirectory())) {
                                return processor.execute(el);
                            }
                            return true;
                        }
                        return processor.execute(el);
                    }
                    return true;
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/modules/JSModuleReferenceBase$1", "getName"));
            }
        };
        if (syntheticFileSystemItem == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(14);
        }
        return syntheticFileSystemItem;
    }

    @NotNull
    protected Collection<ResolveResult> getDirectIndexFiles(@NotNull VirtualFile directoryFile) {
        if (directoryFile == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(15);
        }
        List result2 = null;
        for (String ext : this.getImplicitExtensions()) {
            PsiFile psiFile;
            VirtualFile file2 = directoryFile.findChild("index" + ext);
            if (file2 == null || (psiFile = this.getElement().getManager().findFile(file2)) == null) continue;
            PsiElementResolveResult resultElement = new PsiElementResolveResult((PsiElement)psiFile);
            if (result2 == null) {
                if (this.shouldStopImplicitExtensionProcessing(ext)) {
                    List<PsiElementResolveResult> list = Collections.singletonList(resultElement);
                    if (list == null) {
                        JSModuleReferenceBase.$$$reportNull$$$0(16);
                    }
                    return list;
                }
                result2 = ContainerUtil.newSmartList();
            }
            result2.add(resultElement);
            if (!this.shouldStopImplicitExtensionProcessing(ext)) continue;
            List list = result2;
            if (list == null) {
                JSModuleReferenceBase.$$$reportNull$$$0(17);
            }
            return list;
        }
        List list = result2 == null ? ContainerUtil.emptyList() : result2;
        if (list == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(18);
        }
        return list;
    }

    @Override
    @NotNull
    protected Collection<ResolveResult> resolveDirectory(@NotNull PsiFileSystemItem directory) {
        VirtualFile directoryFile;
        if (directory == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(19);
        }
        if ((directoryFile = directory.getVirtualFile()).findChild("package.json") == null) {
            Collection<ResolveResult> collection = this.getDirectIndexFiles(directoryFile);
            if (collection == null) {
                JSModuleReferenceBase.$$$reportNull$$$0(20);
            }
            return collection;
        }
        NodeModuleDirectorySearchProcessor processor = this.getNodeModuleSearchProcessor();
        if (processor == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSModuleReferenceBase.$$$reportNull$$$0(21);
            }
            return list;
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)JSExactFileReference.resolveForNpmPackages((PsiElement)directory, processor));
        if (list == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(22);
        }
        return list;
    }

    @Nullable
    protected NodeModuleDirectorySearchProcessor getNodeModuleSearchProcessor() {
        return null;
    }

    @Override
    @NotNull
    protected String fixNameForRename(@NotNull String beforeProcessing) {
        if (beforeProcessing == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(23);
        }
        String newName = super.fixNameForRename(beforeProcessing);
        if (!this.isLast()) {
            String string = newName;
            if (string == null) {
                JSModuleReferenceBase.$$$reportNull$$$0(24);
            }
            return string;
        }
        String indexSuffix = "/index";
        if (this.getText().endsWith(indexSuffix) || !newName.endsWith(indexSuffix)) {
            String string = newName;
            if (string == null) {
                JSModuleReferenceBase.$$$reportNull$$$0(25);
            }
            return string;
        }
        PsiElement element = this.getElement();
        if (!element.isValid() || !JSCodeStyleSettings.isUseNodeResolution(element)) {
            String string = newName;
            if (string == null) {
                JSModuleReferenceBase.$$$reportNull$$$0(26);
            }
            return string;
        }
        String withoutIndex = newName.substring(0, newName.length() - indexSuffix.length());
        String string = withoutIndex.isEmpty() ? newName : withoutIndex;
        if (string == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    public static VirtualFile getCanonicalPreferredFile(@NotNull Project project, @NotNull VirtualFile file2) {
        VirtualFile canonicalFile;
        if (project == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(28);
        }
        if (file2 == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(29);
        }
        if ((canonicalFile = file2.getCanonicalFile()) == null || canonicalFile.equals(file2)) {
            VirtualFile virtualFile = file2;
            if (virtualFile == null) {
                JSModuleReferenceBase.$$$reportNull$$$0(30);
            }
            return virtualFile;
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
        if (fileIndex.isInContent(canonicalFile)) {
            VirtualFile virtualFile = canonicalFile;
            if (virtualFile == null) {
                JSModuleReferenceBase.$$$reportNull$$$0(31);
            }
            return virtualFile;
        }
        if (fileIndex.isInContent(file2)) {
            VirtualFile virtualFile = file2;
            if (virtualFile == null) {
                JSModuleReferenceBase.$$$reportNull$$$0(32);
            }
            return virtualFile;
        }
        if (fileIndex.isInLibrary(canonicalFile)) {
            VirtualFile virtualFile = canonicalFile;
            if (virtualFile == null) {
                JSModuleReferenceBase.$$$reportNull$$$0(33);
            }
            return virtualFile;
        }
        VirtualFile virtualFile = fileIndex.isInLibrary(file2) ? file2 : canonicalFile;
        if (virtualFile == null) {
            JSModuleReferenceBase.$$$reportNull$$$0(34);
        }
        return virtualFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileReferenceSet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 3: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/modules/JSModuleReferenceBase";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceText";
                break;
            }
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryFile";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeProcessing";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/modules/JSModuleReferenceBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "innerResolve";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createFakeScopeFileElement";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectIndexFiles";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveDirectory";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "fixNameForRename";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalPreferredFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "innerResolve";
                break;
            }
            case 3: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processBindFromExtendedCompletion";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isExtendedCompletion";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "innerResolveInContext";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "innerResolveScopedPackagesInsideTypesModule";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createFakeScopeFileElement";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDirectIndexFiles";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "resolveDirectory";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "fixNameForRename";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicalPreferredFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

