/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint.version;

import com.google.common.collect.ImmutableList;
import com.intellij.lang.javascript.linter.jshint.JSHintUtil;
import com.intellij.lang.javascript.linter.jshint.version.JSHintVersionDescriptor;
import com.intellij.lang.javascript.linter.jshint.version.JSHintVersionUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.SwingHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHintVersionView
implements Disposable {
    private static final Logger LOG = Logger.getInstance(JSHintVersionView.class);
    private final Project myProject;
    private final Color myDefaultComboboxForegroundColor;
    private final LabeledComponent<JComboBox> myComponent;
    private boolean myUpdatingVersionDescriptors;
    private String myPreservedVersion;
    @Nullable
    private Balloon myActiveErrorBalloon;

    public JSHintVersionView(@NotNull Project project) {
        if (project == null) {
            JSHintVersionView.$$$reportNull$$$0(0);
        }
        this.myUpdatingVersionDescriptors = false;
        this.myProject = project;
        final JComboBox comboBox = JSHintVersionView.createComboBox();
        this.myDefaultComboboxForegroundColor = comboBox.getForeground();
        this.myComponent = LabeledComponent.create((JComponent)comboBox, (String)"&Version:");
        this.myComponent.setLabelLocation("West");
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!JSHintVersionView.this.myUpdatingVersionDescriptors) {
                    JSHintVersionView.this.checkSelectedVersion();
                }
            }
        });
        comboBox.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (JSHintVersionView.this.myPreservedVersion != null) {
                    JSHintVersionView.asyncDownloadVersions(() -> JSHintVersionView.this.fillVersions(JSHintVersionView.this.myPreservedVersion), null);
                }
                comboBox.removeFocusListener(this);
            }
        });
    }

    private void checkSelectedVersion() {
        ApplicationManager.getApplication().invokeLater(() -> {
            this.hideActiveErrorBalloon();
            JSHintVersionDescriptor selected = this.getSelectedVersionDescriptor();
            boolean sourceLocallyAvailable = this.obtainSource(selected);
            if (!sourceLocallyAvailable) {
                LOG.info("Can't obtain source of JSHint " + selected.getVersion());
            }
            JComboBox comboBox = (JComboBox)this.myComponent.getComponent();
            comboBox.setForeground(sourceLocallyAvailable ? this.myDefaultComboboxForegroundColor : JBColor.RED);
        });
    }

    private boolean obtainSource(@NotNull JSHintVersionDescriptor descriptor2) {
        if (descriptor2 == null) {
            JSHintVersionView.$$$reportNull$$$0(1);
        }
        if (JSHintVersionUtil.isSourceLocallyAvailable(descriptor2.getVersion())) {
            return true;
        }
        Ref innerExceptionRef = Ref.create(null);
        boolean completed = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            if (descriptor2 == null) {
                JSHintVersionView.$$$reportNull$$$0(8);
            }
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            indicator.setText("Downloading " + JSHintVersionUtil.getJSHintSourceFileBaseName(descriptor2.getVersion()));
            try {
                JSHintVersionUtil.downloadSourceVersionOnce(indicator, descriptor2);
            }
            catch (Exception ex) {
                innerExceptionRef.set((Object)ex);
            }
        }, "JSHint " + descriptor2.getVersion(), true, this.myProject);
        if (completed && innerExceptionRef.isNull()) {
            return true;
        }
        Runnable retryAction = () -> {
            this.hideActiveErrorBalloon();
            this.checkSelectedVersion();
        };
        String title = "<b>JSHint " + descriptor2.getVersion() + " is not available</b>";
        JComponent errorMessageBalloonContent = completed ? JSHintUtil.createIOExceptionBalloonComponent(title + "<br/>Can not download " + descriptor2.getUrl(), retryAction, true) : JSHintUtil.createIOExceptionBalloonComponent(title + "<br/>" + descriptor2.getUrl() + " download was cancelled", retryAction, false);
        Balloon balloon = JBPopupFactory.getInstance().createBalloonBuilder(errorMessageBalloonContent).setDialogMode(true).setCloseButtonEnabled(true).setDisposable((Disposable)this).setFillColor(MessageType.ERROR.getPopupBackground()).setContentInsets(new Insets(10, 10, 10, 10)).createBalloon();
        this.hideActiveErrorBalloon();
        balloon.show(this.findRelativePoint(), Balloon.Position.below);
        this.myActiveErrorBalloon = balloon;
        return false;
    }

    private RelativePoint findRelativePoint() {
        JComboBox comboBox = (JComboBox)this.myComponent.getComponent();
        return new RelativePoint((Component)comboBox, new Point(comboBox.getWidth() / 2, (int)((double)comboBox.getHeight() / 1.2)));
    }

    private void hideActiveErrorBalloon() {
        if (this.myActiveErrorBalloon != null) {
            this.myActiveErrorBalloon.hide();
            this.myActiveErrorBalloon = null;
        }
    }

    @NotNull
    public JSHintVersionDescriptor getSelectedVersionDescriptor() {
        JComboBox comboBox = (JComboBox)this.myComponent.getComponent();
        JSHintVersionDescriptor jSHintVersionDescriptor = (JSHintVersionDescriptor)comboBox.getSelectedItem();
        if (jSHintVersionDescriptor == null) {
            JSHintVersionView.$$$reportNull$$$0(2);
        }
        return jSHintVersionDescriptor;
    }

    @NotNull
    private static JComboBox createComboBox() {
        ComboBox comboBox = new ComboBox();
        comboBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper<JSHintVersionDescriptor>(){

            public void customize(JList list, JSHintVersionDescriptor value, int index, boolean selected, boolean hasFocus) {
                String text = "no version";
                if (value != null) {
                    text = value.getVersion();
                    if (value.isBundled()) {
                        text = text + " (bundled)";
                    }
                }
                this.setText(text);
            }
        });
        ComboBox comboBox2 = comboBox;
        if (comboBox2 == null) {
            JSHintVersionView.$$$reportNull$$$0(3);
        }
        return comboBox2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillVersions(@Nullable String selectedVersion) {
        this.myUpdatingVersionDescriptors = true;
        try {
            ImmutableList<JSHintVersionDescriptor> descriptors;
            ImmutableList<JSHintVersionDescriptor> fixedDescriptors = descriptors = JSHintVersionUtil.getVersions();
            JSHintVersionDescriptor selectedDescriptor = null;
            if (selectedVersion != null) {
                fixedDescriptors = JSHintVersionUtil.addGuessableVersionDescriptorFirstIfMissing(descriptors, selectedVersion);
                selectedDescriptor = JSHintVersionUtil.find(fixedDescriptors, selectedVersion);
            }
            JComboBox comboBox = (JComboBox)this.myComponent.getComponent();
            SwingHelper.updateItems((JComboBox)comboBox, fixedDescriptors, (Object)selectedDescriptor);
        }
        finally {
            this.myUpdatingVersionDescriptors = false;
        }
    }

    @NotNull
    public Component getComponent() {
        LabeledComponent<JComboBox> labeledComponent = this.myComponent;
        if (labeledComponent == null) {
            JSHintVersionView.$$$reportNull$$$0(4);
        }
        return labeledComponent;
    }

    public void setVersion(@NotNull String version) {
        if (version == null) {
            JSHintVersionView.$$$reportNull$$$0(5);
        }
        this.myPreservedVersion = version;
        this.fillVersions(version);
        ImmutableList<JSHintVersionDescriptor> descriptors = JSHintVersionUtil.getVersions();
        if (JSHintVersionUtil.find(descriptors, version) != null) {
            this.checkSelectedVersion();
        } else {
            JSHintVersionView.asyncDownloadVersions(() -> {
                if (version == null) {
                    JSHintVersionView.$$$reportNull$$$0(7);
                }
                this.fillVersions(version);
                this.checkSelectedVersion();
            }, () -> this.checkSelectedVersion());
        }
    }

    private static void asyncDownloadVersions(@Nullable Runnable onSuccess, @Nullable Runnable onFailure) {
        ModalityState modalityState = ModalityState.any();
        Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(() -> {
            block3: {
                try {
                    JSHintVersionUtil.downloadVersions(null);
                    if (onSuccess != null) {
                        application.invokeLater(onSuccess, modalityState);
                    }
                }
                catch (Exception e) {
                    LOG.warn("Can't update jshint version list", (Throwable)e);
                    if (onFailure == null) break block3;
                    application.invokeLater(onFailure, modalityState);
                }
            }
        });
    }

    @NotNull
    public String getVersion() {
        JSHintVersionDescriptor selected = this.getSelectedVersionDescriptor();
        String string = selected.getVersion();
        if (string == null) {
            JSHintVersionView.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionView";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/jshint/version/JSHintVersionView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedVersionDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createComboBox";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "obtainSource";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setVersion";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setVersion$3";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$obtainSource$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

