/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ide.navigation.plugins.facts;

import com.intellij.lang.puppet.ide.navigation.plugins.PuppetExtSymbolInfo;
import com.intellij.lang.puppet.ide.navigation.plugins.facts.PuppetFactDataIndexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.indexing.FileContent;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

final class TxtFactIndexer
implements PuppetFactDataIndexer {
    private static final Pattern TXT_FACT_PATTERN = Pattern.compile("^(\\S+)=.*$", 8);

    TxtFactIndexer() {
    }

    @NotNull
    public Map<String, PuppetExtSymbolInfo> map(@NotNull FileContent inputData) {
        if (inputData == null) {
            TxtFactIndexer.$$$reportNull$$$0(0);
        }
        HashMap<String, PuppetExtSymbolInfo> result = new HashMap<String, PuppetExtSymbolInfo>();
        Matcher matcher = TXT_FACT_PATTERN.matcher(inputData.getContentAsText());
        while (matcher.find()) {
            String factName = matcher.group(1);
            result.put(factName, new PuppetExtSymbolInfo(inputData.getFile().getUrl(), matcher.start()));
        }
        HashMap<String, PuppetExtSymbolInfo> hashMap = result;
        if (hashMap == null) {
            TxtFactIndexer.$$$reportNull$$$0(1);
        }
        return hashMap;
    }

    @Override
    public boolean acceptsFile(@NotNull String fileName, @NotNull String parentDirName) {
        if (fileName == null) {
            TxtFactIndexer.$$$reportNull$$$0(2);
        }
        if (parentDirName == null) {
            TxtFactIndexer.$$$reportNull$$$0(3);
        }
        return parentDirName.equals("facts.d") && StringUtil.endsWithIgnoreCase((String)fileName, (String)".txt");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/ide/navigation/plugins/facts/TxtFactIndexer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDirName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/ide/navigation/plugins/facts/TxtFactIndexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

