/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.editors;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeCellEditor;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.ui.CellRendererPanel;
import com.intellij.uml.core.renderers.DefaultUmlRenderer;
import com.intellij.uml.editors.DiagramNodeEditorManager;
import com.intellij.uml.presentation.DiagramPresentationModelImpl;
import com.intellij.uml.utils.UmlUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;

public class DiagramNodeCellEditor
extends AbstractCellEditor
implements NodeCellEditor {
    private final DiagramBuilder myBuilder;
    private JComponent myEditor;
    private Object myValue;

    public DiagramNodeCellEditor(DiagramBuilder builder) {
        this.myBuilder = builder;
    }

    @Override
    public Object getCellEditorValue() {
        return this.myValue;
    }

    public JComponent getEditor() {
        return this.myEditor;
    }

    public JComponent getNodeCellEditorComponent(Graph2DView view, NodeRealizer context, Object value, boolean isSelected) {
        if (this.myEditor == null) {
            this.initEditor(context);
        }
        this.myValue = value;
        this.myEditor.putClientProperty("NodeCellRenderer.noImage", Boolean.TRUE);
        return this.myEditor;
    }

    private void initEditor(NodeRealizer realizer) {
        CellRendererPanel.SuperValidate wrapper = new CellRendererPanel.SuperValidate();
        wrapper.setLayout((LayoutManager)new BorderLayout());
        wrapper.setFocusable(false);
        CellRendererPanel.SuperPreferredSize innerPanel = new CellRendererPanel.SuperPreferredSize();
        innerPanel.setLayout(new BorderLayout());
        CellRendererPanel.SuperPreferredSize outerPanel = new CellRendererPanel.SuperPreferredSize();
        outerPanel.setLayout(new BorderLayout());
        outerPanel.add((Component)innerPanel, "Center");
        DefaultUmlRenderer umlRenderer = ((DiagramPresentationModelImpl)this.myBuilder.getPresentationModel()).getRenderer();
        outerPanel.setBorder(new LineBorder(umlRenderer.getSelectionColor(), umlRenderer.getSelectionBorderWidth(), true));
        innerPanel.setBorder(new LineBorder(umlRenderer.getSelectionColor()));
        outerPanel.setFocusable(false);
        innerPanel.setFocusable(false);
        Point p = UmlUtils.getNodeCoordinatesOnScreen(realizer.getNode(), this.myBuilder.getView());
        innerPanel.putClientProperty("cell.editor", Boolean.TRUE);
        umlRenderer.tuneNode(realizer, (JPanel)innerPanel, p);
        wrapper.add((Component)outerPanel, (Object)"Center");
        this.myEditor = wrapper;
        DiagramNodeEditorManager.getInstance().setCurrentCellEditor(this, this.myBuilder);
    }

    @Override
    public boolean stopCellEditing() {
        super.stopCellEditing();
        DiagramNodeEditorManager.getInstance().setCurrentCellEditor(null, this.myBuilder);
        DiagramNodeEditorManager.getInstance().stopEditing(this.myBuilder);
        return true;
    }

    @Override
    public void cancelCellEditing() {
        DiagramNodeEditorManager.getInstance().setCurrentCellEditor(null, this.myBuilder);
        super.cancelCellEditing();
    }
}

