/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.completion.CompletionLookupArrangerImpl;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.LookupElementListPresenter;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.ShowHideIntentionIconLookupAction;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.lookup.DeferredUserLookupValue;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupActionProvider;
import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementAction;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.impl.Advertiser;
import com.intellij.codeInsight.lookup.impl.CompletionExtender;
import com.intellij.codeInsight.lookup.impl.EmptyLookupItem;
import com.intellij.codeInsight.lookup.impl.LookupActionsStep;
import com.intellij.codeInsight.lookup.impl.LookupCellRenderer;
import com.intellij.codeInsight.lookup.impl.LookupOffsets;
import com.intellij.codeInsight.lookup.impl.LookupPreview;
import com.intellij.codeInsight.lookup.impl.LookupUi;
import com.intellij.codeInsight.lookup.impl.PrefixChangeListener;
import com.intellij.codeInsight.lookup.impl.actions.ChooseItemAction;
import com.intellij.codeInsight.template.impl.actions.NextVariableAction;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.ui.UISettings;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.LangBundle;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.impl.FontPreferencesImpl;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.ui.ClickListener;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LookupImpl
extends LightweightHint
implements LookupEx,
Disposable,
LookupElementListPresenter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.lookup.impl.LookupImpl");
    private static final Key<Font> CUSTOM_FONT_KEY = Key.create((String)"CustomLookupElementFont");
    private final LookupOffsets myOffsets;
    private final Project myProject;
    private final Editor myEditor;
    private final Object myArrangerLock;
    private final Object myUiLock;
    private final JBList myList;
    final LookupCellRenderer myCellRenderer;
    private final List<LookupListener> myListeners;
    private final List<PrefixChangeListener> myPrefixChangeListeners;
    private final LookupPreview myPreview;
    private final FontPreferences myFontPreferences;
    private long myStampShown;
    private boolean myShown;
    private boolean myDisposed;
    private boolean myHidden;
    private boolean mySelectionTouched;
    private FocusDegree myFocusDegree;
    private volatile boolean myCalculating;
    private final Advertiser myAdComponent;
    volatile int myLookupTextWidth;
    private boolean myChangeGuard;
    private volatile LookupArranger myArranger;
    private LookupArranger myPresentableArranger;
    private boolean myStartCompletionWhenNothingMatches;
    boolean myResizePending;
    private boolean myFinishing;
    boolean myUpdating;
    private LookupUi myUi;
    private static Throwable staticDisposeTrace = null;
    private Throwable disposeTrace;

    public LookupImpl(Project project, Editor editor, @NotNull LookupArranger arranger) {
        if (arranger == null) {
            LookupImpl.$$$reportNull$$$0(0);
        }
        super(new JPanel(new BorderLayout()));
        this.myArrangerLock = new Object();
        this.myUiLock = new Object();
        this.myList = new JBList<LookupElement>((ListModel)new CollectionListModel((Object[])new LookupElement[0])){

            protected void processKeyEvent(@NotNull KeyEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                LookupImpl.this.myEditor.getContentComponent().dispatchEvent(e);
            }

            @NotNull
            protected ExpandableItemsHandler<Integer> createExpandableItemsHandler() {
                CompletionExtender completionExtender = new CompletionExtender((JList)((Object)this));
                if (completionExtender == null) {
                    1.$$$reportNull$$$0(1);
                }
                return completionExtender;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInsight/lookup/impl/LookupImpl$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInsight/lookup/impl/LookupImpl$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createExpandableItemsHandler";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "processKeyEvent";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myPrefixChangeListeners = ContainerUtil.newSmartList();
        this.myPreview = new LookupPreview(this);
        this.myFontPreferences = new FontPreferencesImpl();
        this.myStampShown = 0L;
        this.myShown = false;
        this.myDisposed = false;
        this.myHidden = false;
        this.myFocusDegree = FocusDegree.FOCUSED;
        this.myLookupTextWidth = 50;
        this.disposeTrace = null;
        this.setForceShowAsPopup(true);
        this.setCancelOnClickOutside(false);
        this.setResizable(true);
        this.myProject = project;
        this.myEditor = InjectedLanguageUtil.getTopLevelEditor(editor);
        this.myArranger = arranger;
        this.myPresentableArranger = arranger;
        this.myEditor.getColorsScheme().getFontPreferences().copyTo(this.myFontPreferences);
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).disableUpdateByTimer((Disposable)this);
        this.myCellRenderer = new LookupCellRenderer(this);
        this.myList.setCellRenderer((ListCellRenderer)this.myCellRenderer);
        this.myList.setFocusable(false);
        this.myList.setFixedCellWidth(50);
        AccessibleContextUtil.setParent((Component)this.myList, (Component)this.myEditor.getContentComponent());
        this.myList.setSelectionMode(0);
        this.myList.setBackground(LookupCellRenderer.BACKGROUND_COLOR);
        this.myList.getExpandableItemsHandler();
        this.myAdComponent = new Advertiser();
        this.myOffsets = new LookupOffsets(this.myEditor);
        CollectionListModel<LookupElement> model = this.getListModel();
        this.addEmptyItem(model);
        this.updateListHeight((ListModel)model);
        this.addListeners();
    }

    private CollectionListModel<LookupElement> getListModel() {
        return (CollectionListModel)this.myList.getModel();
    }

    public void setArranger(LookupArranger arranger) {
        this.myArranger = arranger;
    }

    @Override
    public FocusDegree getFocusDegree() {
        return this.myFocusDegree;
    }

    public boolean isFocused() {
        return this.getFocusDegree() == FocusDegree.FOCUSED;
    }

    public void setFocusDegree(FocusDegree focusDegree) {
        this.myFocusDegree = focusDegree;
    }

    public boolean isCalculating() {
        return this.myCalculating;
    }

    public void setCalculating(boolean calculating) {
        this.myCalculating = calculating;
        if (this.myUi != null) {
            this.myUi.setCalculating(calculating);
        }
    }

    public void markSelectionTouched() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
        this.mySelectionTouched = true;
        this.myList.repaint();
    }

    public void setSelectionTouched(boolean selectionTouched) {
        this.mySelectionTouched = selectionTouched;
    }

    @Override
    public int getSelectedIndex() {
        return this.myList.getSelectedIndex();
    }

    public void repaintLookup(boolean onExplicitAction, boolean reused, boolean selectionVisible, boolean itemsChanged) {
        this.myUi.refreshUi(selectionVisible, itemsChanged, reused, onExplicitAction);
    }

    public void resort(boolean addAgain) {
        List<LookupElement> items = this.getItems();
        this.withLock(() -> {
            this.myPresentableArranger.prefixChanged(this);
            this.getListModel().removeAll();
            return null;
        });
        if (addAgain) {
            for (LookupElement item : items) {
                this.addItem(item, this.itemMatcher(item));
            }
        }
        this.refreshUi(true, true);
    }

    public boolean addItem(LookupElement item, PrefixMatcher matcher) {
        LookupElementPresentation presentation = LookupImpl.renderItemApproximately(item);
        if (LookupImpl.containsDummyIdentifier(presentation.getItemText()) || LookupImpl.containsDummyIdentifier(presentation.getTailText()) || LookupImpl.containsDummyIdentifier(presentation.getTypeText())) {
            return false;
        }
        this.updateLookupWidth(item, presentation);
        this.withLock(() -> {
            this.myArranger.registerMatcher(item, matcher);
            this.myArranger.addElement(item, presentation);
            return null;
        });
        return true;
    }

    private static boolean containsDummyIdentifier(@Nullable String s) {
        return s != null && s.contains(CompletionUtil.DUMMY_IDENTIFIER_TRIMMED);
    }

    public void updateLookupWidth(LookupElement item) {
        this.updateLookupWidth(item, LookupImpl.renderItemApproximately(item));
    }

    private void updateLookupWidth(LookupElement item, LookupElementPresentation presentation) {
        Font customFont = this.myCellRenderer.getFontAbleToDisplay(presentation);
        if (customFont != null) {
            item.putUserData(CUSTOM_FONT_KEY, (Object)customFont);
        }
        int maxWidth = this.myCellRenderer.updateMaximumWidth(presentation, item);
        this.myLookupTextWidth = Math.max(maxWidth, this.myLookupTextWidth);
    }

    @Nullable
    Font getCustomFont(LookupElement item, boolean bold) {
        Font font = (Font)item.getUserData(CUSTOM_FONT_KEY);
        return font == null ? null : (bold ? font.deriveFont(1) : font);
    }

    public void requestResize() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myResizePending = true;
    }

    public Collection<LookupElementAction> getActionsFor(LookupElement element) {
        CollectConsumer consumer = new CollectConsumer();
        for (LookupActionProvider provider : (LookupActionProvider[])LookupActionProvider.EP_NAME.getExtensions()) {
            provider.fillActions(element, this, (Consumer<LookupElementAction>)consumer);
        }
        if (!consumer.getResult().isEmpty()) {
            consumer.consume((Object)new ShowHideIntentionIconLookupAction());
        }
        return consumer.getResult();
    }

    public JList getList() {
        return this.myList;
    }

    public List<LookupElement> getItems() {
        return (List)this.withLock(() -> ContainerUtil.findAll((Collection)this.getListModel().toList(), element -> !(element instanceof EmptyLookupItem)));
    }

    @Override
    @NotNull
    public String getAdditionalPrefix() {
        String string = this.myOffsets.getAdditionalPrefix();
        if (string == null) {
            LookupImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    void fireBeforeAppendPrefix(char c) {
        this.myPrefixChangeListeners.forEach(listener2 -> listener2.beforeAppend(c));
    }

    void appendPrefix(char c) {
        this.checkValid();
        this.myOffsets.appendPrefix(c);
        this.withLock(() -> {
            this.myPresentableArranger.prefixChanged(this);
            return null;
        });
        this.requestResize();
        this.refreshUi(false, true);
        this.ensureSelectionVisible(true);
        this.myPrefixChangeListeners.forEach(listener2 -> listener2.afterAppend(c));
    }

    public void setStartCompletionWhenNothingMatches(boolean startCompletionWhenNothingMatches) {
        this.myStartCompletionWhenNothingMatches = startCompletionWhenNothingMatches;
    }

    public boolean isStartCompletionWhenNothingMatches() {
        return this.myStartCompletionWhenNothingMatches;
    }

    public void ensureSelectionVisible(boolean forceTopSelection) {
        int firstVisibleIndex;
        if (this.isSelectionVisible() && !forceTopSelection) {
            return;
        }
        if (!forceTopSelection) {
            ScrollingUtil.ensureIndexIsVisible((JList)this.myList, (int)this.myList.getSelectedIndex(), (int)1);
            return;
        }
        int top = this.myList.getSelectedIndex();
        if (top > 0) {
            --top;
        }
        if ((firstVisibleIndex = this.myList.getFirstVisibleIndex()) == top) {
            return;
        }
        ScrollingUtil.ensureRangeIsVisible((JList)this.myList, (int)top, (int)(top + this.myList.getLastVisibleIndex() - firstVisibleIndex));
    }

    boolean truncatePrefix(boolean preserveSelection) {
        if (!this.myOffsets.truncatePrefix()) {
            return false;
        }
        this.myPrefixChangeListeners.forEach(listener2 -> listener2.beforeTruncate());
        if (preserveSelection) {
            this.markSelectionTouched();
        }
        boolean shouldUpdate = (Boolean)this.withLock(() -> {
            this.myPresentableArranger.prefixChanged(this);
            return this.myPresentableArranger == this.myArranger;
        });
        this.requestResize();
        if (shouldUpdate) {
            this.refreshUi(false, true);
            this.ensureSelectionVisible(true);
        }
        this.myPrefixChangeListeners.forEach(listener2 -> listener2.afterTruncate());
        return true;
    }

    void moveToCaretPosition() {
        this.myOffsets.destabilizeLookupStart();
        this.refreshUi(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateList(boolean onExplicitAction, boolean reused) {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
        this.checkValid();
        CollectionListModel<LookupElement> listModel = this.getListModel();
        Pair pair = (Pair)this.withLock(() -> this.myPresentableArranger.arrangeItems(this, onExplicitAction || reused));
        List items = (List)pair.first;
        Integer toSelect2 = (Integer)pair.second;
        if (toSelect2 == null || toSelect2 < 0 || items.size() > 0 && toSelect2 >= items.size()) {
            LOG.error("Arranger " + this.myPresentableArranger + " returned invalid selection index=" + toSelect2 + "; items=" + items);
            toSelect2 = 0;
        }
        this.myOffsets.checkMinPrefixLengthChanges(items, this);
        List oldModel = listModel.toList();
        Object object = this.myUiLock;
        synchronized (object) {
            listModel.removeAll();
            if (!items.isEmpty()) {
                listModel.add(items);
            } else {
                this.addEmptyItem(listModel);
            }
        }
        this.updateListHeight((ListModel)listModel);
        this.myList.setSelectedIndex(toSelect2.intValue());
        return !ContainerUtil.equalsIdentity((List)oldModel, (List)items);
    }

    public boolean isSelectionVisible() {
        return ScrollingUtil.isIndexFullyVisible((JList)this.myList, (int)this.myList.getSelectedIndex());
    }

    private boolean checkReused() {
        return (Boolean)this.withLock(() -> {
            if (this.myPresentableArranger != this.myArranger) {
                this.myPresentableArranger = this.myArranger;
                this.myOffsets.clearAdditionalPrefix();
                this.myPresentableArranger.prefixChanged(this);
                return true;
            }
            return false;
        });
    }

    private void updateListHeight(ListModel model) {
        this.myList.setFixedCellHeight(this.myCellRenderer.getListCellRendererComponent((JList)this.myList, model.getElementAt((int)0), (int)0, (boolean)false, (boolean)false).getPreferredSize().height);
        this.myList.setVisibleRowCount(Math.min(model.getSize(), UISettings.getInstance().getMaxLookupListHeight()));
    }

    private void addEmptyItem(CollectionListModel<LookupElement> model) {
        EmptyLookupItem item = new EmptyLookupItem(this.myCalculating ? " " : LangBundle.message("completion.no.suggestions", new Object[0]), false);
        model.add((Object)item);
        this.updateLookupWidth(item);
        this.requestResize();
    }

    private static LookupElementPresentation renderItemApproximately(LookupElement item) {
        LookupElementPresentation p = new LookupElementPresentation();
        item.renderElement(p);
        return p;
    }

    @NotNull
    public String itemPattern(@NotNull LookupElement element) {
        if (element == null) {
            LookupImpl.$$$reportNull$$$0(2);
        }
        if (element instanceof EmptyLookupItem) {
            if ("" == null) {
                LookupImpl.$$$reportNull$$$0(3);
            }
            return "";
        }
        String string = this.myPresentableArranger.itemPattern(element);
        if (string == null) {
            LookupImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public PrefixMatcher itemMatcher(@NotNull LookupElement item) {
        if (item == null) {
            LookupImpl.$$$reportNull$$$0(5);
        }
        if (item instanceof EmptyLookupItem) {
            CamelHumpMatcher camelHumpMatcher = new CamelHumpMatcher("");
            if (camelHumpMatcher == null) {
                LookupImpl.$$$reportNull$$$0(6);
            }
            return camelHumpMatcher;
        }
        PrefixMatcher prefixMatcher = this.myPresentableArranger.itemMatcher(item);
        if (prefixMatcher == null) {
            LookupImpl.$$$reportNull$$$0(7);
        }
        return prefixMatcher;
    }

    public void finishLookup(char completionChar) {
        this.finishLookup(completionChar, (LookupElement)this.myList.getSelectedValue());
    }

    public void finishLookup(char completionChar, @Nullable LookupElement item) {
        boolean writableOk;
        LOG.assertTrue(!ApplicationManager.getApplication().isWriteAccessAllowed(), (Object)"finishLookup should be called without a write action");
        PsiFile file2 = this.getPsiFile();
        boolean bl = writableOk = file2 == null || FileModificationService.getInstance().prepareFileForWrite(file2);
        if (this.myDisposed) {
            return;
        }
        if (!writableOk) {
            this.fireBeforeItemSelected(null, completionChar);
            this.doHide(false, true);
            this.fireItemSelected(null, completionChar);
            return;
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> this.finishLookupInWritableFile(completionChar, item), null, null);
    }

    void finishLookupInWritableFile(char completionChar, @Nullable LookupElement item) {
        if (item == null || !item.isValid() || item instanceof EmptyLookupItem || item.getObject() instanceof DeferredUserLookupValue && item.as(LookupItem.CLASS_CONDITION_KEY) != null && !((DeferredUserLookupValue)item.getObject()).handleUserSelection((LookupItem)item.as(LookupItem.CLASS_CONDITION_KEY), this.myProject)) {
            this.fireBeforeItemSelected(null, completionChar);
            this.doHide(false, true);
            this.fireItemSelected(null, completionChar);
            return;
        }
        if (this.myDisposed) {
            return;
        }
        String prefix = this.itemPattern(item);
        boolean plainMatch = ContainerUtil.or((Iterable)item.getAllLookupStrings(), s -> StringUtil.containsIgnoreCase((String)s, (String)prefix));
        if (!plainMatch) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.camelHumps");
        }
        this.myFinishing = true;
        if (this.fireBeforeItemSelected(item, completionChar)) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                this.myEditor.getDocument().startGuardedBlockChecking();
                try {
                    this.insertLookupString(item, this.getPrefixLength(item));
                }
                finally {
                    this.myEditor.getDocument().stopGuardedBlockChecking();
                }
            });
        }
        if (this.myDisposed) {
            return;
        }
        this.doHide(false, true);
        this.fireItemSelected(item, completionChar);
    }

    public int getPrefixLength(LookupElement item) {
        return this.myOffsets.getPrefixLength(item, this);
    }

    protected void insertLookupString(LookupElement item, int prefix) {
        LookupImpl.insertLookupString(this.myProject, this.getTopLevelEditor(), item, this.itemMatcher(item), this.itemPattern(item), prefix);
    }

    public static void insertLookupString(final Project project, final Editor editor, LookupElement item, PrefixMatcher matcher, String itemPattern, final int prefixLength) {
        final String lookupString = LookupImpl.getCaseCorrectedLookupString(item, matcher, itemPattern);
        final Editor hostEditor = editor;
        hostEditor.getCaretModel().runForEachCaret(new CaretAction(){

            public void perform(Caret caret) {
                EditorModificationUtil.deleteSelectedText((Editor)hostEditor);
                int caretOffset = hostEditor.getCaretModel().getOffset();
                int offset = LookupImpl.insertLookupInDocumentWindowIfNeeded(project, editor, caretOffset, prefixLength, lookupString);
                hostEditor.getCaretModel().moveToOffset(offset);
                hostEditor.getSelectionModel().removeSelection();
            }
        });
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }

    private static int insertLookupInDocumentWindowIfNeeded(Project project, Editor editor, int caretOffset, int prefix, String lookupString) {
        List ranges;
        DocumentWindow document = LookupImpl.getInjectedDocument(project, editor, caretOffset);
        if (document == null) {
            return LookupImpl.insertLookupInDocument(caretOffset, editor.getDocument(), prefix, lookupString);
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile((Document)document);
        int offset = document.hostToInjected(caretOffset);
        int lookupStart = Math.min(offset, Math.max(offset - prefix, 0));
        int diff = -1;
        if (file2 != null && !(ranges = InjectedLanguageManager.getInstance((Project)project).intersectWithAllEditableFragments(file2, TextRange.create((int)lookupStart, (int)offset))).isEmpty()) {
            diff = ((TextRange)ranges.get(0)).getStartOffset() - lookupStart;
            if (ranges.size() == 1 && diff == 0) {
                diff = -1;
            }
        }
        if (diff == -1) {
            return LookupImpl.insertLookupInDocument(caretOffset, editor.getDocument(), prefix, lookupString);
        }
        return document.injectedToHost(LookupImpl.insertLookupInDocument(offset, (Document)document, prefix - diff, diff == 0 ? lookupString : lookupString.substring(diff)));
    }

    private static int insertLookupInDocument(int caretOffset, Document document, int prefix, String lookupString) {
        int lookupStart = Math.min(caretOffset, Math.max(caretOffset - prefix, 0));
        int len = document.getTextLength();
        LOG.assertTrue(lookupStart >= 0 && lookupStart <= len, (Object)("ls: " + lookupStart + " caret: " + caretOffset + " prefix:" + prefix + " doc: " + len));
        LOG.assertTrue(caretOffset >= 0 && caretOffset <= len, (Object)("co: " + caretOffset + " doc: " + len));
        document.replaceString(lookupStart, caretOffset, (CharSequence)lookupString);
        return lookupStart + lookupString.length();
    }

    private static String getCaseCorrectedLookupString(LookupElement item, PrefixMatcher prefixMatcher, String prefix) {
        String lookupString = item.getLookupString();
        if (item.isCaseSensitive()) {
            return lookupString;
        }
        int length = prefix.length();
        if (length == 0 || !prefixMatcher.prefixMatches(prefix)) {
            return lookupString;
        }
        boolean isAllLower = true;
        boolean isAllUpper = true;
        boolean sameCase = true;
        for (int i = 0; i < length && (isAllLower || isAllUpper || sameCase); ++i) {
            char c = prefix.charAt(i);
            boolean isLower = Character.isLowerCase(c);
            boolean isUpper = Character.isUpperCase(c);
            if (!isLower && !isUpper) continue;
            isAllLower = isAllLower && isLower;
            isAllUpper = isAllUpper && isUpper;
            sameCase = sameCase && i < lookupString.length() && isLower == Character.isLowerCase(lookupString.charAt(i));
        }
        if (sameCase) {
            return lookupString;
        }
        if (isAllLower) {
            return lookupString.toLowerCase();
        }
        if (isAllUpper) {
            return StringUtil.toUpperCase((String)lookupString);
        }
        return lookupString;
    }

    public int getLookupStart() {
        return this.myOffsets.getLookupStart(this.disposeTrace);
    }

    public int getLookupOriginalStart() {
        return this.myOffsets.getLookupOriginalStart();
    }

    public boolean performGuardedChange(Runnable change) {
        boolean result2;
        this.checkValid();
        assert (!this.myChangeGuard) : "already in change";
        this.myEditor.getDocument().startGuardedBlockChecking();
        this.myChangeGuard = true;
        try {
            result2 = this.myOffsets.performGuardedChange(change);
        }
        finally {
            this.myEditor.getDocument().stopGuardedBlockChecking();
            this.myChangeGuard = false;
        }
        if (!result2 || this.myDisposed) {
            this.hideLookup(false);
            return false;
        }
        if (this.isVisible()) {
            HintManagerImpl.updateLocation(this, this.myEditor, this.myUi.calculatePosition().getLocation());
        }
        this.checkValid();
        return true;
    }

    @Override
    public boolean vetoesHiding() {
        return this.myChangeGuard;
    }

    public boolean isAvailableToUser() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return this.myShown;
        }
        return this.isVisible();
    }

    @Override
    public boolean isShown() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
        return this.myShown;
    }

    public boolean showLookup() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkValid();
        LOG.assertTrue(!this.myShown);
        this.myShown = true;
        this.myStampShown = System.currentTimeMillis();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        if (!this.myEditor.getContentComponent().isShowing()) {
            this.hideLookup(false);
            return false;
        }
        this.myAdComponent.showRandomText();
        if (Boolean.TRUE.equals(this.myEditor.getUserData(AutoPopupController.NO_ADS))) {
            this.myAdComponent.clearAdvertisements();
        }
        this.myUi = new LookupUi(this, this.myAdComponent, this.myList, this.myProject);
        this.myUi.setCalculating(this.myCalculating);
        Point p = this.myUi.calculatePosition().getLocation();
        if (ScreenReader.isActive()) {
            this.myList.setFocusable(true);
            this.setFocusRequestor((JComponent)this.myList);
            AnActionEvent actionEvent = AnActionEvent.createFromDataContext((String)"EditorPopup", null, (DataContext)((EditorImpl)this.myEditor).getDataContext());
            this.delegateActionToEditor("EditorBackSpace", null, actionEvent);
            this.delegateActionToEditor("EditorEscape", null, actionEvent);
            this.delegateActionToEditor("EditorTab", () -> new ChooseItemAction.Replacing(), actionEvent);
            this.delegateActionToEditor("EditorEnter", () -> this.getFocusDegree() == FocusDegree.UNFOCUSED ? new NextVariableAction() : new ChooseItemAction.FocusedOnly(), actionEvent);
            this.delegateActionToEditor("EditorUp", null, actionEvent);
            this.delegateActionToEditor("EditorDown", null, actionEvent);
            this.delegateActionToEditor("EditorRight", null, actionEvent);
            this.delegateActionToEditor("EditorLeft", null, actionEvent);
            this.delegateActionToEditor("RenameElement", null, actionEvent);
        }
        try {
            HintManagerImpl.getInstanceImpl().showEditorHint((LightweightHint)this, this.myEditor, p, 129, 0, false, HintManagerImpl.createHintHint(this.myEditor, p, this, (short)2).setRequestFocus(ScreenReader.isActive()).setAwtTooltip(false));
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        if (!this.isVisible() || !this.myList.isShowing()) {
            this.hideLookup(false);
            return false;
        }
        return true;
    }

    private void delegateActionToEditor(@NotNull String actionID, @Nullable Supplier<AnAction> delegateActionSupplier, @NotNull AnActionEvent actionEvent) {
        if (actionID == null) {
            LookupImpl.$$$reportNull$$$0(8);
        }
        if (actionEvent == null) {
            LookupImpl.$$$reportNull$$$0(9);
        }
        AnAction action = ActionManager.getInstance().getAction(actionID);
        DumbAwareAction.create(e -> {
            if (actionEvent == null) {
                LookupImpl.$$$reportNull$$$0(18);
            }
            ActionUtil.performActionDumbAware((AnAction)(delegateActionSupplier == null ? action : (AnAction)delegateActionSupplier.get()), (AnActionEvent)actionEvent);
        }).registerCustomShortcutSet(action.getShortcutSet(), (JComponent)this.myList);
    }

    public Advertiser getAdvertiser() {
        return this.myAdComponent;
    }

    public boolean mayBeNoticed() {
        return this.myStampShown > 0L && System.currentTimeMillis() - this.myStampShown > 300L;
    }

    private void addListeners() {
        this.myEditor.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!LookupImpl.this.myChangeGuard && !LookupImpl.this.myFinishing) {
                    LookupImpl.this.hideLookup(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/lookup/impl/LookupImpl$3", "documentChanged"));
            }
        }, (Disposable)this);
        EditorMouseListener mouseListener = new EditorMouseListener(){

            public void mouseClicked(@NotNull EditorMouseEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                e.consume();
                LookupImpl.this.hideLookup(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/lookup/impl/LookupImpl$4", "mouseClicked"));
            }
        };
        this.myEditor.getCaretModel().addCaretListener(new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (!LookupImpl.this.myChangeGuard && !LookupImpl.this.myFinishing) {
                    LookupImpl.this.hideLookup(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/lookup/impl/LookupImpl$5", "caretPositionChanged"));
            }
        }, (Disposable)this);
        this.myEditor.getSelectionModel().addSelectionListener(new SelectionListener(){

            public void selectionChanged(@NotNull SelectionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (!LookupImpl.this.myChangeGuard && !LookupImpl.this.myFinishing) {
                    LookupImpl.this.hideLookup(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/lookup/impl/LookupImpl$6", "selectionChanged"));
            }
        }, (Disposable)this);
        this.myEditor.addEditorMouseListener(mouseListener, (Disposable)this);
        JComponent editorComponent = this.myEditor.getContentComponent();
        if (editorComponent.isShowing()) {
            Disposer.register((Disposable)this, (Disposable)new UiNotifyConnector((Component)editorComponent, new Activatable(){

                public void showNotify() {
                }

                public void hideNotify() {
                    LookupImpl.this.hideLookup(false);
                }
            }));
        }
        this.myList.addListSelectionListener(new ListSelectionListener(){
            private LookupElement oldItem = null;

            @Override
            public void valueChanged(@NotNull ListSelectionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(0);
                }
                if (!LookupImpl.this.myUpdating) {
                    LookupElement item = LookupImpl.this.getCurrentItem();
                    LookupImpl.this.fireCurrentItemChanged(this.oldItem, item);
                    this.oldItem = item;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/lookup/impl/LookupImpl$8", "valueChanged"));
            }
        });
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    9.$$$reportNull$$$0(0);
                }
                LookupImpl.this.setFocusDegree(FocusDegree.FOCUSED);
                LookupImpl.this.markSelectionTouched();
                if (clickCount == 2) {
                    CommandProcessor.getInstance().executeCommand(LookupImpl.this.myProject, () -> LookupImpl.this.finishLookup('\n'), "", null, LookupImpl.this.myEditor.getDocument());
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/lookup/impl/LookupImpl$9", "onClick"));
            }
        }.installOn((Component)this.myList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public LookupElement getCurrentItem() {
        Object object = this.myUiLock;
        synchronized (object) {
            LookupElement item = (LookupElement)this.myList.getSelectedValue();
            return item instanceof EmptyLookupItem ? null : item;
        }
    }

    @Override
    public LookupElement getCurrentItemOrEmpty() {
        return (LookupElement)this.myList.getSelectedValue();
    }

    @Override
    public void setCurrentItem(LookupElement item) {
        this.markSelectionTouched();
        this.myList.setSelectedValue((Object)item, false);
    }

    public void addLookupListener(LookupListener listener2) {
        this.myListeners.add(listener2);
    }

    public void removeLookupListener(LookupListener listener2) {
        this.myListeners.remove(listener2);
    }

    public Rectangle getCurrentItemBounds() {
        Rectangle itmBounds;
        int index = this.myList.getSelectedIndex();
        if (index < 0) {
            LOG.error("No selected element, size=" + this.getListModel().getSize() + "; items" + this.getItems());
        }
        if ((itmBounds = this.myList.getCellBounds(index, index)) == null) {
            LOG.error("No bounds for " + index + "; size=" + this.getListModel().getSize());
            return null;
        }
        Point layeredPanePoint = SwingUtilities.convertPoint((Component)this.myList, itmBounds.x, itmBounds.y, this.getComponent());
        itmBounds.x = layeredPanePoint.x;
        itmBounds.y = layeredPanePoint.y;
        return itmBounds;
    }

    private boolean fireBeforeItemSelected(@Nullable LookupElement item, char completionChar) {
        boolean result2 = true;
        if (!this.myListeners.isEmpty()) {
            LookupEvent event = new LookupEvent((Lookup)this, item, completionChar);
            for (LookupListener listener2 : this.myListeners) {
                try {
                    if (listener2.beforeItemSelected(event)) continue;
                    result2 = false;
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
        return result2;
    }

    public void fireItemSelected(@Nullable LookupElement item, char completionChar) {
        if (item != null && item.requiresCommittedDocuments()) {
            PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        }
        this.myArranger.itemSelected(item, completionChar);
        if (!this.myListeners.isEmpty()) {
            LookupEvent event = new LookupEvent((Lookup)this, item, completionChar);
            for (LookupListener listener2 : this.myListeners) {
                try {
                    listener2.itemSelected(event);
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
    }

    private void fireLookupCanceled(boolean explicitly) {
        if (!this.myListeners.isEmpty()) {
            LookupEvent event = new LookupEvent((Lookup)this, explicitly);
            for (LookupListener listener2 : this.myListeners) {
                try {
                    listener2.lookupCanceled(event);
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
    }

    private void fireCurrentItemChanged(@Nullable LookupElement oldItem, @Nullable LookupElement currentItem) {
        if (oldItem != currentItem && !this.myListeners.isEmpty()) {
            LookupEvent event = new LookupEvent((Lookup)this, currentItem, '\u0000');
            for (LookupListener listener2 : this.myListeners) {
                listener2.currentItemChanged(event);
            }
        }
        this.myPreview.updatePreview(currentItem);
    }

    private void fireUiRefreshed() {
        for (LookupListener listener2 : this.myListeners) {
            listener2.uiRefreshed();
        }
    }

    public void replacePrefix(String presentPrefix, String newPrefix) {
        if (!this.performGuardedChange(() -> {
            EditorModificationUtil.deleteSelectedText((Editor)this.myEditor);
            int offset = this.myEditor.getCaretModel().getOffset();
            int start2 = offset - presentPrefix.length();
            this.myEditor.getDocument().replaceString(start2, offset, (CharSequence)newPrefix);
            this.myOffsets.clearAdditionalPrefix();
            this.myEditor.getCaretModel().moveToOffset(start2 + newPrefix.length());
        })) {
            return;
        }
        this.withLock(() -> {
            this.myPresentableArranger.prefixReplaced(this, newPrefix);
            return null;
        });
        this.refreshUi(true, true);
    }

    @Nullable
    public PsiFile getPsiFile() {
        return PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.getEditor().getDocument());
    }

    public boolean isCompletion() {
        return this.myArranger instanceof CompletionLookupArrangerImpl;
    }

    public PsiElement getPsiElement() {
        PsiFile file2 = this.getPsiFile();
        if (file2 == null) {
            return null;
        }
        int offset = this.getLookupStart();
        Editor editor = this.getEditor();
        if (editor instanceof EditorWindow) {
            offset = editor.logicalPositionToOffset(((EditorWindow)editor).hostToInjected(this.myEditor.offsetToLogicalPosition(offset)));
        }
        if (offset > 0) {
            return file2.findElementAt(offset - 1);
        }
        return file2.findElementAt(0);
    }

    @Nullable
    private static DocumentWindow getInjectedDocument(Project project, Editor editor, int offset) {
        PsiFile hostFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (hostFile != null) {
            List injected = InjectedLanguageManager.getInstance((Project)project).getCachedInjectedDocumentsInRange(hostFile, TextRange.create((int)offset, (int)offset));
            for (DocumentWindow documentWindow : injected) {
                if (!documentWindow.isValid() || !documentWindow.containsRange(offset, offset)) continue;
                return documentWindow;
            }
        }
        return null;
    }

    @NotNull
    public Editor getEditor() {
        DocumentWindow documentWindow = LookupImpl.getInjectedDocument(this.myProject, this.myEditor, this.myEditor.getCaretModel().getOffset());
        if (documentWindow != null) {
            PsiFile injectedFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile((Document)documentWindow);
            Editor editor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(this.myEditor, injectedFile);
            if (editor == null) {
                LookupImpl.$$$reportNull$$$0(10);
            }
            return editor;
        }
        Editor editor = this.myEditor;
        if (editor == null) {
            LookupImpl.$$$reportNull$$$0(11);
        }
        return editor;
    }

    @NotNull
    public Editor getTopLevelEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            LookupImpl.$$$reportNull$$$0(12);
        }
        return editor;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            LookupImpl.$$$reportNull$$$0(13);
        }
        return project;
    }

    public boolean isPositionedAboveCaret() {
        return this.myUi != null && this.myUi.isPositionedAboveCaret();
    }

    @Override
    public boolean isSelectionTouched() {
        return this.mySelectionTouched;
    }

    @Override
    public int getLastVisibleIndex() {
        return this.myList.getLastVisibleIndex();
    }

    public List<String> getAdvertisements() {
        return this.myAdComponent.getAdvertisements();
    }

    @Override
    public void hide() {
        this.hideLookup(true);
    }

    public void hideLookup(boolean explicitly) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myHidden) {
            return;
        }
        this.doHide(true, explicitly);
    }

    private void doHide(boolean fireCanceled, boolean explicitly) {
        if (this.myDisposed) {
            LOG.error(this.formatDisposeTrace());
        } else {
            this.myHidden = true;
            try {
                super.hide();
                Disposer.dispose((Disposable)this);
                assert (this.myDisposed);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        if (fireCanceled) {
            this.fireLookupCanceled(explicitly);
        }
    }

    public void restorePrefix() {
        this.myOffsets.restorePrefix();
    }

    public static String getLastLookupDisposeTrace() {
        return ExceptionUtil.getThrowableText((Throwable)staticDisposeTrace);
    }

    public void dispose() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (this.myHidden);
        if (this.myDisposed) {
            LOG.error(this.formatDisposeTrace());
            return;
        }
        this.myOffsets.disposeMarkers();
        this.disposeTrace = new Throwable();
        this.myDisposed = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Disposing lookup:", this.disposeTrace);
        }
        staticDisposeTrace = this.disposeTrace;
    }

    private String formatDisposeTrace() {
        return ExceptionUtil.getThrowableText((Throwable)this.disposeTrace) + "\n============";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshUi(boolean mayCheckReused, boolean onExplicitAction) {
        assert (!this.myUpdating);
        LookupElement prevItem = this.getCurrentItem();
        this.myUpdating = true;
        try {
            boolean reused = mayCheckReused && this.checkReused();
            boolean selectionVisible = this.isSelectionVisible();
            boolean itemsChanged = this.updateList(onExplicitAction, reused);
            if (this.isVisible()) {
                LOG.assertTrue(!ApplicationManager.getApplication().isUnitTestMode());
                this.myUi.refreshUi(selectionVisible, itemsChanged, reused, onExplicitAction);
            }
        }
        finally {
            this.myUpdating = false;
            this.fireCurrentItemChanged(prevItem, this.getCurrentItem());
            this.fireUiRefreshed();
        }
    }

    public void markReused() {
        this.withLock(() -> {
            this.myArranger = this.myArranger.createEmptyCopy();
            return this.myArranger;
        });
        this.requestResize();
    }

    public void addAdvertisement(@NotNull String text, @Nullable Color bgColor) {
        if (text == null) {
            LookupImpl.$$$reportNull$$$0(14);
        }
        if (LookupImpl.containsDummyIdentifier(text)) {
            return;
        }
        this.myAdComponent.addAdvertisement(text, bgColor);
        this.requestResize();
    }

    public boolean isLookupDisposed() {
        return this.myDisposed;
    }

    public void checkValid() {
        if (this.myDisposed) {
            throw new AssertionError((Object)("Disposed at: " + this.formatDisposeTrace()));
        }
    }

    private void showItemPopup(JBPopup hint) {
        Rectangle bounds2 = this.getCurrentItemBounds();
        hint.show(new RelativePoint(this.getComponent(), new Point(bounds2.x + bounds2.width, bounds2.y)));
    }

    @Override
    public boolean showElementActions() {
        if (!this.isVisible()) {
            return false;
        }
        LookupElement element = this.getCurrentItem();
        if (element == null) {
            return false;
        }
        Collection<LookupElementAction> actions = this.getActionsFor(element);
        if (actions.isEmpty()) {
            return false;
        }
        this.showItemPopup((JBPopup)JBPopupFactory.getInstance().createListPopup((ListPopupStep)new LookupActionsStep(actions, this, element)));
        return true;
    }

    @NotNull
    public Map<LookupElement, List<Pair<String, Object>>> getRelevanceObjects(@NotNull Iterable<LookupElement> items, boolean hideSingleValued) {
        if (items == null) {
            LookupImpl.$$$reportNull$$$0(15);
        }
        Map map = (Map)this.withLock(() -> {
            if (items == null) {
                LookupImpl.$$$reportNull$$$0(17);
            }
            return this.myPresentableArranger.getRelevanceObjects(items, hideSingleValued);
        });
        if (map == null) {
            LookupImpl.$$$reportNull$$$0(16);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withLock(Computable<T> computable) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            HeavyProcessLatch.INSTANCE.stopThreadPrioritizing();
        }
        Object object = this.myArrangerLock;
        synchronized (object) {
            return (T)computable.compute();
        }
    }

    public void setPrefixChangeListener(PrefixChangeListener listener2) {
        this.myPrefixChangeListeners.add(listener2);
    }

    public void addPrefixChangeListener(PrefixChangeListener listener2, Disposable parentDisposable) {
        ContainerUtil.add((Object)listener2, this.myPrefixChangeListeners, (Disposable)parentDisposable);
    }

    FontPreferences getFontPreferences() {
        return this.myFontPreferences;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arranger";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/lookup/impl/LookupImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionID";
                break;
            }
            case 9: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionEvent";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/lookup/impl/LookupImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalPrefix";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "itemPattern";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "itemMatcher";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelEditor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelevanceObjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "itemPattern";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "itemMatcher";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "delegateActionToEditor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addAdvertisement";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getRelevanceObjects";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getRelevanceObjects$21";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$delegateActionToEditor$17";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum FocusDegree {
        FOCUSED,
        SEMI_FOCUSED,
        UNFOCUSED;

    }
}

