/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AbstractVcsAction;
import com.intellij.openapi.vcs.actions.DescindingFilesFilter;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.CommitChangeListDialog;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.UtilKt;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCommonCheckinAction
extends AbstractVcsAction {
    private static final Logger LOG = Logger.getInstance(AbstractCommonCheckinAction.class);

    @Override
    public void actionPerformed(@NotNull VcsContext context) {
        if (context == null) {
            AbstractCommonCheckinAction.$$$reportNull$$$0(0);
        }
        LOG.debug("actionPerformed. ");
        Project project = (Project)ObjectUtils.notNull((Object)context.getProject());
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification("Can not " + this.getMnemonicsFreeActionName(context) + " now")) {
            LOG.debug("ChangeListManager is freezed. returning.");
        } else if (ProjectLevelVcsManager.getInstance((Project)project).isBackgroundVcsOperationRunning()) {
            LOG.debug("Background operation is running. returning.");
        } else {
            FilePath[] roots = this.prepareRootsForCommit(this.getRoots(context), project);
            ChangeListManager.getInstance((Project)project).invokeAfterUpdate(() -> {
                if (context == null) {
                    AbstractCommonCheckinAction.$$$reportNull$$$0(18);
                }
                this.performCheckIn(context, project, roots);
            }, InvokeAfterUpdateMode.SYNCHRONOUS_CANCELLABLE, VcsBundle.message((String)"waiting.changelists.update.for.show.commit.dialog.message", (Object[])new Object[0]), ModalityState.current());
        }
    }

    protected void performCheckIn(@NotNull VcsContext context, @NotNull Project project, @NotNull FilePath[] roots) {
        Collection<Object> included;
        Collection<Object> changesToCommit;
        if (context == null) {
            AbstractCommonCheckinAction.$$$reportNull$$$0(1);
        }
        if (project == null) {
            AbstractCommonCheckinAction.$$$reportNull$$$0(2);
        }
        if (roots == null) {
            AbstractCommonCheckinAction.$$$reportNull$$$0(3);
        }
        LOG.debug("invoking commit dialog after update");
        LocalChangeList initialSelection = this.getInitiallySelectedChangeList(context, project);
        Object[] selectedChanges = context.getSelectedChanges();
        List<Object> selectedChangesList = ArrayUtil.isEmpty((Object[])selectedChanges) ? ContainerUtil.emptyList() : Arrays.asList(selectedChanges);
        List selectedUnversioned = context.getSelectedUnversionedFiles();
        if (!ContainerUtil.isEmpty(selectedChangesList) || !ContainerUtil.isEmpty((Collection)selectedUnversioned)) {
            changesToCommit = selectedChangesList;
            included = ContainerUtil.concat(selectedChangesList, (List)selectedUnversioned);
        } else {
            included = changesToCommit = AbstractCommonCheckinAction.getChangesIn(project, roots);
        }
        CommitChangeListDialog.commitChanges(project, changesToCommit, included, initialSelection, this.getExecutor(project), null);
    }

    @NotNull
    private static Set<Change> getChangesIn(@NotNull Project project, @NotNull FilePath[] roots) {
        if (project == null) {
            AbstractCommonCheckinAction.$$$reportNull$$$0(4);
        }
        if (roots == null) {
            AbstractCommonCheckinAction.$$$reportNull$$$0(5);
        }
        ChangeListManager manager = ChangeListManager.getInstance((Project)project);
        Set<Change> set = UtilKt.stream((Object[])roots).flatMap(path -> manager.getChangesIn(path).stream()).collect(Collectors.toSet());
        if (set == null) {
            AbstractCommonCheckinAction.$$$reportNull$$$0(6);
        }
        return set;
    }

    @NotNull
    protected FilePath[] prepareRootsForCommit(@NotNull FilePath[] roots, @NotNull Project project) {
        if (roots == null) {
            AbstractCommonCheckinAction.$$$reportNull$$$0(7);
        }
        if (project == null) {
            AbstractCommonCheckinAction.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().saveAll();
        FilePath[] filePathArray = DescindingFilesFilter.filterDescindingFiles(roots, project);
        if (filePathArray == null) {
            AbstractCommonCheckinAction.$$$reportNull$$$0(9);
        }
        return filePathArray;
    }

    protected String getMnemonicsFreeActionName(@NotNull VcsContext context) {
        if (context == null) {
            AbstractCommonCheckinAction.$$$reportNull$$$0(10);
        }
        return this.getActionName(context);
    }

    @Nullable
    protected CommitExecutor getExecutor(@NotNull Project project) {
        if (project == null) {
            AbstractCommonCheckinAction.$$$reportNull$$$0(11);
        }
        return null;
    }

    @Nullable
    protected LocalChangeList getInitiallySelectedChangeList(@NotNull VcsContext context, @NotNull Project project) {
        Object[] changes2;
        if (context == null) {
            AbstractCommonCheckinAction.$$$reportNull$$$0(12);
        }
        if (project == null) {
            AbstractCommonCheckinAction.$$$reportNull$$$0(13);
        }
        ChangeListManager manager = ChangeListManager.getInstance((Project)project);
        Object[] changeLists = context.getSelectedChangeLists();
        LocalChangeList result2 = !ArrayUtil.isEmpty((Object[])changeLists) ? manager.findChangeList(changeLists[0].getName()) : (!ArrayUtil.isEmpty((Object[])(changes2 = context.getSelectedChanges())) ? manager.getChangeList((Change)changes2[0]) : manager.getDefaultChangeList());
        return result2;
    }

    protected abstract String getActionName(@NotNull VcsContext var1);

    @NotNull
    protected abstract FilePath[] getRoots(@NotNull VcsContext var1);

    protected abstract boolean approximatelyHasRoots(@NotNull VcsContext var1);

    @Override
    protected void update(@NotNull VcsContext vcsContext, @NotNull Presentation presentation) {
        Project project;
        if (vcsContext == null) {
            AbstractCommonCheckinAction.$$$reportNull$$$0(14);
        }
        if (presentation == null) {
            AbstractCommonCheckinAction.$$$reportNull$$$0(15);
        }
        if ((project = vcsContext.getProject()) == null || !ProjectLevelVcsManager.getInstance((Project)project).hasActiveVcss()) {
            presentation.setEnabledAndVisible(false);
        } else if (!this.approximatelyHasRoots(vcsContext)) {
            presentation.setEnabled(false);
        } else {
            presentation.setText(this.getActionName(vcsContext) + "...");
            presentation.setEnabled(!ProjectLevelVcsManager.getInstance((Project)project).isBackgroundVcsOperationRunning());
            presentation.setVisible(true);
        }
    }

    @NotNull
    protected static FilePath[] getAllContentRoots(@NotNull VcsContext context) {
        if (context == null) {
            AbstractCommonCheckinAction.$$$reportNull$$$0(16);
        }
        FilePath[] filePathArray = (FilePath[])Stream.of(ProjectLevelVcsManager.getInstance((Project)context.getProject()).getAllVersionedRoots()).map(VcsUtil::getFilePath).toArray(FilePath[]::new);
        if (filePathArray == null) {
            AbstractCommonCheckinAction.$$$reportNull$$$0(17);
        }
        return filePathArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 6: 
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/actions/AbstractCommonCheckinAction";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsContext";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/actions/AbstractCommonCheckinAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesIn";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareRootsForCommit";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllContentRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "performCheckIn";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getChangesIn";
                break;
            }
            case 6: 
            case 9: 
            case 17: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prepareRootsForCommit";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getMnemonicsFreeActionName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getExecutor";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getInitiallySelectedChangeList";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAllContentRoots";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$actionPerformed$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

