/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.annotate;

import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import org.jetbrains.annotations.NotNull;

public class AnnotationsPreloader {
    private static final Logger LOG = Logger.getInstance(AnnotationsPreloader.class);
    private final MergingUpdateQueue myUpdateQueue;
    private final Project myProject;

    public AnnotationsPreloader(Project project) {
        this.myProject = project;
        this.myUpdateQueue = new MergingUpdateQueue("Annotations preloader queue", 1000, true, null, (Disposable)project, null, false);
        project.getMessageBus().connect((Disposable)project).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!AnnotationsPreloader.isEnabled()) {
                    return;
                }
                VirtualFile file2 = event.getNewFile();
                if (file2 != null) {
                    AnnotationsPreloader.this.schedulePreloading(file2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/annotate/AnnotationsPreloader$1", "selectionChanged"));
            }
        });
    }

    private static boolean isEnabled() {
        return Registry.is((String)"vcs.annotations.preload") && !PowerSaveMode.isEnabled();
    }

    private void schedulePreloading(final @NotNull VirtualFile file2) {
        if (file2 == null) {
            AnnotationsPreloader.$$$reportNull$$$0(0);
        }
        if (this.myProject.isDisposed() || file2.getFileType().isBinary()) {
            return;
        }
        this.myUpdateQueue.queue(new Update(file2){

            public void run() {
                if (AnnotationsPreloader.this.myProject.isDisposed()) {
                    return;
                }
                try {
                    long start2 = 0L;
                    if (LOG.isDebugEnabled()) {
                        start2 = System.currentTimeMillis();
                    }
                    if (!FileEditorManager.getInstance((Project)AnnotationsPreloader.this.myProject).isFileOpen(file2)) {
                        return;
                    }
                    FileStatus fileStatus = ChangeListManager.getInstance((Project)AnnotationsPreloader.this.myProject).getStatus(file2);
                    if (fileStatus == FileStatus.UNKNOWN || fileStatus == FileStatus.ADDED || fileStatus == FileStatus.IGNORED) {
                        return;
                    }
                    AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)AnnotationsPreloader.this.myProject).getVcsFor(file2);
                    if (vcs == null) {
                        return;
                    }
                    AnnotationProvider annotationProvider = vcs.getAnnotationProvider();
                    if (annotationProvider == null || !annotationProvider.isCaching()) {
                        return;
                    }
                    annotationProvider.annotate(file2);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Preloaded VCS annotations for ", new Object[]{file2.getName(), " in ", String.valueOf(System.currentTimeMillis() - start2), "ms"});
                    }
                }
                catch (VcsException e) {
                    LOG.info((Throwable)e);
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/annotate/AnnotationsPreloader", "schedulePreloading"));
    }
}

