/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.TypeMerger;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.Version;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Ms05ImportManager
extends ImportManager {
    public Ms05ImportManager(Dbms dbms) {
        super(dbms, "TEXT", 1, true, true, false, true, new TypeMerger.IntegerMerger("INT"), new TypeMerger.DoubleMerger("FLOAT"));
    }

    @Override
    @NotNull
    public List<String> getFastModeOnQueries(@NotNull ImportInfo info) {
        if (info == null) {
            Ms05ImportManager.$$$reportNull$$$0(0);
        }
        ArrayList result2 = ContainerUtil.newArrayList(this.getQueries(info, true));
        this.alterIndices(info, result2, false);
        ArrayList arrayList = result2;
        if (arrayList == null) {
            Ms05ImportManager.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<String> getFastModeOffQueries(@NotNull ImportInfo info) {
        if (info == null) {
            Ms05ImportManager.$$$reportNull$$$0(2);
        }
        ArrayList result2 = ContainerUtil.newArrayList(this.getQueries(info, false));
        this.alterIndices(info, result2, true);
        ArrayList arrayList = result2;
        if (arrayList == null) {
            Ms05ImportManager.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private void alterIndices(@NotNull ImportInfo info, @NotNull List<String> result2, boolean enable) {
        if (info == null) {
            Ms05ImportManager.$$$reportNull$$$0(4);
        }
        if (result2 == null) {
            Ms05ImportManager.$$$reportNull$$$0(5);
        }
        DeTable table = info.getTable();
        if (table.indices.isEmpty()) {
            return;
        }
        for (int i2 = 1; i2 < table.indices.size(); ++i2) {
            result2.add(this.alterIndex(info, table.indices.get(i2), enable));
        }
    }

    private String alterIndex(@NotNull ImportInfo info, @NotNull DeIndex index2, boolean enable) {
        if (info == null) {
            Ms05ImportManager.$$$reportNull$$$0(6);
        }
        if (index2 == null) {
            Ms05ImportManager.$$$reportNull$$$0(7);
        }
        return this.alter(this.createBuilder(info.getContext()), "INDEX", index2).space().keyword("ON").space().qualifiedRef(info.getTable()).space().keyword(enable ? "REBUILD" : "DISABLE").getStatement();
    }

    @Override
    public boolean isSuitable(@Nullable Version productVersion) {
        return productVersion == null || !DataSourceUiUtil.isMsSql2008(productVersion);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mssql/Ms05ImportManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mssql/Ms05ImportManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFastModeOnQueries";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFastModeOffQueries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFastModeOnQueries";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFastModeOffQueries";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "alterIndices";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "alterIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

