/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.actionCable;

import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.awt.RelativePoint;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.actions.CreateNamedFileFix;
import org.jetbrains.plugins.ruby.rails.codeInsight.actionCable.ActionCableReference;
import org.jetbrains.plugins.ruby.rails.codeInsight.daemon.RailsLineMarkerNavigator;
import org.jetbrains.plugins.ruby.rails.model.RailsChannel;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public class ChannelNavigationHelper {
    public static final String CHANNEL_CLIENT_TEMPLATE = "App.%s = App.cable.subscriptions.create \"%sChannel\",\n  connected: ->\n    # Called when the subscription is ready for use on the server\n\n  disconnected: ->\n    # Called when the subscription has been terminated by the server\n\n  received: (data) ->\n    # Called when there's incoming data on the websocket for this channel";

    public static void switchToOrCreateChannelClient(@NotNull RClass rClass, @NotNull RelativePoint relativePoint) {
        if (rClass == null) {
            ChannelNavigationHelper.$$$reportNull$$$0(0);
        }
        if (relativePoint == null) {
            ChannelNavigationHelper.$$$reportNull$$$0(1);
        }
        RailsChannel channel = RailsChannel.fromClass((RClass)rClass);
        assert (channel != null);
        Project project = rClass.getProject();
        Collection references = ReferencesSearch.search((PsiElement)rClass, (SearchScope)GlobalSearchScope.projectScope((Project)project)).findAll();
        List<Navigatable> calls = ChannelNavigationHelper.getReferenceCalls(references);
        if (calls.size() == 0) {
            ChannelNavigationHelper.createChannelClient(rClass.getProject(), channel.getClientFileUrl());
            return;
        }
        if (calls.size() == 1) {
            calls.get(0).navigate(true);
            return;
        }
        RailsLineMarkerNavigator.openTargets((Navigatable[])calls.toArray(new Navigatable[0]), (String)RBundle.message((String)"rails.action.cable.choose.client.text"), (ListCellRenderer)((Object)new MyElementCellRenderer()), (RelativePoint)relativePoint);
    }

    public static void switchToChannelActionCall(@NotNull RMethod method, @NotNull RelativePoint relativePoint) {
        Project project;
        Collection references;
        List<Navigatable> calls;
        if (method == null) {
            ChannelNavigationHelper.$$$reportNull$$$0(2);
        }
        if (relativePoint == null) {
            ChannelNavigationHelper.$$$reportNull$$$0(3);
        }
        if ((calls = ChannelNavigationHelper.getReferenceCalls(references = ReferencesSearch.search((PsiElement)method, (SearchScope)GlobalSearchScope.projectScope((Project)(project = method.getProject()))).findAll())).size() == 0) {
            return;
        }
        if (calls.size() == 1) {
            calls.get(0).navigate(true);
            return;
        }
        RailsLineMarkerNavigator.openTargets((Navigatable[])calls.toArray(new Navigatable[0]), (String)RBundle.message((String)"rails.action.cable.choose.action.call.text"), (ListCellRenderer)((Object)new MyElementCellRenderer()), (RelativePoint)relativePoint);
    }

    @NotNull
    protected static List<Navigatable> getReferenceCalls(Collection<? extends PsiReference> references) {
        ArrayList<Navigatable> calls = new ArrayList<Navigatable>();
        for (PsiReference psiReference : references) {
            JSCallExpression call;
            if (!(psiReference instanceof ActionCableReference) || (call = (JSCallExpression)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), JSCallExpression.class)) == null) continue;
            calls.add((Navigatable)call);
        }
        ArrayList<Navigatable> arrayList = calls;
        if (arrayList == null) {
            ChannelNavigationHelper.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    public static ActionCableReference getActionCableReference(PsiElement element) {
        PsiReference[] references;
        if ((element = PsiTreeUtil.getParentOfType((PsiElement)element, JSLiteralExpression.class, (boolean)false)) == null) {
            return null;
        }
        for (PsiReference reference : references = element.getReferences()) {
            if (!(reference instanceof ActionCableReference)) continue;
            return (ActionCableReference)reference;
        }
        return null;
    }

    public static void switchToChannelOrAction(@NotNull PsiElement element) {
        ActionCableReference reference;
        if (element == null) {
            ChannelNavigationHelper.$$$reportNull$$$0(5);
        }
        if ((reference = ChannelNavigationHelper.getActionCableReference(element)) == null) {
            return;
        }
        PsiElement resolveResult = reference.resolve();
        if (resolveResult instanceof NavigatablePsiElement) {
            ((NavigatablePsiElement)resolveResult).navigate(true);
        }
    }

    static void createChannelClient(Project project, String fileUrl) {
        VirtualFile channelClientsFolder = ChannelNavigationHelper.findOrCreateFolderByUrl(VfsUtil.getParentDir((String)fileUrl));
        if (channelClientsFolder == null || !channelClientsFolder.isDirectory()) {
            return;
        }
        String name = VfsUtil.extractFileName((String)fileUrl);
        assert (name != null);
        String nameWithoutExtension = FileUtil.getNameWithoutExtension((String)name);
        String camelCasedName = NamingConventions.toCamelCase((String)nameWithoutExtension);
        CreateNamedFileFix.createFile((Project)project, (String)name, null, (String)"coffee", (VirtualFile)channelClientsFolder, null, (String)RBundle.message((String)"rails.action.cable.switch.to.client.create.prompt"), (String)RBundle.message((String)"rails.action.cable.switch.to.client.title"), (String)String.format(CHANNEL_CLIENT_TEMPLATE, nameWithoutExtension, camelCasedName));
    }

    @Nullable
    private static VirtualFile findOrCreateFolderByUrl(String folderUrl) {
        VirtualFileManager manager = VirtualFileManager.getInstance();
        VirtualFile viewsFolder = manager.findFileByUrl(folderUrl);
        if (viewsFolder != null) {
            return viewsFolder.isDirectory() ? viewsFolder : null;
        }
        return (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)((NullableComputable)() -> {
            try {
                return VfsUtil.createDirectoryIfMissing((String)VfsUtilCore.urlToPath((String)folderUrl));
            }
            catch (IOException e) {
                return null;
            }
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rClass";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePoint";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/codeInsight/actionCable/ChannelNavigationHelper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/actionCable/ChannelNavigationHelper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceCalls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "switchToOrCreateChannelClient";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "switchToChannelActionCall";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "switchToChannelOrAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyElementCellRenderer
    extends DefaultPsiElementCellRenderer {
        private MyElementCellRenderer() {
        }

        public String getElementText(PsiElement element) {
            String[] lines = element.getText().split("\n", 2);
            return lines[0];
        }

        public String getContainerText(PsiElement element, String name) {
            PsiFile psiFile = element.getContainingFile();
            Document document = PsiDocumentManager.getInstance((Project)element.getProject()).getCachedDocument(psiFile);
            assert (document != null);
            int lineNumber = document.getLineNumber(element.getTextOffset()) + 1;
            return psiFile.getName() + ":" + lineNumber;
        }
    }
}

