/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.cucumber.ruby.steps;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.AbstractStepDefinitionCreator;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.ruby.cucumber.inspections.StepDefinitionsSnippetsFactory;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RRegexpLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RBlockArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RDoBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public class RubyStepDefinitionCreator
extends AbstractStepDefinitionCreator {
    private static final String RUBY_FILE_EXTENSION = '.' + RubyFileType.RUBY.getDefaultExtension();

    @NotNull
    public PsiFile createStepDefinitionContainer(@NotNull PsiDirectory dir, @NotNull String name) {
        if (dir == null) {
            RubyStepDefinitionCreator.$$$reportNull$$$0(0);
        }
        if (name == null) {
            RubyStepDefinitionCreator.$$$reportNull$$$0(1);
        }
        PsiFile psiFile = (PsiFile)WriteAction.compute(() -> {
            if (dir == null) {
                RubyStepDefinitionCreator.$$$reportNull$$$0(9);
            }
            if (name == null) {
                RubyStepDefinitionCreator.$$$reportNull$$$0(10);
            }
            return dir.createFile(name + RUBY_FILE_EXTENSION);
        });
        if (psiFile == null) {
            RubyStepDefinitionCreator.$$$reportNull$$$0(2);
        }
        return psiFile;
    }

    public boolean createStepDefinition(@NotNull GherkinStep step, @NotNull PsiFile file) {
        if (step == null) {
            RubyStepDefinitionCreator.$$$reportNull$$$0(3);
        }
        if (file == null) {
            RubyStepDefinitionCreator.$$$reportNull$$$0(4);
        }
        if (!(file instanceof RFile)) {
            return false;
        }
        Project project = file.getProject();
        this.closeActiveTemplateBuilders(file);
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        String text = StepDefinitionsSnippetsFactory.getInstance().makeSnippet(step);
        RDoBlockCall element = (RDoBlockCall)RubyElementFactory.createElementFromText((PsiElement)file, (String)text);
        file.add(RubyElementFactory.createNewLine((PsiElement)file));
        file.add(RubyElementFactory.createNewLine((PsiElement)file));
        RDoBlockCall addedElement = (RDoBlockCall)file.add((PsiElement)element);
        addedElement = (RDoBlockCall)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)addedElement);
        RCall call = (RCall)addedElement.getCall();
        RRegexpLiteral regexpLiteral = (RRegexpLiteral)call.getArguments().get(0);
        int regexpLiteralLength = regexpLiteral.getTextLength();
        List statements = addedElement.getBlock().getCompoundStatement().getStatements();
        TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)addedElement);
        builder.replaceElement((PsiElement)regexpLiteral, new TextRange(2, regexpLiteralLength - 2), regexpLiteral.getText().substring(2, regexpLiteralLength - 2));
        RBlockArgumentList blockVars = addedElement.getBlock().getBlockArguments();
        if (blockVars != null) {
            for (RArgument var : blockVars.getArguments()) {
                builder.replaceElement((PsiElement)var, var.getName());
            }
        }
        if (statements.size() > 0) {
            builder.replaceElement((PsiElement)statements.get(0), "pending");
        }
        assert (editor != null);
        builder.run(editor, false);
        return true;
    }

    public boolean validateNewStepDefinitionFileName(@NotNull Project project, @NotNull String fileName) {
        if (project == null) {
            RubyStepDefinitionCreator.$$$reportNull$$$0(5);
        }
        if (fileName == null) {
            RubyStepDefinitionCreator.$$$reportNull$$$0(6);
        }
        return true;
    }

    @NotNull
    public String getDefaultStepFileName(@NotNull GherkinStep step) {
        if (step == null) {
            RubyStepDefinitionCreator.$$$reportNull$$$0(7);
        }
        if ("my_steps" == null) {
            RubyStepDefinitionCreator.$$$reportNull$$$0(8);
        }
        return "my_steps";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/cucumber/ruby/steps/RubyStepDefinitionCreator";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/cucumber/ruby/steps/RubyStepDefinitionCreator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createStepDefinitionContainer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultStepFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createStepDefinitionContainer";
                break;
            }
            case 2: 
            case 8: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createStepDefinition";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validateNewStepDefinitionFileName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultStepFileName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createStepDefinitionContainer$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

