/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.console;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.remote.RemoteConnectionType;
import com.intellij.remote.RemoteConnector;
import com.intellij.remote.RemoteCredentials;
import com.intellij.util.Consumer;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.SshConnectionProvider;
import com.jetbrains.plugins.remotesdk.console.RemoteConnectionSettingsForm;
import com.jetbrains.plugins.remotesdk.console.RemoteConnectionUtil;
import com.jetbrains.plugins.remotesdk.console.RemoteCredentialsDialogRunner;
import com.jetbrains.plugins.remotesdk.console.WebServerConnector;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.event.KeyEvent;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteDataProducer {
    public static final String NO_HOST_TO_CONNECT = "No Host To Connect";
    private Project myProject;
    private Module myModule;
    private AnActionEvent myActionEvent;
    private boolean myShowProjectLevelServers = false;
    private Component myComponentOwner;

    public RemoteDataProducer withComponentOwner(@NotNull Component componentOwner) {
        if (componentOwner == null) {
            RemoteDataProducer.$$$reportNull$$$0(0);
        }
        this.myComponentOwner = componentOwner;
        return this;
    }

    public RemoteDataProducer withProject(@NotNull Project project) {
        if (project == null) {
            RemoteDataProducer.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        return this;
    }

    public RemoteDataProducer withModule(@Nullable Module module) {
        this.myModule = module;
        return this;
    }

    public RemoteDataProducer withShowProjectLevelServers(boolean show) {
        this.myShowProjectLevelServers = show;
        return this;
    }

    public RemoteDataProducer withActionEvent(@NotNull AnActionEvent event) {
        if (event == null) {
            RemoteDataProducer.$$$reportNull$$$0(2);
        }
        this.myActionEvent = event;
        this.myProject = (Project)event.getData(CommonDataKeys.PROJECT);
        this.myModule = (Module)event.getData(LangDataKeys.MODULE);
        return this;
    }

    private Project getProjectForServersSearch() {
        return this.myShowProjectLevelServers ? this.myProject : null;
    }

    @Nullable
    public RemoteConnector getRemoteConnector(@Nullable RemoteConnectionType type, @Nullable String id) {
        WebServerConfig config;
        if (type == RemoteConnectionType.DEPLOYMENT_SERVER && (config = RemoteDataProducer.findDeploymentServerById(id, this.getProjectForServersSearch())) != null) {
            return new WebServerConnector(Deployable.create((WebServerConfig)config));
        }
        if (type != null) {
            for (SshConnectionProvider provider : (SshConnectionProvider[])SshConnectionProvider.EP_NAME.getExtensions()) {
                RemoteConnector connector = provider.getRemoteConnector(type, id, this.myProject, this.myModule);
                if (connector == null) continue;
                return connector;
            }
        }
        return null;
    }

    @Nullable
    private static WebServerConfig findDeploymentServerById(@Nullable String id, @Nullable Project project) {
        if (id != null) {
            for (WebServerConfig config : RemoteSdkUtil.getSftpServerList(project)) {
                if (!id.equals(config.getId())) continue;
                return config;
            }
        }
        return null;
    }

    public void produceRemoteData(@Nullable RemoteConnectionType type, @Nullable String id, @NotNull Consumer<RemoteCredentials> consumer) {
        RemoteConnector connector;
        if (consumer == null) {
            RemoteDataProducer.$$$reportNull$$$0(3);
        }
        if ((connector = this.getRemoteConnector(type, id)) != null) {
            connector.produceRemoteCredentials(credentials -> {
                if (consumer == null) {
                    RemoteDataProducer.$$$reportNull$$$0(4);
                }
                if (credentials != null) {
                    consumer.consume(credentials);
                }
            });
        } else {
            this.selectConnectionInPopup(consumer);
        }
    }

    public void selectConnectionInPopup(final Consumer<RemoteCredentials> consumer) {
        List<RemoteConnector> connectors = RemoteConnectionUtil.getUniqueRemoteConnectors(this.getProjectForServersSearch());
        if (connectors.isEmpty()) {
            StringBuilder message = new StringBuilder();
            message.append("Please specify SFTP server in Deployment settings");
            for (SshConnectionProvider provider : (SshConnectionProvider[])SshConnectionProvider.EP_NAME.getExtensions()) {
                String description = provider.getSettingCreationDescription();
                if (description == null) continue;
                message.append(" or ").append(description);
            }
            Messages.showWarningDialog((Project)this.myProject, (String)message.toString(), (String)NO_HOST_TO_CONNECT);
        } else {
            Collections.sort(connectors, (c1, c2) -> c1.getType() == RemoteConnectionType.NONE ? -1 : (c2.getType() == RemoteConnectionType.NONE ? 1 : c1.getName().compareTo(c2.getName())));
            BaseListPopupStep<RemoteConnector> sdkHomesStep = new BaseListPopupStep<RemoteConnector>("Select host to connect", connectors){

                @NotNull
                public String getTextFor(RemoteConnector value) {
                    if (value.getType() == RemoteConnectionType.NONE) {
                        if ("Edit credentials..." == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return "Edit credentials...";
                    }
                    String string = value.getName();
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                public PopupStep onChosen(RemoteConnector selected, boolean finalChoice) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (selected == RemoteConnectionSettingsForm.NONE_CONNECTOR) {
                            new RemoteCredentialsDialogRunner().run(RemoteDataProducer.this.myProject, (Consumer<RemoteCredentials>)consumer);
                        } else {
                            selected.produceRemoteCredentials(consumer);
                        }
                    });
                    return FINAL_CHOICE;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/console/RemoteDataProducer$1", "getTextFor"));
                }
            };
            ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)sdkHomesStep);
            if (this.myComponentOwner != null) {
                popup.showInCenterOf(this.myComponentOwner);
            } else if (this.myProject != null) {
                if (this.myActionEvent != null && this.myActionEvent.getInputEvent() instanceof KeyEvent) {
                    popup.showInFocusCenter();
                } else {
                    popup.showInScreenCoordinates((Component)WindowManager.getInstance().getIdeFrame(this.myProject).getComponent(), MouseInfo.getPointerInfo().getLocation());
                }
            } else {
                popup.showInFocusCenter();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentOwner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/remotesdk/console/RemoteDataProducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "withComponentOwner";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "withProject";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "withActionEvent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "produceRemoteData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$produceRemoteData$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

