/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.jetbrains.performancePlugin.MessagesBundle;
import com.jetbrains.performancePlugin.commands.Waiter;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class CompletionCommand
extends AbstractCommand {
    public static final String PREFIX = "%doComplete";
    private final Project myProject;

    public CompletionCommand(@NotNull String text, int line, @NotNull Project project) {
        if (text == null) {
            CompletionCommand.$$$reportNull$$$0(0);
        }
        if (project == null) {
            CompletionCommand.$$$reportNull$$$0(1);
        }
        super(text, line);
        this.myProject = project;
    }

    protected Promise<Object> _execute(PlaybackContext context) {
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper(this.myProject);
        DumbService.getInstance((Project)this.myProject).runWhenSmart(() -> {
            Editor editor = FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor();
            new CodeCompletionHandlerBase(CompletionType.BASIC, false, false, true).invokeCompletion(this.myProject, editor);
            if (CompletionServiceImpl.isPhase((Class[])new Class[]{CompletionPhase.NoCompletion.getClass()})) {
                actionCallback.reject("No completion items");
            }
        });
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                boolean completionAppeared = Waiter.checkCondition(() -> CompletionServiceImpl.isPhase((Class[])new Class[]{CompletionPhase.ItemsCalculated.class})).await(5L, TimeUnit.MINUTES);
                if (completionAppeared) {
                    context.message(MessagesBundle.message("command.completion.finish", new Object[0]), this.getLine());
                    actionCallback.setDone();
                } else {
                    actionCallback.reject("Completion didn't reach ItemsCalculatedPhase");
                }
            }
            catch (Throwable e) {
                actionCallback.setRejected();
            }
        });
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "text";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/performancePlugin/commands/CompletionCommand";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

