/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.performancePlugin.MessagesBundle;
import com.jetbrains.performancePlugin.commands.Waiter;
import com.jetbrains.performancePlugin.profilers.AsyncProfilerHandler;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class StartAsyncProfileCommand
extends AbstractCommand {
    public static final String PREFIX = "%startAsyncProfile";
    private final Project myProject;

    public StartAsyncProfileCommand(String text, int line, Project project) {
        super(text, line);
        this.myProject = project;
    }

    public void startProfiling(String activityName, @NotNull List<String> commandParameters) throws RuntimeException {
        if (commandParameters == null) {
            StartAsyncProfileCommand.$$$reportNull$$$0(0);
        }
        AsyncProfilerHandler.getInstance(this.myProject).startProfiling(activityName, commandParameters);
    }

    protected Promise<Object> _execute(PlaybackContext context) {
        ActionCallbackProfilerStopper myActionCallback = new ActionCallbackProfilerStopper(this.myProject);
        String[] executedCommand = this.getText().substring(PREFIX.length()).trim().split("\\s+", 2);
        String myActivityName = executedCommand[0];
        if (StringUtil.isEmpty((String)myActivityName)) {
            myActionCallback.reject(MessagesBundle.message("async.command.start.error", new Object[0]));
        } else {
            try {
                ArrayList<String> parameters = executedCommand.length > 1 ? Arrays.asList(executedCommand[1].trim().split(",")) : new ArrayList<String>();
                this.startProfiling(myActivityName, parameters);
                Waiter.checkCondition(() -> AsyncProfilerHandler.getInstance(this.myProject).isProfilingStarted()).await();
                myActionCallback.setDone();
            }
            catch (Exception e) {
                myActionCallback.setRejected();
            }
        }
        return Promises.toPromise((ActionCallback)myActionCallback);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandParameters", "com/jetbrains/performancePlugin/commands/StartAsyncProfileCommand", "startProfiling"));
    }
}

