/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerRepoTag
implements Cloneable {
    public static final String DEFAULT_TAG = "latest";
    private static final String LEGACY_DOCKER_HUB_ADDRESS = "registry.hub.docker.com";
    private static final String LEGACY_DEFAULT_DOMAIN = "index.docker.io";
    private static final String DEFAULT_DOMAIN = "docker.io";
    private static final String OFFICIAL_REPO_NAME = "library";
    private static final String REPOSITORY_PARTS_SEPARATOR = "/";
    private static final String TAG_SEPARATOR = ":";
    private String myDomain;
    private String myNamespace;
    private String myRepository;
    private String myTag;

    public static DockerRepoTag fromString(@NotNull String repoTag) {
        String[] parts;
        if (repoTag == null) {
            DockerRepoTag.$$$reportNull$$$0(0);
        }
        if ((parts = repoTag.split("/+")).length == 0) {
            throw new IllegalStateException();
        }
        DockerRepoTag result = new DockerRepoTag();
        result.setTag(DockerRepoTag.substringAfterLast(parts[parts.length - 1], TAG_SEPARATOR));
        parts[parts.length - 1] = DockerRepoTag.substringBeforeLast(parts[parts.length - 1], TAG_SEPARATOR);
        switch (parts.length) {
            case 0: {
                throw new InternalError();
            }
            case 1: {
                result.setRepository(parts[parts.length - 1]);
                break;
            }
            default: {
                int namespaceIdx;
                if (DockerRepoTag.isDomain(parts[0])) {
                    result.setDomain(parts[0]);
                    namespaceIdx = 1;
                } else {
                    result.setDomain(null);
                    namespaceIdx = 0;
                }
                result.setNamespace(parts[namespaceIdx]);
                result.setRepository(Arrays.stream(parts).skip(namespaceIdx + 1).collect(Collectors.joining(REPOSITORY_PARTS_SEPARATOR)));
            }
        }
        return result;
    }

    public void setRepository(@NotNull String repository) {
        if (repository == null) {
            DockerRepoTag.$$$reportNull$$$0(1);
        }
        this.myRepository = repository;
    }

    public DockerRepoTag clone() {
        try {
            return (DockerRepoTag)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    public String getDomain() {
        return this.myDomain;
    }

    @Nullable
    public String getNamespace() {
        return this.myNamespace;
    }

    public void setNamespace(String namespace) {
        this.myNamespace = namespace;
    }

    @NotNull
    public String getSimpleRepositoryName() {
        String string = this.myRepository;
        if (string == null) {
            DockerRepoTag.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getTagNotNull() {
        String string = Optional.ofNullable(this.myTag).orElse(DEFAULT_TAG);
        if (string == null) {
            DockerRepoTag.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean hasCustomTag() {
        return this.myTag != null;
    }

    public void setTag(String tag) {
        this.myTag = DockerRepoTag.nullifyDefaultTag(tag);
    }

    public void setDomain(String domain) {
        this.myDomain = DockerRepoTag.nullifyDefaultDomain(domain);
    }

    @NotNull
    public String getQualifiedRepository() {
        LinkedList<String> pieces = new LinkedList<String>();
        if (!DockerRepoTag.isEmptyOrSpaces(this.myDomain)) {
            pieces.add(this.myDomain);
        }
        if (!DockerRepoTag.isEmptyOrSpaces(this.myNamespace)) {
            pieces.add(this.myNamespace);
        }
        if (!DockerRepoTag.isEmptyOrSpaces(this.myRepository)) {
            pieces.add(this.myRepository);
        }
        String string = String.join((CharSequence)REPOSITORY_PARTS_SEPARATOR, pieces);
        if (string == null) {
            DockerRepoTag.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getFullyQualifiedReference() {
        String repository = this.getQualifiedRepository();
        String string = this.myTag == null ? repository : repository + TAG_SEPARATOR + this.myTag;
        if (string == null) {
            DockerRepoTag.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean matchesRepoTag(@NotNull String repoTagFqn) {
        if (repoTagFqn == null) {
            DockerRepoTag.$$$reportNull$$$0(6);
        }
        return repoTagFqn.equals(this.getFullyQualifiedReference()) || this.myTag == null && repoTagFqn.equals(this.getFullyQualifiedReference() + TAG_SEPARATOR + DEFAULT_TAG);
    }

    public boolean matchesOneOfRepoTags(@Nullable String[] repoTags) {
        return repoTags != null && repoTags.length > 0 && Arrays.stream(repoTags).filter(Objects::nonNull).anyMatch(this::matchesRepoTag);
    }

    public boolean isOwnedBy(@Nullable String registryAddress, @Nullable String registryUsername) {
        return DockerRepoTag.safeEquals(DockerRepoTag.nullifyDefaultDomain(this.myDomain), DockerRepoTag.nullifyDefaultDomain(registryAddress)) && DockerRepoTag.safeEquals(DockerRepoTag.nullifyDefaultNamespace(this.myDomain, this.myNamespace), DockerRepoTag.nullifyDefaultNamespace(registryAddress, registryUsername));
    }

    public String toString() {
        return "DockerRepoTag:" + this.getFullyQualifiedReference();
    }

    private static String nullifyDefaultDomain(@Nullable String domain) {
        return DockerRepoTag.isDefaultDomain(domain) ? null : domain;
    }

    private static String nullifyDefaultNamespace(@Nullable String domain, @Nullable String namespace) {
        return DockerRepoTag.isDefaultDomain(domain) && OFFICIAL_REPO_NAME.equals(namespace) ? null : namespace;
    }

    private static String nullifyDefaultTag(@Nullable String tag) {
        return DEFAULT_TAG.equals(tag) ? null : tag;
    }

    private static boolean isDefaultDomain(@Nullable String domain) {
        return domain == null || DEFAULT_DOMAIN.equals(domain) || LEGACY_DEFAULT_DOMAIN.equals(domain) || LEGACY_DOCKER_HUB_ADDRESS.equals(domain);
    }

    private static boolean isEmptyOrSpaces(@Nullable String text) {
        return text == null || text.length() == 0 || text.trim().length() == 0;
    }

    private static boolean safeEquals(@Nullable String textA, @Nullable String textB) {
        return textA == null ? textB == null : textA.equals(textB);
    }

    private static String substringBeforeLast(@NotNull String text, @NotNull String substring) {
        int idx;
        if (text == null) {
            DockerRepoTag.$$$reportNull$$$0(7);
        }
        if (substring == null) {
            DockerRepoTag.$$$reportNull$$$0(8);
        }
        return (idx = text.lastIndexOf(substring)) < 0 ? text : text.substring(0, idx);
    }

    private static String substringAfterLast(@NotNull String text, @NotNull String substring) {
        int idx;
        if (text == null) {
            DockerRepoTag.$$$reportNull$$$0(9);
        }
        if (substring == null) {
            DockerRepoTag.$$$reportNull$$$0(10);
        }
        return (idx = text.lastIndexOf(substring)) < 0 ? null : text.substring(idx + substring.length());
    }

    private static boolean isDomain(@NotNull String part) {
        if (part == null) {
            DockerRepoTag.$$$reportNull$$$0(11);
        }
        return "localhost".equals(part) || part.contains(".") || part.contains(TAG_SEPARATOR);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repoTag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/agent/DockerRepoTag";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repoTagFqn";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substring";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "part";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/agent/DockerRepoTag";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleRepositoryName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagNotNull";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedRepository";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullyQualifiedReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setRepository";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "matchesRepoTag";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "substringBeforeLast";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "substringAfterLast";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isDomain";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

