/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.xpath;

import gnu.xml.xpath.Expr;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;

final class EqualityExpr
extends Expr {
    final Expr lhs;
    final Expr rhs;
    final boolean invert;

    public final Object evaluate(Node context, int pos, int len) {
        boolean val = this.evaluateImpl(context, pos, len);
        if (this.invert) {
            return val ? Boolean.FALSE : Boolean.TRUE;
        }
        return val ? Boolean.TRUE : Boolean.FALSE;
    }

    private final boolean evaluateImpl(Node context, int pos, int len) {
        Object left = this.lhs.evaluate(context, pos, len);
        Object right = this.rhs.evaluate(context, pos, len);
        boolean flns = left instanceof Collection;
        boolean frns = right instanceof Collection;
        if (flns && frns) {
            Collection lns = (Collection)left;
            Collection rns = (Collection)right;
            if (lns.isEmpty()) {
                return false;
            }
            boolean all = true;
            Iterator i = lns.iterator();
            while (i.hasNext()) {
                Node ltest = (Node)i.next();
                Iterator j = rns.iterator();
                while (j.hasNext()) {
                    Node rtest = (Node)j.next();
                    if (ltest == rtest || ltest.equals(rtest)) {
                        if (this.invert) continue;
                        return true;
                    }
                    if (EqualityExpr.stringValue(ltest).equals(EqualityExpr.stringValue(rtest))) {
                        if (this.invert) continue;
                        return true;
                    }
                    all = false;
                }
            }
            return all;
        }
        boolean fln = left instanceof Double;
        boolean frn = right instanceof Double;
        if (flns && frn || frns && fln) {
            Collection ns = flns ? (Collection)left : (Collection)right;
            double n = fln ? ((Double)left).doubleValue() : ((Double)right).doubleValue();
            boolean all = true;
            Iterator i = ns.iterator();
            while (i.hasNext()) {
                Node test = (Node)i.next();
                double nn = EqualityExpr._number(context, EqualityExpr.stringValue(test));
                if (nn == n) {
                    if (this.invert) continue;
                    return true;
                }
                all = false;
            }
            boolean bl = false;
            if (this.invert) {
                bl = all;
            }
            return bl;
        }
        boolean fls = left instanceof String;
        boolean frs = right instanceof String;
        if (flns && frs || frns && fls) {
            Collection ns = flns ? (Collection)left : (Collection)right;
            String s = fls ? (String)left : (String)right;
            boolean all = true;
            Iterator i = ns.iterator();
            while (i.hasNext()) {
                Node test = (Node)i.next();
                if (EqualityExpr.stringValue(test).equals(s)) {
                    if (this.invert) continue;
                    return true;
                }
                all = false;
            }
            boolean bl = false;
            if (this.invert) {
                bl = all;
            }
            return bl;
        }
        boolean flb = left instanceof Boolean;
        boolean frb = right instanceof Boolean;
        if (flns && frb || frns && flb) {
            Collection ns = flns ? (Collection)left : (Collection)right;
            boolean b = flb ? ((Boolean)left).booleanValue() : ((Boolean)right).booleanValue();
            return EqualityExpr._boolean(context, ns) ^ b ^ true;
        }
        if (flb || frb) {
            boolean lb = flb ? (Boolean)left : EqualityExpr._boolean(context, left);
            boolean rb = frb ? (Boolean)right : EqualityExpr._boolean(context, right);
            return lb ^ rb ^ true;
        }
        if (fln || frn) {
            double ln = fln ? (Double)left : EqualityExpr._number(context, left);
            double rn = frn ? (Double)right : EqualityExpr._number(context, right);
            boolean bl = false;
            if (ln == rn) {
                bl = true;
            }
            return bl;
        }
        String ls = fls ? (String)left : EqualityExpr._string(context, left);
        String rs = frs ? (String)right : EqualityExpr._string(context, right);
        return ls.equals(rs);
    }

    public final Expr clone(Object context) {
        return new EqualityExpr(this.lhs.clone(context), this.rhs.clone(context), this.invert);
    }

    public final boolean references(QName var) {
        boolean bl = false;
        if (this.lhs.references(var) || this.rhs.references(var)) {
            bl = true;
        }
        return bl;
    }

    public final String toString() {
        if (this.invert) {
            return this.lhs + " != " + this.rhs;
        }
        return this.lhs + " = " + this.rhs;
    }

    EqualityExpr(Expr lhs, Expr rhs, boolean invert) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.invert = invert;
    }
}

