//
// $Id: Streamable.h,v 1.7 2007/03/20 04:09:52 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#if !defined(STREAMABLE_OL_GUARD)
#define STREAMABLE_OL_GUARD

#include <objc/objc.h>

@class OLObjectInStream;
@class OLObjectOutStream;

/**
 * @protocol OLStreamable Streamable.h ObjectiveLib/Streamable.h
 *
 * A protocol for writing to streams. For an object to be written to or
 * read from a stream it must implement either the OLStreamable protocol
 * or the NSCoding protocol. When an object is read from a stream the
 * message #initWithObjectInStream: is sent, which reads each of the object's
 * instance variables and initializes the object. For writing,
 * the message #writeSelfToStream: is sent, which writes the instance
 * variables.
 *
 * @ingroup Streams
 */
@protocol OLStreamable

/**
 * Initialize the object. Each instance variable is read from @a stream and all
 * other initialization is performed.
 *
 * @param stream the stream from which to read
 * @return a reference to this object
 */
- (id) initWithObjectInStream: (OLObjectInStream*)stream;

/**
 * Write the object to a stream. All instance variables are written to @a stream.
 *
 * @param stream the stream to which to write.
 */
- (void) writeSelfToStream: (OLObjectOutStream*)stream;

@end

#endif
