/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.io;

import java.io.IOException;
import java.net.Socket;
import org.apache.catalina.cluster.io.ListenCallback;
import org.apache.catalina.cluster.io.XByteBuffer;
import org.apache.catalina.cluster.tcp.ClusterData;

public class SocketObjectReader {
    private Socket socket;
    private ListenCallback callback;
    private XByteBuffer buffer;

    public SocketObjectReader(Socket socket, ListenCallback callback) {
        this.socket = socket;
        this.callback = callback;
        this.buffer = new XByteBuffer();
    }

    public int append(byte[] data, int off, int len) throws IOException {
        if (len > 0) {
            this.buffer.append(data, off, len);
        }
        boolean pkgExists = this.buffer.doesPackageExist();
        int pkgCnt = 0;
        while (pkgExists) {
            ClusterData cdata = this.buffer.extractPackage(true);
            if (this.callback.isSendAck()) {
                this.callback.sendAck();
            }
            this.callback.messageDataReceived(cdata);
            ++pkgCnt;
            pkgExists = this.buffer.doesPackageExist();
        }
        return pkgCnt;
    }

    public int execute() throws IOException {
        return this.append(null, 0, 0);
    }

    public int write(byte[] data) throws IOException {
        this.socket.getOutputStream().write(data);
        return 0;
    }
}

