tinyMCE.init({
	// General options
	mode : "textareas",
	theme : "advanced",
	skin : "soycms",
	language : soycms.language,

	//textarea's selector
	editor_selector : "mceEditor",

	plugins : "save,pagebreak,table,advhr,advimage,advlink,inlinepopups,insertdatetime,media,searchreplace,contextmenu,paste,directionality,fullscreen,noneditable,visualchars,nonbreaking,xhtmlxtras,innerlink,insertimage,soycms_emoji",

	// Theme options
	theme_advanced_buttons1 : "save,|,cut,copy,paste,pastetext,pasteword,|,search,replace,|,bold,italic,underline,strikethrough,|,sub,sup,|,forecolor,backcolor,|,justifyleft,justifycenter,justifyright,|,formatselect,fontselect,fontsizeselect",
	theme_advanced_buttons2 : "bullist,numlist,|,outdent,indent,blockquote,|,undo,redo,|,cleanup,removeformat,code,styleprops,attribs,|,fullscreen,preview,|,insertdate,inserttime,|,innerlink,insertimage,|,soycms_emoji,charmap,|,tablecontrols",
	theme_advanced_buttons3 : "",
	theme_advanced_buttons4 : "",
	theme_advanced_toolbar_location : "top",
	theme_advanced_toolbar_align : "left",
	theme_advanced_statusbar_location : "bottom",
	theme_advanced_resizing : true,

	//カスタム
	cleanup : true,
	verify_html : false,
	convert_urls : false,
	relative_urls : false,
	button_tile_map : true,
	entity_encoding : "named",
	oninit : "init_soycms_tinymce",
	urlconverter_callback : common_convert_urls
});
	


function applyTemplate(){
	var template = document.getElementById("list_templates").value;
	
	if(template.length == 0){
		return;
	}
	
	var post = "id=" + template;
	
	var callback = function(oResponse) {
			var result = eval('('+oResponse.responseText+')');
			
			$("style").value = result['templates']['style'];
						
			tinyMCE.get('entry_content').getWin().document.body.innerHTML = result['templates']['content'];
			tinyMCE.get('entry_more').getWin().document.body.innerHTML = result['templates']['more'];

			tinyMCE.get('entry_content').dom.loadCSS(result['style_path']);
			tinyMCE.get('entry_more').dom.loadCSS(result['style_path']);
	};
	
	var myAjax = new Ajax.Request(
		templateAjaxURL, 
		{
			method: 'post', 
			parameters: post, 
			onComplete: callback
		});
}

function init_soycms_tinymce(){
	
	$('entry_content_wrapper').style.position = "relative";
	$('entry_content_wrapper').style.visibility = "visible";

	$('entry_more_wrapper').style.position = "absolute";
	$('entry_more_wrapper').style.visibility = "hidden";
	$('entry_more_wrapper').style.display = "none";
	
	Event.observe($('entry_content_switch'),"click",function(){
		
		$('entry_content_switch').setAttribute("class","content_tab_active");
		$('entry_content_switch').className = "content_tab_active";
		
		$('entry_more_switch').setAttribute("class","content_tab_inactive");
		$('entry_more_switch').className = "content_tab_inactive";
		
		$('entry_content_wrapper').style.position = "relative";
		$('entry_content_wrapper').style.visibility = "visible";
		$('entry_content_wrapper').style.display = "";
		
		$('entry_more_wrapper').style.position = "absolute";
		$('entry_more_wrapper').style.visibility = "hidden";
		$('entry_more_wrapper').style.display = "none";
		
	});


	Event.observe($('entry_more_switch'),"click",function(){
		
		$('entry_more_switch').setAttribute("class","content_tab_active");
		$('entry_more_switch').className = "content_tab_active";
		
		$('entry_content_switch').setAttribute("class","content_tab_inactive");
		$('entry_content_switch').className = "content_tab_inactive";
	
		$('entry_content_wrapper').style.position = "absolute";
		$('entry_content_wrapper').style.visibility = "hidden";
		$('entry_content_wrapper').style.display = "none";
		
		$('entry_more_wrapper').style.position = "relative";
		$('entry_more_wrapper').style.visibility = "visible";
		$('entry_more_wrapper').style.display = "";
			
	});
	
	//スタイルの適用
	tinyMCE.get('entry_content').dom.loadCSS(entry_css_path);
	tinyMCE.get('entry_more').dom.loadCSS(entry_css_path);
	
	if(tinyMCE.get('entry_content').getWin().document.body.innerHTML.length < 1){
		tinyMCE.get('entry_content').getWin().document.body.innerHTML = "<p></p>";
	}
	
	if(tinyMCE.get('entry_more').getWin().document.body.innerHTML.length < 1){
		tinyMCE.get('entry_more').getWin().document.body.innerHTML = "<p></p>";
	}
	
	tinyMCE.get('entry_content').focus();
	
	//toggle label
	$$('#labels input[type="checkbox"]').each(function(ele){
		toggle_labelmemo(ele.value,ele.checked);
	});
	
}

function common_convert_urls(url, node, on_save) {
	
	if(url[0] == "/")return url;
	
	if(url[0] == "."){
		var img = new Image;
		img.src = url;
		url = img.src;
			
		return url;
	}
	
	return url;
}