/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.undo;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class UndoUtil {
    private UndoUtil() {
    }

    public static void markPsiFileForUndo(@NotNull PsiFile file) {
        Project project;
        Document document;
        if (file == null) {
            UndoUtil.$$$reportNull$$$0(0);
        }
        if ((document = PsiDocumentManager.getInstance(project = file.getProject()).getDocument(file)) == null) {
            return;
        }
        CommandProcessor.getInstance().addAffectedDocuments(project, document);
    }

    public static void disableUndoFor(@NotNull Document document) {
        if (document == null) {
            UndoUtil.$$$reportNull$$$0(1);
        }
        document.putUserData(UndoConstants.DONT_RECORD_UNDO, Boolean.TRUE);
    }

    public static boolean isUndoDisabledFor(@NotNull Document document) {
        if (document == null) {
            UndoUtil.$$$reportNull$$$0(2);
        }
        return Boolean.TRUE.equals(document.getUserData(UndoConstants.DONT_RECORD_UNDO));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/command/undo/UndoUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "markPsiFileForUndo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "disableUndoFor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isUndoDisabledFor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

