/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.cli;

import com.intellij.lang.javascript.boilerplate.NpmPackageProjectGenerator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.cli.VueCliRunningGeneratorController;
import org.jetbrains.vuejs.cli.VueRunningGeneratorListener;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a(\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a \u0010\n\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u000b2\u0006\u0010\r\u001a\u00020\u0003H\u0002\u00a8\u0006\u000e"}, d2={"createVueRunningGeneratorController", "Lorg/jetbrains/vuejs/cli/VueCliRunningGeneratorController;", "generationLocation", "", "settings", "Lcom/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator$Settings;", "listener", "Lorg/jetbrains/vuejs/cli/VueRunningGeneratorListener;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "validateProjectLocation", "Lkotlin/Pair;", "Ljava/nio/file/Path;", "projectLocation", "intellij.vuejs"})
public final class VueCliRunningGeneratorControllerKt {
    @Nullable
    public static final VueCliRunningGeneratorController createVueRunningGeneratorController(@NotNull String generationLocation, @NotNull NpmPackageProjectGenerator.Settings settings, @NotNull VueRunningGeneratorListener listener2, @NotNull Disposable parentDisposable) {
        VueCliRunningGeneratorController vueCliRunningGeneratorController;
        Intrinsics.checkParameterIsNotNull((Object)generationLocation, (String)"generationLocation");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        Intrinsics.checkParameterIsNotNull((Object)parentDisposable, (String)"parentDisposable");
        Pair<Path, String> location = VueCliRunningGeneratorControllerKt.validateProjectLocation(generationLocation);
        if (location.getFirst() != null) {
            Object object = location.getFirst();
            if (object == null) {
                Intrinsics.throwNpe();
            }
            vueCliRunningGeneratorController = new VueCliRunningGeneratorController((Path)object, settings, listener2, parentDisposable);
        } else {
            listener2.disableNext((String)location.getSecond());
            vueCliRunningGeneratorController = null;
        }
        return vueCliRunningGeneratorController;
    }

    private static final Pair<Path, String> validateProjectLocation(String projectLocation) {
        Path location = null;
        String error = null;
        try {
            Path parentFolder;
            Path path = location = Paths.get(projectLocation, new String[0]).normalize();
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"location");
            Path path2 = parentFolder = path.getParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"parentFolder");
            if (!PathKt.exists((Path)path2) && !FileUtil.createDirectory((File)parentFolder.toFile())) {
                error = "Can not create project directory: %s";
            }
        }
        catch (InvalidPathException e) {
            error = "Invalid project path: %s";
        }
        if (error != null) {
            Pair pair;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Object[] objectArray = new Object[]{projectLocation};
            Object var7_6 = null;
            Pair pair2 = pair;
            Pair pair3 = pair;
            String string = String.format(error, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(format, *args)");
            String string2 = string;
            pair2(var7_6, (Object)string2);
            return pair3;
        }
        return new Pair((Object)location, null);
    }
}

