/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysql.generator.producers;

import com.intellij.database.dialects.base.generator.AbstractScriptGeneratorKt;
import com.intellij.database.dialects.base.generator.BaseProducer;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelperKt;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.producers.CreateLikeColumn;
import com.intellij.database.dialects.base.generator.producers.LikeColumnProducersKt;
import com.intellij.database.dialects.mysql.generator.MysqlScriptGeneratorHelperKt;
import com.intellij.database.dialects.mysql.model.MysqlTableColumn;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.properties.MysqlColumnKind;
import com.intellij.database.script.generator.ScriptLocus;
import com.intellij.database.script.generator.ScriptingCapabilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0014J\n\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u000bH\u0014J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0014J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/dialects/mysql/generator/producers/MysqlCreateTableColumn;", "Lcom/intellij/database/dialects/base/generator/producers/CreateLikeColumn;", "Lcom/intellij/database/dialects/mysql/model/MysqlTableColumn;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "element", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;Lcom/intellij/database/dialects/mysql/model/MysqlTableColumn;)V", "canCreateOrdered", "Lcom/intellij/database/script/generator/ScriptingCapabilities$VersionedCapability;", "", "generalColumnSpecification", "", "makeColumnSpecification", "makeComputedColumnSpecification", "makeNormalColumnSpecification", "produceComment", "", "exists", "comment", "intellij.database.dialects"})
public final class MysqlCreateTableColumn
extends CreateLikeColumn<MysqlTableColumn> {
    @Override
    @NotNull
    public ScriptingCapabilities.VersionedCapability<Boolean> canCreateOrdered() {
        return AbstractScriptGeneratorKt.getSUPPORTED();
    }

    @Override
    public void produceComment(boolean exists, @Nullable String comment) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected String generalColumnSpecification() {
        String s = super.generalColumnSpecification();
        String collation = ((MysqlTableColumn)this.getElement()).getCollation();
        String charSet = MysqlScriptGeneratorHelperKt.defaultCollationForCharset(this.getContext().getModel(), collation);
        if (charSet != null) {
            void $receiver$iv;
            void this_$iv;
            String string = charSet;
            MysqlCreateTableColumn mysqlCreateTableColumn = this;
            StringBuilder stringBuilder = new StringBuilder().append(s).append(" charset ");
            String string2 = this_$iv.getContext().getNaming().nameToScript((String)$receiver$iv, false);
            s = stringBuilder.append(string2).toString();
        } else if (collation != null) {
            String $receiver$iv = collation;
            MysqlCreateTableColumn this_$iv = this;
            StringBuilder stringBuilder = new StringBuilder().append(s).append(" collate ");
            String string = this_$iv.getContext().getNaming().nameToScript($receiver$iv, false);
            s = stringBuilder.append(string).toString();
        }
        return s;
    }

    @Override
    @Nullable
    protected String makeNormalColumnSpecification() {
        String string = super.makeNormalColumnSpecification();
        if (string == null) {
            return null;
        }
        String s = string;
        if (((MysqlTableColumn)this.getElement()).isAutoInc()) {
            s = s + " auto_increment";
        }
        if (((MysqlTableColumn)this.getElement()).getOnUpdate() != null) {
            s = s + " on update " + ((MysqlTableColumn)this.getElement()).getOnUpdate();
        }
        return s;
    }

    @Override
    @Nullable
    protected String makeComputedColumnSpecification() {
        StringBuilder stringBuilder = new StringBuilder();
        DataType dataType = ((MysqlTableColumn)this.getElement()).getDataType();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"element.dataType");
        String res2 = stringBuilder.append(this.script(dataType)).append(" as (").append(((MysqlTableColumn)this.getElement()).getDefault()).append(')').toString();
        if (((MysqlTableColumn)this.getElement()).getColumnKind() == MysqlColumnKind.GENERATED_STORED) {
            res2 = res2 + " stored";
        }
        return res2;
    }

    @Override
    @Nullable
    public String makeColumnSpecification() {
        String spec = super.makeColumnSpecification();
        String string = ((MysqlTableColumn)this.getElement()).getComment();
        if (string != null) {
            String string2;
            String it = string2 = string;
            StringBuilder stringBuilder = new StringBuilder().append(" comment ");
            String string3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it");
            spec = Intrinsics.stringPlus((String)spec, (Object)stringBuilder.append(ScriptGeneratorHelperKt.getSqlString(string3)).toString());
        }
        if (this.getContext().getLocus() == ScriptLocus.OUTSIDE) {
            boolean inAlter;
            ElementDelta<?> elementDelta = this.getContext().getByTarget().get(this.getElement());
            boolean bl = inAlter = (elementDelta != null ? elementDelta.getSourceElement() : null) != null;
            if (!inAlter && LikeColumnProducersKt.hasExistingColumnAfter((BasicLikeColumn)this.getElement(), this.getContext())) {
                BasicLikeColumn prev = LikeColumnProducersKt.getPrevColumn((BasicLikeColumn)this.getElement());
                spec = prev != null ? Intrinsics.stringPlus((String)spec, (Object)(" after " + BaseProducer.quote$default(this, prev, null, 2, null))) : Intrinsics.stringPlus((String)spec, (Object)" first");
            }
        }
        return spec;
    }

    public MysqlCreateTableColumn(@NotNull ScriptingContext context, @NotNull MysqlTableColumn element2) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        super(context, (BasicLikeColumn)element2);
    }
}

