/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.basic;

import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicColumniation;
import com.intellij.database.model.basic.BasicConstraint;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.families.Family;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface BasicKey
extends BasicConstraint,
DasTableKey {
    default public boolean isPrimary() {
        return false;
    }

    default public boolean isClustering() {
        BasicIndex index2 = this.getUnderlyingIndex();
        return index2 != null && index2.isClustering();
    }

    default public String getUnderlyingIndexName() {
        return null;
    }

    default public BasicIndex getUnderlyingIndex() {
        BasicLikeTable table = this.getLikeTable();
        if (table == null) {
            return null;
        }
        String indexName = this.getUnderlyingIndexName();
        if (indexName != null) {
            return ModelFun.findNamedChild(table, BasicIndex.class, ObjectKind.INDEX, indexName);
        }
        Family<? extends BasicElement> indices = table.familyOf(ObjectKind.INDEX);
        if (indices == null) {
            return null;
        }
        List<String> names = this.getColNames();
        return (BasicIndex)indices.jbi().filter(BasicIndex.class).find(i2 -> (i2.isUnique() || i2.isNameSurrogate()) && i2.getColNames().equals(names));
    }

    @Override
    @NotNull
    default public String calculateDisplayOrder() {
        char c1 = this.isPrimary() ? (char)'P' : 'U';
        String string = c1 + BasicColumniation.calculateDisplayOrderByColumns(this);
        if (string == null) {
            BasicKey.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicKey", "calculateDisplayOrder"));
    }
}

