/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle;

import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.base.TokenClasses;
import com.intellij.sql.dialects.oracle.OracleDialect;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.lexer._OracleLexer;
import org.jetbrains.annotations.Nullable;

public class OracleLexer
extends SqlLexer {
    public OracleLexer() {
        super(OracleDialect.LazyData.ourClasses, new _OracleLexer());
    }

    protected OracleLexer(TokenClasses tokenClasses, FlexLexer flexLexer) {
        super(tokenClasses, flexLexer);
    }

    @Override
    protected void lookAhead(Lexer baseLexer) {
        if (!this.lookAheadRangeOperator(baseLexer) && !this.lookAheadCustomQuotation(baseLexer)) {
            super.lookAhead(baseLexer);
        }
    }

    private boolean lookAheadCustomQuotation(Lexer baseLexer) {
        String ident = OracleLexer.getCustomEndingQuote(baseLexer);
        if (ident == null) {
            return false;
        }
        int identLen = ident.length();
        int stringStart = baseLexer.getTokenStart() + identLen + baseLexer.getTokenText().indexOf("'");
        return this.processCustomQuotation(baseLexer, ident, stringStart);
    }

    @Nullable
    private static String getCustomEndingQuote(Lexer baseLexer) {
        char prefix;
        IElementType type = baseLexer.getTokenType();
        if (type != SqlTokens.SQL_STRING_TOKEN && type != SqlTokens.BAD_CHARACTER && type != SqlTokens.SQL_UNCLOSED_TOKEN) {
            return null;
        }
        String text2 = baseLexer.getTokenText();
        int index2 = text2.indexOf(39);
        if (index2 + 1 >= text2.length()) {
            return null;
        }
        char c2 = prefix = index2 > 0 ? text2.charAt(index2 - 1) : (char)'\u0000';
        if (prefix != 'Q' && prefix != 'q') {
            return null;
        }
        char delimiter = text2.charAt(index2 + 1);
        if (delimiter == '(') {
            return ")'";
        }
        if (delimiter == '<') {
            return ">'";
        }
        if (delimiter == '{') {
            return "}'";
        }
        if (delimiter == '[') {
            return "]'";
        }
        return delimiter + "'";
    }
}

