/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.actions;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.actions.AttributesDefaults;
import com.intellij.ide.fileTemplates.ui.CreateFromTemplateDialog;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.service.fus.collectors.FUSProjectUsageTrigger;
import com.intellij.internal.statistic.service.fus.collectors.UsageDescriptorKeyValidator;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.actions.PhpBaseNewClassDialog;
import com.jetbrains.php.actions.PhpNewClassDataProvider;
import com.jetbrains.php.actions.PhpNewFileDialog;
import com.jetbrains.php.actions.newClassDataProvider.ClassCreationType;
import com.jetbrains.php.actions.statistics.PhpNewClassUsageCollector;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.roots.PhpDirectoryByPsrProvider;
import com.jetbrains.php.roots.ui.PhpNamespaceComboBox;
import com.jetbrains.php.roots.ui.PhpPsrDirectoryComboBox;
import com.jetbrains.php.templates.PhpFileTemplateUtil;
import com.jetbrains.php.templates.PhpTemplatesSettings;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpNewClassDialog
extends PhpBaseNewClassDialog
implements PhpNewClassDataProvider {
    private static final String LAST_SELECTED_CUSTOM_TEMPLATE_NAME_PROPERTY = PhpNewClassDialog.class.getName() + ".lastSelectedCustomTemplate";
    private JPanel myMainPanel;
    public EditorTextField myNameTextField;
    public PhpNamespaceComboBox myNamespaceCombobox;
    public EditorTextField myFileNameTextField;
    public JComboBox myTemplateComboBox;
    protected JComboBox myExtensionComboBox;
    private JLabel myTemplateUpDownHint;
    private JLabel myExtensionUpDownHint;
    private JBLabel myNamespaceCompletionHintLabel;
    protected PhpPsrDirectoryComboBox myDirectoryCombobox;
    private JBLabel myEditDirectoryHintLabel;
    private JBCheckBox myUseTemplateNextTimeCheckBox;
    private Properties myCustomProperties;

    public PhpNewClassDialog(@NotNull Project project, @Nullable PsiDirectory directory) {
        if (project == null) {
            PhpNewClassDialog.$$$reportNull$$$0(0);
        }
        super(project, directory);
        this.$$$setupUI$$$();
        this.myCustomProperties = new Properties();
        this.init(this.myMainPanel, this.myNameTextField, this.myNamespaceCombobox, this.myNamespaceCompletionHintLabel, this.myFileNameTextField, this.myDirectoryCombobox, this.myEditDirectoryHintLabel);
        this.init();
    }

    @Override
    public String getClassName() {
        return this.myNameTextField.getText();
    }

    @Override
    public String getNamespaceName() {
        return this.getNamespace();
    }

    protected void init() {
        this.setTitle(PhpBundle.message("actions.new.php.class.dialog.title", new Object[0]));
        Object[] registeredExtensions = PhpFileTemplateUtil.getRegisteredPhpFileExtensions();
        this.myExtensionComboBox.setModel(new DefaultComboBoxModel<String>(registeredExtensions));
        int indexOfLast = ArrayUtil.indexOf((Object[])registeredExtensions, (Object)PhpTemplatesSettings.getInstance((Project)this.getProject()).NEW_PHP_CLASS_LAST_EXTENSION);
        if (indexOfLast > -1) {
            this.myExtensionComboBox.setSelectedIndex(indexOfLast);
        } else {
            this.myExtensionComboBox.setSelectedIndex(0);
        }
        this.myTemplateUpDownHint.setIcon(PlatformIcons.UP_DOWN_ARROWS);
        this.myTemplateUpDownHint.setToolTipText(PhpBundle.message("actions.new.php.base.arrows.template.tooltip", new Object[0]));
        this.myExtensionUpDownHint.setIcon(PlatformIcons.UP_DOWN_ARROWS);
        this.myExtensionUpDownHint.setToolTipText(PhpBundle.message("actions.new.php.base.arrows.extension.tooltip", new Object[0]));
        this.myTemplateComboBox.setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list, Object item, int index, boolean selected, boolean hasFocus) {
                if (item instanceof ClassCreationType) {
                    this.setText(((ClassCreationType)((Object)item)).getName());
                    this.setIcon(((ClassCreationType)((Object)item)).getIcon());
                } else {
                    this.setSeparator();
                }
            }
        });
        new ComboboxSpeedSearch(this.myTemplateComboBox){

            protected String getElementText(Object element) {
                return ((ClassCreationType)((Object)element)).getName();
            }
        };
        KeyboardShortcut up = new KeyboardShortcut(KeyStroke.getKeyStroke(38, 0), null);
        KeyboardShortcut down = new KeyboardShortcut(KeyStroke.getKeyStroke(40, 0), null);
        AnAction templateArrow = PhpNewFileDialog.getCbArrowAction(this.myTemplateComboBox);
        templateArrow.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{up, down}), (JComponent)this.myNameTextField);
        for (ClassCreationType it : ClassCreationType.BUNDLED) {
            if (!StringUtil.equals((CharSequence)it.getTemplateName(), (CharSequence)"PHP Trait")) {
                this.myTemplateComboBox.addItem(it);
                continue;
            }
            if (!PhpProjectConfigurationFacade.getInstance(this.myProject).getLanguageLevel().hasFeature(PhpLanguageFeature.TRAITS)) continue;
            this.myTemplateComboBox.addItem(it);
        }
        this.addCustomPhpTemplatesToCombo();
        boolean defaultCustomTemplateExists = this.getDefaultCustomTemplateName() != null;
        this.myUseTemplateNextTimeCheckBox.setVisible(defaultCustomTemplateExists);
        this.myUseTemplateNextTimeCheckBox.setSelected(defaultCustomTemplateExists);
        AnAction extensionArrow = PhpNewFileDialog.getCbArrowAction(this.myExtensionComboBox);
        extensionArrow.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{up, down}), (JComponent)this.myFileNameTextField);
        super.init();
    }

    private void addCustomPhpTemplatesToCombo() {
        List phpTemplates = ContainerUtil.filter((Object[])FileTemplateManager.getInstance((Project)this.myProject).getAllTemplates(), t -> StringUtil.equals((CharSequence)t.getExtension(), (CharSequence)"php"));
        if (phpTemplates.isEmpty()) {
            return;
        }
        this.myTemplateComboBox.addItem(new JSeparator(0));
        String defaultCustomTemplateName = this.getDefaultCustomTemplateName();
        for (FileTemplate template : phpTemplates) {
            ClassCreationType customTemplateItem = new ClassCreationType(template.getName(), PhpIcons.PHP_FILE, template.getName());
            this.myTemplateComboBox.addItem(customTemplateItem);
            if (!StringUtil.equals((CharSequence)customTemplateItem.getTemplateName(), (CharSequence)defaultCustomTemplateName)) continue;
            this.myTemplateComboBox.setSelectedItem((Object)customTemplateItem);
        }
        this.myTemplateComboBox.addActionListener(new ActionListener(){
            private int myLastSelectedIndex;
            {
                this.myLastSelectedIndex = PhpNewClassDialog.this.myTemplateComboBox.getSelectedIndex();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedIndex = PhpNewClassDialog.this.myTemplateComboBox.getSelectedIndex();
                if (PhpNewClassDialog.this.myTemplateComboBox.getSelectedItem() instanceof JSeparator) {
                    int newIndex = this.myLastSelectedIndex < selectedIndex ? Math.min(selectedIndex + 1, PhpNewClassDialog.this.myTemplateComboBox.getItemCount() - 1) : Math.max(selectedIndex - 1, 0);
                    PhpNewClassDialog.this.myTemplateComboBox.setSelectedIndex(newIndex);
                }
                this.myLastSelectedIndex = PhpNewClassDialog.this.myTemplateComboBox.getSelectedIndex();
                PhpNewClassDialog.this.myUseTemplateNextTimeCheckBox.setVisible(!ClassCreationType.BUNDLED.contains((Object)PhpNewClassDialog.this.getSelectedClassCreationType()));
            }
        });
    }

    @Nullable
    private String getDefaultCustomTemplateName() {
        return PropertiesComponent.getInstance((Project)this.myProject).getValue(LAST_SELECTED_CUSTOM_TEMPLATE_NAME_PROPERTY);
    }

    protected String getDimensionServiceKey() {
        return "NewPhpClassDialog";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doOKAction() {
        CreateFromTemplateDialog dialog = this.createFillCustomPropertiesDialog();
        if (UIUtil.findComponentOfType((JComponent)dialog.getContentPanel(), JTextField.class) != null) {
            if (!dialog.showAndGet()) return;
            this.myCustomProperties = dialog.getEnteredProperties();
        } else {
            dialog.close(1);
        }
        PhpTemplatesSettings.getInstance((Project)this.myProject).NEW_PHP_CLASS_LAST_EXTENSION = this.getExtension();
        this.saveDefaultLibraryName();
        super.doOKAction();
        this.collectStatistics();
    }

    private void saveDefaultLibraryName() {
        ClassCreationType selectedClassCreationType = this.getSelectedClassCreationType();
        String selectedCustomTemplateName = !ClassCreationType.BUNDLED.contains((Object)selectedClassCreationType) && this.myUseTemplateNextTimeCheckBox.isSelected() ? selectedClassCreationType.getTemplateName() : null;
        PropertiesComponent.getInstance((Project)this.myProject).setValue(LAST_SELECTED_CUSTOM_TEMPLATE_NAME_PROPERTY, selectedCustomTemplateName);
    }

    private void collectStatistics() {
        FUSProjectUsageTrigger usageTrigger = FUSProjectUsageTrigger.getInstance((Project)this.myProject);
        usageTrigger.trigger(PhpNewClassUsageCollector.class, UsageDescriptorKeyValidator.ensureProperKey((String)this.getTypeName()) + ".type");
        if (!this.myCustomProperties.isEmpty()) {
            usageTrigger.trigger(PhpNewClassUsageCollector.class, "custom.variables");
        }
    }

    private String getTypeName() {
        ClassCreationType selectedType = this.getSelectedClassCreationType();
        return ClassCreationType.BUNDLED.contains((Object)selectedType) ? selectedType.getTemplateName() : "custom";
    }

    @NotNull
    private CreateFromTemplateDialog createFillCustomPropertiesDialog() {
        FileTemplate template = FileTemplateManager.getInstance((Project)this.myProject).getInternalTemplate(this.getTemplateName());
        AttributesDefaults defaults = new AttributesDefaults(this.getClassName()).withFixedName(true);
        CreateFromTemplateDialog createFromTemplateDialog = new CreateFromTemplateDialog(this.myProject, this.getBaseDirectory(), template, defaults, this.getIgnoredProperties()){

            protected void doOKAction() {
                this.close(0);
            }
        };
        if (createFromTemplateDialog == null) {
            PhpNewClassDialog.$$$reportNull$$$0(1);
        }
        return createFromTemplateDialog;
    }

    @NotNull
    private Properties getIgnoredProperties() {
        Properties properties = new Properties();
        properties.setProperty("NAME", this.getClassName());
        properties.setProperty("NAMESPACE", this.getNamespaceName());
        properties.setProperty("FILE_NAME", this.getFileName());
        properties.setProperty("CARET", "");
        PhpFileTemplateUtil.fillDefaultProperties(FileTemplateManager.getInstance((Project)this.myProject), properties, this.getBaseDirectory());
        Properties properties2 = properties;
        if (properties2 == null) {
            PhpNewClassDialog.$$$reportNull$$$0(2);
        }
        return properties2;
    }

    @Override
    @NotNull
    public String getTemplateName() {
        String string = this.getSelectedClassCreationType().getTemplateName();
        if (string == null) {
            PhpNewClassDialog.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    private ClassCreationType getSelectedClassCreationType() {
        ClassCreationType selectedItem = (ClassCreationType)((Object)this.myTemplateComboBox.getSelectedItem());
        assert (selectedItem != null);
        ClassCreationType classCreationType = selectedItem;
        if (classCreationType == null) {
            PhpNewClassDialog.$$$reportNull$$$0(4);
        }
        return classCreationType;
    }

    @Override
    @NotNull
    protected String getExtension() {
        String string = (String)this.myExtensionComboBox.getSelectedItem();
        if (string == null) {
            PhpNewClassDialog.$$$reportNull$$$0(5);
        }
        return string;
    }

    private void createUIComponents() {
        this.myNamespaceCombobox = new PhpNamespaceComboBox(this.getProject(), "", this.getDisposable());
        this.myDirectoryCombobox = new PhpPsrDirectoryComboBox(this.getProject(), PhpDirectoryByPsrProvider.getSourceRootProvide());
    }

    @Override
    public void setData(String className, ClassCreationType classType, String fileName, String namespaceName) {
        this.myNameTextField.setText(className);
        this.myFileNameTextField.setText(fileName);
        this.myNamespaceCombobox.getEditorTextField().setText(namespaceName);
        this.myTemplateComboBox.setSelectedItem((Object)classType);
    }

    @Override
    @NotNull
    public Properties getProperties(@NotNull PsiDirectory directory) {
        if (directory == null) {
            PhpNewClassDialog.$$$reportNull$$$0(6);
        }
        Properties properties = super.getProperties(directory);
        this.myCustomProperties.stringPropertyNames().forEach(name -> properties.setProperty((String)name, this.myCustomProperties.getProperty((String)name)));
        Properties properties2 = properties;
        if (properties2 == null) {
            PhpNewClassDialog.$$$reportNull$$$0(7);
        }
        return properties2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/actions/PhpNewClassDialog";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/actions/PhpNewClassDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createFillCustomPropertiesDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredProperties";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedClassCreationType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtension";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        EditorTextField editorTextField;
        EditorTextField editorTextField2;
        JLabel jLabel;
        JLabel jLabel2;
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(9, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/PhpBundle").getString("actions.new.php.class.dialog.border.title.class"), (int)0, (int)0, null, null));
        this.myTemplateComboBox = jComboBox2 = new JComboBox();
        jPanel2.add(jComboBox2, new GridConstraints(6, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        this.myExtensionComboBox = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(8, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/PhpBundle").getString("actions.new.php.class.dialog.label.class.name"));
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/PhpBundle").getString("actions.new.php.base.dialog.label.file.name"));
        jPanel2.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("messages/PhpBundle").getString("actions.new.php.class.dialog.label.template"));
        jPanel2.add((Component)jLabel5, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("messages/PhpBundle").getString("actions.new.php.base.dialog.label.extension"));
        jPanel2.add((Component)jLabel6, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTemplateUpDownHint = jLabel2 = new JLabel();
        jLabel2.setText("");
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myExtensionUpDownHint = jLabel = new JLabel();
        jLabel.setText("");
        jPanel2.add((Component)jLabel, new GridConstraints(3, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameTextField = editorTextField2 = new EditorTextField();
        jPanel2.add((Component)editorTextField2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, ResourceBundle.getBundle("messages/PhpBundle").getString("actions.new.php.class.dialog.label.namespace"));
        jPanel2.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        PhpNamespaceComboBox phpNamespaceComboBox = this.myNamespaceCombobox;
        jPanel2.add((Component)((Object)phpNamespaceComboBox), new GridConstraints(1, 1, 1, 2, 0, 1, 6, 0, null, null, null));
        this.myFileNameTextField = editorTextField = new EditorTextField();
        jPanel2.add((Component)editorTextField, new GridConstraints(3, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myNamespaceCompletionHintLabel = jBLabel2 = new JBLabel();
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.MINI);
        jPanel2.add((Component)jBLabel2, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, ResourceBundle.getBundle("messages/PhpBundle").getString("actions.new.php.class.dialog.label.directory"));
        jPanel2.add((Component)jBLabel4, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        PhpPsrDirectoryComboBox phpPsrDirectoryComboBox = this.myDirectoryCombobox;
        jPanel2.add((Component)((Object)phpPsrDirectoryComboBox), new GridConstraints(4, 1, 1, 2, 0, 1, 6, 0, null, null, null));
        this.myEditDirectoryHintLabel = jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.MINI);
        jPanel2.add((Component)jBLabel, new GridConstraints(5, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUseTemplateNextTimeCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Use as a default template");
        jPanel2.add((Component)jBCheckBox, new GridConstraints(7, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel5.setLabelFor(jComboBox2);
        jLabel6.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

