/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.highlighting;

import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.MultiMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpConversionSpecificationParser {
    public static final char[] TYPE_SPECIFIERS = new char[]{'s', 'd', 'u', 'c', 'o', 'x', 'X', 'b', 'g', 'G', 'e', 'E', 'f', 'F'};

    private PhpConversionSpecificationParser() {
    }

    @NotNull
    public static MultiMap<Integer, ConversionSpecification> parseConversionSpecifications(@NotNull String expression, boolean singleQuote) {
        if (expression == null) {
            PhpConversionSpecificationParser.$$$reportNull$$$0(0);
        }
        MultiMap result = new MultiMap();
        int index = 0;
        int unmarkedOrder = 1;
        while (index < expression.length()) {
            if (!PhpConversionSpecificationParser.charAtEqualsToAny(expression, index, '%')) {
                ++index;
                continue;
            }
            boolean escapedPercent = PhpConversionSpecificationParser.charAtEqualsToAny(expression, index + 1, '%');
            if (escapedPercent) {
                index += 2;
                continue;
            }
            ConversionSpecification specification = PhpConversionSpecificationParser.parseConversionSpecification(index, expression, singleQuote);
            if (specification.getOrder() >= 0) {
                result.putValue((Object)specification.getOrder(), (Object)specification);
            } else {
                result.putValue((Object)unmarkedOrder++, (Object)specification);
            }
            index = specification.getRangeInElement().getEndOffset();
        }
        MultiMap multiMap = result;
        if (multiMap == null) {
            PhpConversionSpecificationParser.$$$reportNull$$$0(1);
        }
        return multiMap;
    }

    private static boolean charAtEqualsToAny(@NotNull String s, int index, char ... chars) {
        if (s == null) {
            PhpConversionSpecificationParser.$$$reportNull$$$0(2);
        }
        if (index >= 0 && index < s.length()) {
            for (char c : chars) {
                if (c != s.charAt(index)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static ConversionSpecification parseConversionSpecification(int index, @NotNull String expression, boolean singleQuote) {
        TextRange precision;
        TextRange argumentOrder;
        if (expression == null) {
            PhpConversionSpecificationParser.$$$reportNull$$$0(3);
        }
        int order = -1;
        int start = index++;
        if (singleQuote && (argumentOrder = PhpConversionSpecificationParser.parseUnsignedInt(expression, index)) != null && PhpConversionSpecificationParser.charAtEqualsToAny(expression, argumentOrder.getEndOffset(), '$')) {
            index = argumentOrder.getEndOffset() + 1;
            order = Integer.parseUnsignedInt(argumentOrder.substring(expression));
        }
        if (PhpConversionSpecificationParser.charAtEqualsToAny(expression, index, '+', '-')) {
            ++index;
        }
        if (singleQuote && PhpConversionSpecificationParser.charAtEqualsToAny(expression, index, '\\') && PhpConversionSpecificationParser.charAtEqualsToAny(expression, index + 1, '\'')) {
            boolean escapedChar = PhpConversionSpecificationParser.charAtEqualsToAny(expression, index += 2, '\\');
            if (escapedChar) {
                ++index;
            }
            ++index;
        } else if (PhpConversionSpecificationParser.charAtEqualsToAny(expression, index, '\'')) {
            index += 2;
        }
        TextRange width = PhpConversionSpecificationParser.parseUnsignedInt(expression, index);
        if (width != null) {
            index = width.getEndOffset();
        }
        if (PhpConversionSpecificationParser.charAtEqualsToAny(expression, index, '.') && (precision = PhpConversionSpecificationParser.parseUnsignedInt(expression, index + 1)) != null) {
            index = precision.getEndOffset();
        }
        if (PhpConversionSpecificationParser.charAtEqualsToAny(expression, index, TYPE_SPECIFIERS)) {
            ++index;
        }
        ConversionSpecification conversionSpecification = new ConversionSpecification(TextRange.create((int)start, (int)index), order);
        if (conversionSpecification == null) {
            PhpConversionSpecificationParser.$$$reportNull$$$0(4);
        }
        return conversionSpecification;
    }

    @Nullable
    private static TextRange parseUnsignedInt(@NotNull String expression, int from) {
        if (expression == null) {
            PhpConversionSpecificationParser.$$$reportNull$$$0(5);
        }
        if (!PhpConversionSpecificationParser.isDigit(expression, from)) {
            return null;
        }
        int start = from;
        while (PhpConversionSpecificationParser.isDigit(expression, from)) {
            ++from;
        }
        return TextRange.create((int)start, (int)from);
    }

    private static boolean isDigit(@NotNull String expression, int index) {
        if (expression == null) {
            PhpConversionSpecificationParser.$$$reportNull$$$0(6);
        }
        return index >= 0 && index < expression.length() && Character.isDigit(expression.charAt(index));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/codeInsight/highlighting/PhpConversionSpecificationParser";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/codeInsight/highlighting/PhpConversionSpecificationParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parseConversionSpecifications";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseConversionSpecification";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseConversionSpecifications";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "charAtEqualsToAny";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseConversionSpecification";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseUnsignedInt";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isDigit";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ConversionSpecification {
        @NotNull
        private final TextRange myRange;
        private final int myOrder;

        private ConversionSpecification(@NotNull TextRange range, int order) {
            if (range == null) {
                ConversionSpecification.$$$reportNull$$$0(0);
            }
            this.myRange = range;
            this.myOrder = order;
        }

        @NotNull
        public TextRange getRangeInElement() {
            TextRange textRange = this.myRange;
            if (textRange == null) {
                ConversionSpecification.$$$reportNull$$$0(1);
            }
            return textRange;
        }

        private int getOrder() {
            return this.myOrder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/codeInsight/highlighting/PhpConversionSpecificationParser$ConversionSpecification";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/codeInsight/highlighting/PhpConversionSpecificationParser$ConversionSpecification";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRangeInElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

