/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer;

import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ComposerStability implements Comparable<ComposerStability>
{
    STABLE("stable"){

        @Override
        public boolean matches(@NotNull String version) {
            if (version == null) {
                1.$$$reportNull$$$0(0);
            }
            return !RC.matches(version) && !BETA.matches(version) && !ALPHA.matches(version) && !DEV.matches(version);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/jetbrains/php/composer/ComposerStability$1", "matches"));
        }
    }
    ,
    RC("RC"){

        @Override
        public boolean matches(@NotNull String version) {
            if (version == null) {
                2.$$$reportNull$$$0(0);
            }
            return version.toLowerCase().contains("rc");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/jetbrains/php/composer/ComposerStability$2", "matches"));
        }
    }
    ,
    BETA("beta"){

        @Override
        public boolean matches(@NotNull String version) {
            if (version == null) {
                3.$$$reportNull$$$0(0);
            }
            return version.toLowerCase().contains("beta");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/jetbrains/php/composer/ComposerStability$3", "matches"));
        }
    }
    ,
    ALPHA("alpha"){

        @Override
        public boolean matches(@NotNull String version) {
            if (version == null) {
                4.$$$reportNull$$$0(0);
            }
            return version.toLowerCase().contains("alpha");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/jetbrains/php/composer/ComposerStability$4", "matches"));
        }
    }
    ,
    DEV("dev"){

        @Override
        public boolean matches(@NotNull String version) {
            if (version == null) {
                5.$$$reportNull$$$0(0);
            }
            return version.toLowerCase().contains("dev") || version.contains("-p");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/jetbrains/php/composer/ComposerStability$5", "matches"));
        }
    };

    private static final List<ComposerStability> ORDERED;
    private final String myID;

    private ComposerStability(String id) {
        this.myID = id;
    }

    public boolean needsToBeSpecified() {
        return ComposerStability.getDefault() != this;
    }

    public abstract boolean matches(@NotNull String var1);

    @NotNull
    public String getId() {
        String string = this.myID;
        if (string == null) {
            ComposerStability.$$$reportNull$$$0(0);
        }
        return string;
    }

    public static ComposerStability getDefault() {
        return STABLE;
    }

    public static ComposerStability getStability(@NotNull String version) {
        if (version == null) {
            ComposerStability.$$$reportNull$$$0(1);
        }
        ComposerStability stability = ComposerStability.getLeastStable();
        while (stability != null) {
            if (stability.matches(version)) {
                return stability;
            }
            stability = ComposerStability.getNextStabilityLevel(stability);
        }
        return ComposerStability.getDefault();
    }

    @Nullable
    public static ComposerStability getNextStabilityLevel(ComposerStability stability) {
        int i = ORDERED.indexOf(stability);
        if (i + 1 == ORDERED.size()) {
            return null;
        }
        return ORDERED.get(i + 1);
    }

    public static ComposerStability getLeastStable() {
        return ORDERED.get(0);
    }

    public static ComposerStability getMostStable() {
        return ORDERED.get(ORDERED.size() - 1);
    }

    public boolean isMoreStableThan(ComposerStability stability) {
        return ORDERED.indexOf(this) > ORDERED.indexOf(stability);
    }

    static {
        ORDERED = Arrays.asList(DEV, ALPHA, BETA, RC, STABLE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/ComposerStability";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/ComposerStability";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getStability";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

