/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.injection;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.injection.DefaultSQLInPhpInjectionExternalFragmentSubstProvider;
import com.jetbrains.php.injection.PhpInjectionExternalFragmentSubstProvider;
import com.jetbrains.php.injection.PhpInjectionInternalFragmentSubstProvider;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpInjectionUtil {
    static final List<Class<? extends PhpExpression>> ELEMENTS_TO_INJECT_IN = Arrays.asList(StringLiteralExpression.class, BinaryExpression.class);
    private static final TokenSet literals = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.STRING_LITERAL, PhpTokenTypes.STRING_LITERAL_SINGLE_QUOTE, PhpTokenTypes.HEREDOC_CONTENTS});
    private static final TokenSet quotes = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.chLDOUBLE_QUOTE, PhpTokenTypes.chRDOUBLE_QUOTE, PhpTokenTypes.chLSINGLE_QUOTE, PhpTokenTypes.chRSINGLE_QUOTE});

    private PhpInjectionUtil() {
    }

    @Nullable
    public static PsiElement getLargestStringLiteral(@Nullable PsiElement context) {
        PsiElement element = null;
        PsiElement current = context;
        while (PhpInjectionUtil.isStringLiteralPart(current, element)) {
            element = current;
            current = current.getParent();
        }
        return element;
    }

    @NotNull
    static InjectionResult registerStringLiteralInjection(@NotNull PsiElement element, @NotNull MultiHostRegistrar registrar, Language language) {
        InjectionResult injectionResult;
        if (element == null) {
            PhpInjectionUtil.$$$reportNull$$$0(0);
        }
        if (registrar == null) {
            PhpInjectionUtil.$$$reportNull$$$0(1);
        }
        try {
            injectionResult = PhpInjectionUtil.processStringLiteral(element, registrar, "", "", false, language);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException("@`" + element.getText() + "` " + language, e);
        }
        if (injectionResult == null) {
            PhpInjectionUtil.$$$reportNull$$$0(2);
        }
        return injectionResult;
    }

    private static boolean isStringLiteralPart(@Nullable PsiElement element, @Nullable PsiElement context) {
        if (element == null) {
            return false;
        }
        if (element == context) {
            return true;
        }
        if (element instanceof StringLiteralExpression) {
            return true;
        }
        if (element instanceof ParenthesizedExpression) {
            PhpPsiElement contained = ((ParenthesizedExpression)element).getArgument();
            return PhpInjectionUtil.isStringLiteralPart((PsiElement)contained, context);
        }
        if (element instanceof BinaryExpression) {
            BinaryExpression expr = (BinaryExpression)element;
            PsiElement left = expr.getLeftOperand();
            PsiElement right = expr.getRightOperand();
            IElementType operation = expr.getOperationType();
            if (operation == PhpTokenTypes.opCONCAT) {
                return PhpInjectionUtil.isStringLiteralPart(left, context) || PhpInjectionUtil.isStringLiteralPart(right, context);
            }
            return false;
        }
        return false;
    }

    @NotNull
    private static InjectionResult processStringLiteral(@NotNull PsiElement element, @NotNull MultiHostRegistrar registrar, @NotNull String prefix, @NotNull String suffix, boolean containsUnparsableFragment, Language language) {
        BinaryExpression expr;
        IElementType operation;
        if (element == null) {
            PhpInjectionUtil.$$$reportNull$$$0(3);
        }
        if (registrar == null) {
            PhpInjectionUtil.$$$reportNull$$$0(4);
        }
        if (prefix == null) {
            PhpInjectionUtil.$$$reportNull$$$0(5);
        }
        if (suffix == null) {
            PhpInjectionUtil.$$$reportNull$$$0(6);
        }
        if (element instanceof StringLiteralExpression) {
            StringLiteralExpression expr2 = (StringLiteralExpression)element;
            ASTNode child = expr2.getNode().getFirstChildNode();
            IElementType type = child.getElementType();
            if (type == PhpTokenTypes.chLDOUBLE_QUOTE || type == PhpTokenTypes.chLSINGLE_QUOTE) {
                child = child.getTreeNext();
            }
            ASTNode last = null;
            boolean injected = false;
            while (child != null) {
                ASTNode next = child.getTreeNext();
                IElementType iElementType = type = next != null ? next.getElementType() : null;
                if (type == PhpTokenTypes.chRDOUBLE_QUOTE || type == PhpTokenTypes.chRSINGLE_QUOTE) {
                    next = next.getTreeNext();
                }
                if (literals.contains(type = child.getElementType()) || quotes.contains(type)) {
                    String chunkSuffix;
                    String chunkPrefix;
                    int start = child.getStartOffset() - expr2.getTextOffset();
                    TextRange range = new TextRange(start, start + child.getTextLength());
                    assert (range.getLength() > 0);
                    String string = chunkPrefix = last != null ? "" : prefix;
                    if (next != null) {
                        IElementType nextElementType = next.getElementType();
                        if (nextElementType == PhpStubElementTypes.VARIABLE) {
                            String interpolatedVariableSubstitution = PhpInjectionUtil.getExtFragmentSubst(next, element, language);
                            chunkSuffix = interpolatedVariableSubstitution != null ? interpolatedVariableSubstitution : PhpInjectionUtil.createSqlUserParameterWrapper(next.getPsi());
                            containsUnparsableFragment = containsUnparsableFragment || interpolatedVariableSubstitution == null;
                        } else {
                            chunkSuffix = nextElementType == PhpTokenTypes.ESCAPE_SEQUENCE ? next.getText() : "";
                        }
                    } else {
                        chunkSuffix = suffix;
                    }
                    if (expr2.isValidHost()) {
                        PhpInjectionInternalFragmentSubstProvider[] internalExtensions = (PhpInjectionInternalFragmentSubstProvider[])PhpInjectionInternalFragmentSubstProvider.EP_NAME.getExtensions((AreaInstance)expr2.getProject());
                        boolean isExtended = false;
                        for (PhpInjectionInternalFragmentSubstProvider it : internalExtensions) {
                            Collection<Trinity<String, String, TextRange>> fragmentsSubstitutions = it.getInternalFragmentsSubstitutions(expr2.getProject(), child, (Trinity<String, String, TextRange>)new Trinity((Object)chunkPrefix, (Object)chunkSuffix, (Object)range), language);
                            if (fragmentsSubstitutions == null) continue;
                            for (Trinity<String, String, TextRange> substitution : fragmentsSubstitutions) {
                                registrar.addPlace((String)substitution.first, (String)substitution.second, (PsiLanguageInjectionHost)expr2, (TextRange)substitution.third);
                                isExtended = true;
                            }
                            break;
                        }
                        if (!isExtended) {
                            registrar.addPlace(chunkPrefix, chunkSuffix, (PsiLanguageInjectionHost)expr2, range);
                        }
                        injected = true;
                    }
                } else if (type == PhpStubElementTypes.VARIABLE) {
                    containsUnparsableFragment = true;
                }
                last = child;
                child = next;
            }
            InjectionResult injectionResult = new InjectionResult(injected, containsUnparsableFragment);
            if (injectionResult == null) {
                PhpInjectionUtil.$$$reportNull$$$0(7);
            }
            return injectionResult;
        }
        if (element instanceof ParenthesizedExpression) {
            PhpPsiElement contained = ((ParenthesizedExpression)element).getArgument();
            if (contained != null) {
                InjectionResult injectionResult = PhpInjectionUtil.processStringLiteral((PsiElement)contained, registrar, prefix, suffix, containsUnparsableFragment, language);
                if (injectionResult == null) {
                    PhpInjectionUtil.$$$reportNull$$$0(8);
                }
                return injectionResult;
            }
        } else if (element instanceof BinaryExpression && (operation = (expr = (BinaryExpression)element).getOperationType()) == PhpTokenTypes.opCONCAT) {
            PsiElement left = expr.getLeftOperand();
            PsiElement right = expr.getRightOperand();
            boolean isLeftString = PhpInjectionUtil.isStringLiteralPart(left, null);
            boolean isRightString = PhpInjectionUtil.isStringLiteralPart(right, null);
            InjectionResult result = InjectionResult.EMPTY;
            if (isLeftString) {
                String rightSubstitution = isRightString || right == null ? "" : PhpInjectionUtil.getExtFragmentSubst(right.getNode(), element, language);
                String computedSuffix = rightSubstitution != null ? rightSubstitution : PhpInjectionUtil.createSqlUserParameterWrapper(right);
                result = result.append(PhpInjectionUtil.processStringLiteral(left, registrar, prefix, computedSuffix, rightSubstitution == null, language));
            }
            if (isRightString) {
                String leftSubstitution = isLeftString || left == null ? "" : PhpInjectionUtil.getExtFragmentSubst(left.getNode(), element, language);
                String computedPrefix = leftSubstitution != null ? leftSubstitution : PhpInjectionUtil.createSqlUserParameterWrapper(left);
                result = result.append(PhpInjectionUtil.processStringLiteral(right, registrar, computedPrefix, suffix, leftSubstitution == null, language));
            }
            InjectionResult injectionResult = result;
            if (injectionResult == null) {
                PhpInjectionUtil.$$$reportNull$$$0(9);
            }
            return injectionResult;
        }
        InjectionResult injectionResult = InjectionResult.EMPTY;
        if (injectionResult == null) {
            PhpInjectionUtil.$$$reportNull$$$0(10);
        }
        return injectionResult;
    }

    @Nullable
    private static String getExtFragmentSubst(ASTNode node, PsiElement context, Language language) {
        PhpInjectionExternalFragmentSubstProvider[] extensions = (PhpInjectionExternalFragmentSubstProvider[])PhpInjectionExternalFragmentSubstProvider.EP_NAME.getExtensions((AreaInstance)context.getProject());
        String fragment = null;
        for (PhpInjectionExternalFragmentSubstProvider extension : extensions) {
            String subst = extension.getExtFragmentSubst(node, context, language);
            if (!StringUtil.isNotEmpty((String)subst)) continue;
            fragment = subst;
            break;
        }
        if (fragment == null) {
            fragment = DefaultSQLInPhpInjectionExternalFragmentSubstProvider.INSTANCE.getExtFragmentSubst(node, context, language);
        }
        return fragment != null ? StringUtil.unescapeStringCharacters(fragment) : null;
    }

    @NotNull
    private static String createSqlUserParameterWrapper(@NotNull PsiElement element) {
        if (element == null) {
            PhpInjectionUtil.$$$reportNull$$$0(11);
        }
        if (element instanceof PhpExpression) {
            String string = "${" + element.getText() + "}";
            if (string == null) {
                PhpInjectionUtil.$$$reportNull$$$0(12);
            }
            return string;
        }
        if ("%name" == null) {
            PhpInjectionUtil.$$$reportNull$$$0(13);
        }
        return "%name";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/injection/PhpInjectionUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/injection/PhpInjectionUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "registerStringLiteralInjection";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "processStringLiteral";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createSqlUserParameterWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerStringLiteralInjection";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processStringLiteral";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createSqlUserParameterWrapper";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class InjectionResult {
        public static final InjectionResult EMPTY = new InjectionResult(false, false);
        private final boolean myInjected;
        private final boolean myContainsUnparsableFragment;

        private InjectionResult(boolean injected, boolean containsUnparsableFragment) {
            this.myInjected = injected;
            this.myContainsUnparsableFragment = containsUnparsableFragment;
        }

        public boolean isInjected() {
            return this.myInjected;
        }

        boolean containsUnparsableFragment() {
            return this.myContainsUnparsableFragment;
        }

        public InjectionResult append(@NotNull InjectionResult result) {
            if (result == null) {
                InjectionResult.$$$reportNull$$$0(0);
            }
            return new InjectionResult(this.myInjected || result.isInjected(), this.myContainsUnparsableFragment || result.containsUnparsableFragment());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/php/injection/PhpInjectionUtil$InjectionResult", "append"));
        }
    }
}

