/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.formatter.ui;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;

public class PhpConversionCodeStylePanel
extends CodeStyleAbstractPanel {
    private JPanel myMainPanel;
    private JPanel myPreviewPanel;
    private JCheckBox myCaseBooleanCheckBox;
    private JCheckBox myCaseNullCheckBox;
    private JRadioButton myBoolUpperCaseRadioButton;
    private JRadioButton myBoolLowerCaseRadioButton;
    private JRadioButton myNullUpperCaseRadioButton;
    private JRadioButton myNullLowerCaseRadioButton;
    private JCheckBox myElseIfStyleCheckBox;
    private JRadioButton mySeparateElseIfRadioButton;
    private JRadioButton myCombineElseIfRadioButton;
    private JCheckBox myForceShortArrayStyleCheckBox;
    private JPanel myArrayDeclarationStylePanel;
    private JCheckBox myAddCommaAfterLastElementBox;
    private JBScrollPane myScrollPane;
    private JPanel myOptionsPanel;

    protected PhpConversionCodeStylePanel(CodeStyleSettings settings) {
        super(settings);
        this.$$$setupUI$$$();
        this.installPreviewPanel(this.myPreviewPanel);
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PhpConversionCodeStylePanel.this.somethingChanged();
            }
        };
        this.myForceShortArrayStyleCheckBox.addItemListener(listener);
        this.myCaseBooleanCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (PhpConversionCodeStylePanel.this.myCaseBooleanCheckBox.isSelected()) {
                    PhpConversionCodeStylePanel.this.myBoolLowerCaseRadioButton.setEnabled(true);
                    PhpConversionCodeStylePanel.this.myBoolUpperCaseRadioButton.setEnabled(true);
                } else {
                    PhpConversionCodeStylePanel.this.myBoolLowerCaseRadioButton.setEnabled(false);
                    PhpConversionCodeStylePanel.this.myBoolUpperCaseRadioButton.setEnabled(false);
                }
            }
        });
        this.myCaseNullCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (PhpConversionCodeStylePanel.this.myCaseNullCheckBox.isSelected()) {
                    PhpConversionCodeStylePanel.this.myNullLowerCaseRadioButton.setEnabled(true);
                    PhpConversionCodeStylePanel.this.myNullUpperCaseRadioButton.setEnabled(true);
                } else {
                    PhpConversionCodeStylePanel.this.myNullLowerCaseRadioButton.setEnabled(false);
                    PhpConversionCodeStylePanel.this.myNullUpperCaseRadioButton.setEnabled(false);
                }
            }
        });
        ButtonGroup boolCaseGroup = new ButtonGroup();
        boolCaseGroup.add(this.myBoolLowerCaseRadioButton);
        boolCaseGroup.add(this.myBoolUpperCaseRadioButton);
        ButtonGroup nullCaseGroup = new ButtonGroup();
        nullCaseGroup.add(this.myNullLowerCaseRadioButton);
        nullCaseGroup.add(this.myNullUpperCaseRadioButton);
        this.myElseIfStyleCheckBox.addActionListener(event -> {
            if (this.myElseIfStyleCheckBox.isSelected()) {
                this.mySeparateElseIfRadioButton.setEnabled(true);
                this.myCombineElseIfRadioButton.setEnabled(true);
            } else {
                this.mySeparateElseIfRadioButton.setEnabled(false);
                this.myCombineElseIfRadioButton.setEnabled(false);
            }
        });
        ButtonGroup elseIfStyleGroup = new ButtonGroup();
        elseIfStyleGroup.add(this.mySeparateElseIfRadioButton);
        elseIfStyleGroup.add(this.myCombineElseIfRadioButton);
        this.myAddCommaAfterLastElementBox.addItemListener(listener);
        this.myArrayDeclarationStylePanel.setBorder(IdeBorderFactory.createTitledBorder((String)PhpBundle.message("array.declaration.style", new Object[0])));
        this.myScrollPane.setMinimumSize(new Dimension(this.myOptionsPanel.getPreferredSize().width + this.myScrollPane.getVerticalScrollBar().getPreferredSize().width + 5, -1));
        this.myScrollPane.setPreferredSize(this.myScrollPane.getMinimumSize());
    }

    protected int getRightMargin() {
        return 80;
    }

    protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
        return EditorHighlighterFactory.getInstance().createEditorHighlighter((VirtualFile)new LightVirtualFile("a.php"), scheme, null);
    }

    @NotNull
    protected FileType getFileType() {
        PhpFileType phpFileType = PhpFileType.INSTANCE;
        if (phpFileType == null) {
            PhpConversionCodeStylePanel.$$$reportNull$$$0(0);
        }
        return phpFileType;
    }

    protected String getPreviewText() {
        return "<?php\n\nfunction foo($one=Null, $two = 0, $three = \"String\")\n{\n    if (True) {\n        $x = array(\n            0 => \"zero\",\n            123 => \"one two three\",\n            25 => \"two five\"\n        );\n    }\n    elseif(Null) {\n        echo Null;    }\n    else if (False) {\n        return 0;\n    }\n    return 1;\n}\n\n?>";
    }

    public void apply(CodeStyleSettings settings) {
        PhpCodeStyleSettings phpCodeStyleSettings = (PhpCodeStyleSettings)settings.getCustomSettings(PhpCodeStyleSettings.class);
        phpCodeStyleSettings.UPPER_CASE_BOOLEAN_CONST = this.myCaseBooleanCheckBox.isSelected() && this.myBoolUpperCaseRadioButton.isSelected();
        phpCodeStyleSettings.UPPER_CASE_NULL_CONST = this.myCaseNullCheckBox.isSelected() && this.myNullUpperCaseRadioButton.isSelected();
        phpCodeStyleSettings.LOWER_CASE_BOOLEAN_CONST = this.myCaseBooleanCheckBox.isSelected() && this.myBoolLowerCaseRadioButton.isSelected();
        phpCodeStyleSettings.LOWER_CASE_NULL_CONST = this.myCaseNullCheckBox.isSelected() && this.myNullLowerCaseRadioButton.isSelected();
        phpCodeStyleSettings.ELSE_IF_STYLE = this.getElseIfStyle();
        phpCodeStyleSettings.FORCE_SHORT_DECLARATION_ARRAY_STYLE = this.myForceShortArrayStyleCheckBox.isSelected();
        phpCodeStyleSettings.COMMA_AFTER_LAST_ARRAY_ELEMENT = this.myAddCommaAfterLastElementBox.isSelected();
    }

    public boolean isModified(CodeStyleSettings settings) {
        PhpCodeStyleSettings phpCodeStyleSettings = (PhpCodeStyleSettings)settings.getCustomSettings(PhpCodeStyleSettings.class);
        return phpCodeStyleSettings.UPPER_CASE_BOOLEAN_CONST != this.myCaseBooleanCheckBox.isSelected() && this.myBoolUpperCaseRadioButton.isSelected() || phpCodeStyleSettings.UPPER_CASE_NULL_CONST != this.myCaseNullCheckBox.isSelected() && this.myNullUpperCaseRadioButton.isSelected() || phpCodeStyleSettings.LOWER_CASE_BOOLEAN_CONST != this.myCaseBooleanCheckBox.isSelected() && this.myBoolLowerCaseRadioButton.isSelected() || phpCodeStyleSettings.LOWER_CASE_NULL_CONST != this.myCaseNullCheckBox.isSelected() && this.myNullLowerCaseRadioButton.isSelected() || phpCodeStyleSettings.ELSE_IF_STYLE != this.getElseIfStyle() || phpCodeStyleSettings.FORCE_SHORT_DECLARATION_ARRAY_STYLE != this.myForceShortArrayStyleCheckBox.isSelected() || phpCodeStyleSettings.COMMA_AFTER_LAST_ARRAY_ELEMENT != this.myAddCommaAfterLastElementBox.isSelected();
    }

    @NotNull
    private PhpCodeStyleSettings.ElseIfStyle getElseIfStyle() {
        if (this.myElseIfStyleCheckBox.isSelected() && this.mySeparateElseIfRadioButton.isSelected()) {
            PhpCodeStyleSettings.ElseIfStyle elseIfStyle = PhpCodeStyleSettings.ElseIfStyle.SEPARATE;
            if (elseIfStyle == null) {
                PhpConversionCodeStylePanel.$$$reportNull$$$0(1);
            }
            return elseIfStyle;
        }
        if (this.myElseIfStyleCheckBox.isSelected() && this.myCombineElseIfRadioButton.isSelected()) {
            PhpCodeStyleSettings.ElseIfStyle elseIfStyle = PhpCodeStyleSettings.ElseIfStyle.COMBINE;
            if (elseIfStyle == null) {
                PhpConversionCodeStylePanel.$$$reportNull$$$0(2);
            }
            return elseIfStyle;
        }
        PhpCodeStyleSettings.ElseIfStyle elseIfStyle = PhpCodeStyleSettings.ElseIfStyle.AS_IS;
        if (elseIfStyle == null) {
            PhpConversionCodeStylePanel.$$$reportNull$$$0(3);
        }
        return elseIfStyle;
    }

    public JComponent getPanel() {
        return this.myMainPanel;
    }

    protected void resetImpl(CodeStyleSettings settings) {
        PhpCodeStyleSettings phpCodeStyleSettings = (PhpCodeStyleSettings)settings.getCustomSettings(PhpCodeStyleSettings.class);
        this.myForceShortArrayStyleCheckBox.setSelected(phpCodeStyleSettings.FORCE_SHORT_DECLARATION_ARRAY_STYLE);
        if (phpCodeStyleSettings.UPPER_CASE_BOOLEAN_CONST) {
            this.enableBooleanCaseRadioButtons(true);
            this.myBoolUpperCaseRadioButton.doClick();
        } else if (phpCodeStyleSettings.LOWER_CASE_BOOLEAN_CONST) {
            this.enableBooleanCaseRadioButtons(true);
            this.myBoolLowerCaseRadioButton.doClick();
        } else {
            this.enableBooleanCaseRadioButtons(false);
        }
        if (phpCodeStyleSettings.UPPER_CASE_NULL_CONST) {
            this.enableNullCaseRadioButtons(true);
            this.myNullUpperCaseRadioButton.doClick();
        } else if (phpCodeStyleSettings.LOWER_CASE_NULL_CONST) {
            this.enableNullCaseRadioButtons(true);
            this.myNullLowerCaseRadioButton.doClick();
        } else {
            this.enableNullCaseRadioButtons(false);
        }
        if (phpCodeStyleSettings.ELSE_IF_STYLE == PhpCodeStyleSettings.ElseIfStyle.SEPARATE) {
            this.enableElseIfStyleRadioButtons(true);
            this.mySeparateElseIfRadioButton.doClick();
        } else if (phpCodeStyleSettings.ELSE_IF_STYLE == PhpCodeStyleSettings.ElseIfStyle.COMBINE) {
            this.enableElseIfStyleRadioButtons(true);
            this.myCombineElseIfRadioButton.doClick();
        } else {
            this.enableElseIfStyleRadioButtons(false);
        }
        this.myAddCommaAfterLastElementBox.setSelected(phpCodeStyleSettings.COMMA_AFTER_LAST_ARRAY_ELEMENT);
    }

    private void enableBooleanCaseRadioButtons(boolean state) {
        this.myCaseBooleanCheckBox.setSelected(state);
        this.myBoolLowerCaseRadioButton.setEnabled(state);
        this.myBoolUpperCaseRadioButton.setEnabled(state);
    }

    private void enableNullCaseRadioButtons(boolean state) {
        this.myCaseNullCheckBox.setSelected(state);
        this.myNullLowerCaseRadioButton.setEnabled(state);
        this.myNullUpperCaseRadioButton.setEnabled(state);
    }

    private void enableElseIfStyleRadioButtons(boolean state) {
        this.myElseIfStyleCheckBox.setSelected(state);
        this.mySeparateElseIfRadioButton.setEnabled(state);
        this.myCombineElseIfRadioButton.setEnabled(state);
    }

    public Language getDefaultLanguage() {
        return PhpLanguage.INSTANCE;
    }

    protected String getTabTitle() {
        return PhpBundle.message("php.conversion.code.style.title", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/lang/formatter/ui/PhpConversionCodeStylePanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getElseIfStyle";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel2;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JRadioButton jRadioButton5;
        JRadioButton jRadioButton6;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JPanel jPanel3;
        JBScrollPane jBScrollPane;
        JPanel jPanel4;
        this.myMainPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myScrollPane = jBScrollPane = new JBScrollPane();
        jPanel4.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myOptionsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(8, 2, new Insets(10, 10, 10, 10), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel3);
        this.myCaseBooleanCheckBox = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/PhpBundle").getString("phpdoc.code.style.convert.true.false.to"));
        jPanel3.add((Component)jCheckBox5, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myCaseNullCheckBox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/PhpBundle").getString("phpdoc.code.style.convert.null.to"));
        jPanel3.add((Component)jCheckBox4, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myBoolUpperCaseRadioButton = jRadioButton6 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton6, ResourceBundle.getBundle("messages/PhpBundle").getString("php.code.style.convert.upper.case"));
        jPanel5.add((Component)jRadioButton6, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBoolLowerCaseRadioButton = jRadioButton5 = new JRadioButton();
        jRadioButton5.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton5, ResourceBundle.getBundle("messages/PhpBundle").getString("php.code.style.convert.lower.case"));
        jPanel5.add((Component)jRadioButton5, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel6, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myNullUpperCaseRadioButton = jRadioButton4 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton4, ResourceBundle.getBundle("messages/PhpBundle").getString("php.code.style.convert.upper.case"));
        jPanel6.add((Component)jRadioButton4, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myNullLowerCaseRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("messages/PhpBundle").getString("php.code.style.convert.lower.case"));
        jPanel6.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel6.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myArrayDeclarationStylePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(null, ResourceBundle.getBundle("messages/PhpBundle").getString("array.declaration.style"), 0, 0, this.$$$getFont$$$(null, -1, -1, jPanel2.getFont()), null));
        this.myForceShortArrayStyleCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setSelected(false);
        jCheckBox3.setText("Force short declaration style");
        jPanel2.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myAddCommaAfterLastElementBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Add a comma after last element in multiline array");
        jPanel2.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myElseIfStyleCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/PhpBundle").getString("phpdoc.code.style.convert.else.if.to"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 20, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel7, new GridConstraints(5, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myCombineElseIfRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/PhpBundle").getString("phpdoc.code.style.convert.else.if.combine"));
        jPanel7.add((Component)jRadioButton2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySeparateElseIfRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/PhpBundle").getString("phpdoc.code.style.convert.else.if.separate"));
        jPanel7.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel7.add((Component)spacer4, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel3.add((Component)spacer5, new GridConstraints(7, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myPreviewPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

