/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.ext.CaseCollector;
import com.intellij.util.ui.JBUI;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpInterpreterConfigurationForm;
import com.jetbrains.php.config.PhpInterpreterFormProvider;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.run.remote.PhpInvalidSdkTypeException;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.php.testFramework.PhpTestFrameworkBySdkConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkType;
import com.jetbrains.php.testFramework.ui.PhpTestFrameworkBaseConfigurableForm;
import com.jetbrains.php.testFramework.ui.PhpTestFrameworkBySdkConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class PhpTestFrameworkBySdkConfigurableForm
extends PhpTestFrameworkBaseConfigurableForm<PhpTestFrameworkBySdkConfiguration> {
    private static final Logger LOG = Logger.getInstance(PhpTestFrameworkBySdkConfigurableForm.class);
    protected PhpInterpreterConfigurationForm myContextConfigurationForm;
    private final PhpSdkAdditionalData myRemoteSdkAdditionalData;

    public PhpTestFrameworkBySdkConfigurableForm(@NotNull Project project, @NotNull PhpTestFrameworkType frameworkType, @NotNull PhpTestFrameworkBySdkConfiguration configuration) {
        if (project == null) {
            PhpTestFrameworkBySdkConfigurableForm.$$$reportNull$$$0(0);
        }
        if (frameworkType == null) {
            PhpTestFrameworkBySdkConfigurableForm.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            PhpTestFrameworkBySdkConfigurableForm.$$$reportNull$$$0(2);
        }
        super(project, frameworkType, configuration);
        this.myRemoteSdkAdditionalData = PhpInterpretersManagerImpl.getInstance(project).findInterpreterDataById(configuration.getInterpreterId());
        PhpTestFrameworkBySdkConfig config = new PhpTestFrameworkBySdkConfig(project, configuration);
        this.myContextConfigurationForm = PhpInterpreterFormProvider.createForm(project, config);
    }

    @Override
    @NotNull
    public JComponent createComponent() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        this.myContextConfigurationForm.setInterpreterEditable(false);
        this.myContextConfigurationForm.reset();
        JPanel contextPanel = new JPanel(new BorderLayout());
        contextPanel.setBorder((Border)JBUI.Borders.empty((int)10, (int)10, (int)0, (int)10));
        contextPanel.add((Component)this.myContextConfigurationForm.getMainComponent(), "Center");
        mainPanel.add((Component)contextPanel, "North");
        JComponent mainComponent = super.createComponent();
        if (mainComponent != null) {
            mainPanel.add((Component)mainComponent, "Center");
        }
        JPanel jPanel = mainPanel;
        if (jPanel == null) {
            PhpTestFrameworkBySdkConfigurableForm.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    @Override
    protected void addBrowseFolderListener(@NotNull Project project, final @NotNull TextFieldWithBrowseButton textField, final @NotNull List<PhpTestFrameworkBaseConfigurableForm.PhpFilePathUpdateListener> listeners, boolean folderAllowed) {
        if (project == null) {
            PhpTestFrameworkBySdkConfigurableForm.$$$reportNull$$$0(4);
        }
        if (textField == null) {
            PhpTestFrameworkBySdkConfigurableForm.$$$reportNull$$$0(5);
        }
        if (listeners == null) {
            PhpTestFrameworkBySdkConfigurableForm.$$$reportNull$$$0(6);
        }
        if (this.myRemoteSdkAdditionalData instanceof RemoteSdkAdditionalData) {
            if (CaseCollector.useRemoteCredentials((RemoteSdkAdditionalData)((RemoteSdkAdditionalData)this.myRemoteSdkAdditionalData))) {
                String title = PhpBundle.message("php.test.framework.by.sdk.settings.remote.path.title", new Object[0]);
                try {
                    PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
                    if (manager != null) {
                        final ActionListener action = manager.createRemoteBrowserAction(project, this.myRemoteSdkAdditionalData, title, textField.getTextField(), false);
                        textField.getButton().setEnabled(true);
                        textField.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                String text = textField.getText();
                                action.actionPerformed(e);
                                String newPath = textField.getText();
                                if (!StringUtil.equals((CharSequence)text, (CharSequence)newPath)) {
                                    PhpTestFrameworkBySdkConfigurableForm.this.onExecutablePathChosen(newPath, listeners);
                                }
                            }
                        });
                    }
                    return;
                }
                catch (PhpInvalidSdkTypeException e) {
                    LOG.warn((Throwable)e);
                }
            }
            textField.getButton().setVisible(false);
        }
    }

    @Override
    public void disposeUIResources() {
        if (this.myContextConfigurationForm != null) {
            Disposer.dispose((Disposable)this.myContextConfigurationForm);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/testFramework/ui/PhpTestFrameworkBySdkConfigurableForm";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/testFramework/ui/PhpTestFrameworkBySdkConfigurableForm";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addBrowseFolderListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

