/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.EventDispatcher;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.config.servers.PhpServersConfigurable;
import com.jetbrains.php.ui.PhpUiUtil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpServerComboBox
extends ComboboxWithBrowseButton {
    private static final String NO_SERVER = "&lt;no server&gt;";
    private ActionListener buttonActionListener = null;
    private final EventDispatcher<ChangeListener> myEventDispatcher = EventDispatcher.create(ChangeListener.class);
    private boolean myAllowNoServer = false;
    private static final PhpServerItem NO_SERVER_ERROR_ITEM = new PhpServerItem(){

        @Override
        public void render(ListCellRendererWrapper<PhpServerItem> wrapper) {
            wrapper.setText(PhpUiUtil.toRedColorHtml(PhpServerComboBox.NO_SERVER));
        }

        @Override
        public String getServerName() {
            return null;
        }
    };
    private static final PhpServerItem NO_SERVER_ITEM = new PhpServerItem(){

        @Override
        public void render(ListCellRendererWrapper<PhpServerItem> wrapper) {
            wrapper.setText(PhpUiUtil.surroundWithHtml(PhpServerComboBox.NO_SERVER));
        }

        @Override
        public String getServerName() {
            return null;
        }
    };

    public PhpServerComboBox() {
        super((JComboBox)new ComboBox());
        this.getComboBox().setRenderer((ListCellRenderer)new ListCellRendererWrapper<PhpServerItem>(){

            public void customize(JList list, PhpServerItem item, int index, boolean selected, boolean hasFocus) {
                if (item != null) {
                    item.render(this);
                }
            }
        });
        this.setPreferredSize(new Dimension(200, this.getPreferredSize().height));
    }

    public void reset(@NotNull Project project) {
        if (project == null) {
            PhpServerComboBox.$$$reportNull$$$0(0);
        }
        this.reset(project, this.getSelectedServerName());
    }

    public void reset(final @NotNull Project project, @Nullable String selectedServerName) {
        if (project == null) {
            PhpServerComboBox.$$$reportNull$$$0(1);
        }
        List<PhpServer> servers = PhpProjectConfigurationFacade.getInstance(project).getServers();
        ArrayList<PhpRegularServerItem> regularServerItems = new ArrayList<PhpRegularServerItem>();
        for (PhpServer server : servers) {
            regularServerItems.add(new PhpRegularServerItem(server));
        }
        Collections.sort(regularServerItems);
        ArrayList<PhpServerItem> items = new ArrayList<PhpServerItem>();
        PhpServerItem selectedItem = this.findItemByName(regularServerItems, selectedServerName);
        if (!(selectedItem instanceof PhpRegularServerItem)) {
            items.add(selectedItem);
        }
        items.addAll(regularServerItems);
        this.getComboBox().setModel((ComboBoxModel)new CollectionComboBoxModel(items, null));
        this.getComboBox().setSelectedItem((Object)selectedItem);
        this.getComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhpServerComboBox.this.fireChanged();
            }
        });
        if (this.buttonActionListener != null) {
            this.getButton().removeActionListener(this.buttonActionListener);
        }
        this.buttonActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selectedServerName = PhpServerComboBox.this.getSelectedServerName();
                PhpServersConfigurable serversConfigurable = new PhpServersConfigurable(project, selectedServerName);
                boolean isOk = PhpUiUtil.editConfigurable(project, (Configurable)serversConfigurable);
                PhpServerComboBox.this.reset(project, isOk ? serversConfigurable.getLastSelectedItemName() : PhpServerComboBox.this.getSelectedServerName());
            }
        };
        this.getButton().addActionListener(this.buttonActionListener);
        this.fireChanged();
    }

    @NotNull
    public PhpServerItem findItemByName(@NotNull List<PhpRegularServerItem> items, @Nullable String name) {
        if (items == null) {
            PhpServerComboBox.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmpty((String)name)) {
            PhpServerItem phpServerItem = this.myAllowNoServer ? NO_SERVER_ITEM : NO_SERVER_ERROR_ITEM;
            if (phpServerItem == null) {
                PhpServerComboBox.$$$reportNull$$$0(3);
            }
            return phpServerItem;
        }
        for (PhpRegularServerItem serverItem : items) {
            if (!StringUtil.equals((CharSequence)name, (CharSequence)serverItem.getServer().getName())) continue;
            PhpRegularServerItem phpRegularServerItem = serverItem;
            if (phpRegularServerItem == null) {
                PhpServerComboBox.$$$reportNull$$$0(4);
            }
            return phpRegularServerItem;
        }
        PhpErrorServerItem phpErrorServerItem = new PhpErrorServerItem(name);
        if (phpErrorServerItem == null) {
            PhpServerComboBox.$$$reportNull$$$0(5);
        }
        return phpErrorServerItem;
    }

    public void setAllowNoServer(boolean allowNoServer) {
        this.myAllowNoServer = allowNoServer;
    }

    public ComboBox<PhpServerItem> getComboBox() {
        return (ComboBox)super.getComboBox();
    }

    @Nullable
    public PhpServer getSelectedServer() {
        Object selectedItem = this.getComboBox().getSelectedItem();
        if (selectedItem instanceof PhpRegularServerItem) {
            return ((PhpRegularServerItem)selectedItem).getServer();
        }
        return null;
    }

    @Nullable
    public String getSelectedServerName() {
        Object selectedItem = this.getComboBox().getSelectedItem();
        if (selectedItem instanceof PhpRegularServerItem) {
            return ((PhpRegularServerItem)selectedItem).getServer().getName();
        }
        if (selectedItem instanceof PhpErrorServerItem) {
            return ((PhpErrorServerItem)selectedItem).getServerName();
        }
        return null;
    }

    public void addChangeListener(ChangeListener listener) {
        this.myEventDispatcher.addListener((EventListener)listener, (Disposable)this);
    }

    private void fireChanged() {
        ((ChangeListener)this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent((Object)this));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/ui/PhpServerComboBox";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/ui/PhpServerComboBox";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findItemByName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findItemByName";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpErrorServerItem
    extends PhpServerItem {
        @NotNull
        private final String myServerName;

        private PhpErrorServerItem(@NotNull String serverName) {
            if (serverName == null) {
                PhpErrorServerItem.$$$reportNull$$$0(0);
            }
            this.myServerName = serverName;
        }

        @Override
        @NotNull
        public String getServerName() {
            String string = this.myServerName;
            if (string == null) {
                PhpErrorServerItem.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void render(ListCellRendererWrapper<PhpServerItem> wrapper) {
            wrapper.setText(PhpUiUtil.toRedColorHtml(this.getServerName()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serverName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/ui/PhpServerComboBox$PhpErrorServerItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/ui/PhpServerComboBox$PhpErrorServerItem";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getServerName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpRegularServerItem
    extends PhpServerItem
    implements Comparable<PhpRegularServerItem> {
        private final PhpServer myServer;

        private PhpRegularServerItem(@NotNull PhpServer server) {
            if (server == null) {
                PhpRegularServerItem.$$$reportNull$$$0(0);
            }
            this.myServer = server;
        }

        @Override
        public int compareTo(PhpRegularServerItem o) {
            return StringUtil.compare((String)this.getServerName(), (String)o.getServerName(), (boolean)true);
        }

        public PhpServer getServer() {
            return this.myServer;
        }

        @Override
        public String getServerName() {
            return this.myServer.getName();
        }

        @Override
        public void render(ListCellRendererWrapper<PhpServerItem> wrapper) {
            wrapper.setText(this.myServer.getName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/jetbrains/php/ui/PhpServerComboBox$PhpRegularServerItem", "<init>"));
        }
    }

    private static abstract class PhpServerItem {
        private PhpServerItem() {
        }

        public abstract void render(ListCellRendererWrapper<PhpServerItem> var1);

        @Nullable
        public abstract String getServerName();
    }
}

