/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.smarty.lang.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.smarty.SmartyFileType;
import com.jetbrains.smarty.SmartyLanguage;
import com.jetbrains.smarty.lang.SmartyTokenTypes;
import com.jetbrains.smarty.lang.psi.SmartyAttribute;
import com.jetbrains.smarty.lang.psi.SmartyTag;
import org.jetbrains.annotations.Nullable;

public class SmartyElementCreator {
    private final Project myProject;

    public SmartyElementCreator(Project project) {
        this.myProject = project;
    }

    @Nullable
    public PsiElement createStringLiteral(String content) {
        PsiElement attr;
        PsiFile tempFile = this.createTempFile("{ include \"" + content + "\"}");
        PsiElement tag = PsiTreeUtil.findChildOfType((PsiElement)tempFile, SmartyTag.class);
        if (tag != null && (attr = PsiTreeUtil.findChildOfType((PsiElement)tag, SmartyAttribute.class)) != null) {
            for (PsiElement attrChild = attr.getFirstChild(); attrChild != null; attrChild = attrChild.getNextSibling()) {
                if (!PhpPsiUtil.isOfType(attrChild, SmartyTokenTypes.STRING_LITERAL)) continue;
                return attrChild;
            }
        }
        return null;
    }

    private PsiFile createTempFile(String contents) {
        return PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("temp." + SmartyFileType.INSTANCE.getDefaultExtension(), (Language)SmartyLanguage.INSTANCE, (CharSequence)contents);
    }
}

