/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.annotate;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.CvsVcs2;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.cvsoperations.cvsAnnotate.Annotation;
import com.intellij.cvsSupport2.cvsstatuses.CvsEntriesListener;
import com.intellij.cvsSupport2.history.CvsRevisionNumber;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspectAdapter;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class CvsFileAnnotation
extends FileAnnotation {
    private final String myContent;
    private final Annotation[] myAnnotations;
    private final CvsEntriesListener myCvsEntriesListener;
    private final Map<String, String> myRevisionComments = new HashMap<String, String>();
    @Nullable
    private final List<VcsFileRevision> myRevisions;
    private final VirtualFile myFile;
    private final String myCurrentRevision;
    private final LineAnnotationAspect USER = new CvsAnnotationAspect(CvsAnnotationAspect.AUTHOR, true){

        public String getValue(int lineNumber) {
            if (lineNumber < 0 || lineNumber >= CvsFileAnnotation.this.myAnnotations.length) {
                return "";
            }
            return CvsFileAnnotation.this.myAnnotations[lineNumber].getUserName();
        }
    };
    private final LineAnnotationAspect DATE = new CvsAnnotationAspect(CvsAnnotationAspect.DATE, true){

        public String getValue(int lineNumber) {
            if (lineNumber < 0 || lineNumber >= CvsFileAnnotation.this.myAnnotations.length) {
                return "";
            }
            return CvsFileAnnotation.this.myAnnotations[lineNumber].getPresentableDateString();
        }
    };
    private final LineAnnotationAspect REVISION = new CvsAnnotationAspect(CvsAnnotationAspect.REVISION, false){

        public String getValue(int lineNumber) {
            if (lineNumber < 0 || lineNumber >= CvsFileAnnotation.this.myAnnotations.length) {
                return "";
            }
            return CvsFileAnnotation.this.myAnnotations[lineNumber].getRevision();
        }
    };

    public CvsFileAnnotation(String content, Annotation[] annotations, @Nullable List<VcsFileRevision> revisions, VirtualFile file, String currentRevision, Project project) {
        super(project);
        this.myContent = content;
        this.myAnnotations = annotations;
        this.myRevisions = revisions;
        this.myFile = file;
        this.myCurrentRevision = currentRevision;
        if (revisions != null) {
            for (VcsFileRevision revision : revisions) {
                this.myRevisionComments.put(revision.getRevisionNumber().toString(), revision.getCommitMessage());
            }
            Collections.sort(this.myRevisions, (o1, o2) -> -1 * o1.getRevisionNumber().compareTo((Object)o2.getRevisionNumber()));
        }
        this.myCvsEntriesListener = new CvsEntriesListener(){

            @Override
            public void entriesChanged(VirtualFile parent) {
            }

            @Override
            public void entryChanged(VirtualFile file) {
                if (CvsFileAnnotation.this.myFile == null) {
                    return;
                }
                CvsFileAnnotation.this.close();
            }
        };
        CvsEntriesManager.getInstance().addCvsEntriesListener(this.myCvsEntriesListener);
    }

    public void dispose() {
        CvsEntriesManager.getInstance().removeCvsEntriesListener(this.myCvsEntriesListener);
    }

    public LineAnnotationAspect[] getAspects() {
        return new LineAnnotationAspect[]{this.REVISION, this.DATE, this.USER};
    }

    public String getToolTip(int lineNumber) {
        if (lineNumber < 0 || lineNumber >= this.myAnnotations.length) {
            return "";
        }
        Annotation annotation = this.myAnnotations[lineNumber];
        String revision = annotation.getRevision();
        Date date = annotation.getDate();
        String author = annotation.getUserName();
        String comment = this.myRevisionComments.get(revision);
        if (comment == null) {
            return "";
        }
        return CvsBundle.message((String)"annotation.tooltip", (Object[])new Object[]{revision, date, author, comment});
    }

    public String getAnnotatedContent() {
        return this.myContent;
    }

    public VcsRevisionNumber getLineRevisionNumber(int lineNumber) {
        if (lineNumber < 0 || lineNumber >= this.myAnnotations.length) {
            return null;
        }
        String revision = this.myAnnotations[lineNumber].getRevision();
        if (revision != null) {
            return new CvsRevisionNumber(revision);
        }
        return null;
    }

    public Date getLineDate(int lineNumber) {
        if (lineNumber < 0 || lineNumber >= this.myAnnotations.length) {
            return null;
        }
        return this.myAnnotations[lineNumber].getDate();
    }

    @Nullable
    public List<VcsFileRevision> getRevisions() {
        return this.myRevisions;
    }

    public int getLineCount() {
        return this.myAnnotations.length;
    }

    @Nullable
    public VcsRevisionNumber getCurrentRevision() {
        return new CvsRevisionNumber(this.myCurrentRevision);
    }

    public VcsKey getVcsKey() {
        return CvsVcs2.getKey();
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    private static abstract class CvsAnnotationAspect
    extends LineAnnotationAspectAdapter {
        CvsAnnotationAspect(String id, boolean showByDefault) {
            super(id, showByDefault);
        }

        protected void showAffectedPaths(int lineNum) {
        }
    }
}

