/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.sql.Connection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.core.DBLeasedSession;
import org.jetbrains.dekaf.core.DBSessions;
import org.jetbrains.dekaf.exceptions.DBFactoryException;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateRdbmsProvider;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateFederatedProvider;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateRdbmsProvider;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateSession;

public abstract class JdbcSessions
extends DBSessions {
    @NotNull
    public static DBLeasedSession wrap(@NotNull Connection connection, @NotNull JdbcIntermediateRdbmsProvider rdbmsProvider, boolean takeOwnership) {
        JdbcIntermediateSession intermediateSession = rdbmsProvider.wrapConnection(connection, takeOwnership);
        return JdbcSessions.wrap(intermediateSession);
    }

    @NotNull
    public static DBLeasedSession wrap(@NotNull Connection connection, @NotNull JdbcIntermediateFederatedProvider federatedProvider, @NotNull Rdbms rdbms, boolean takeOwnership) {
        IntegralIntermediateRdbmsProvider rdbmsProvider = federatedProvider.getSpecificServiceProvider(rdbms);
        if (rdbmsProvider == null) {
            throw new DBFactoryException("RDBMS provider for " + rdbms.code + " is not registered.");
        }
        if (!(rdbmsProvider instanceof JdbcIntermediateRdbmsProvider)) {
            throw new DBFactoryException("Looks like the obtained provider for " + rdbms.code + " doesn't support JDBC. It's class: " + rdbmsProvider.getClass().getName() + ".");
        }
        JdbcIntermediateSession intermediateSession = ((JdbcIntermediateRdbmsProvider)rdbmsProvider).wrapConnection(connection, takeOwnership);
        return JdbcSessions.wrap(intermediateSession);
    }
}

