/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.presentable;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.presentable.Capitalization;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.presentable.JSNamedElementKind;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import org.jetbrains.annotations.NotNull;

public class JSNamedElementPresenter {
    private final JSNamedElementKind myKind;
    private final Capitalization myCapitalization;
    private String myShortName;
    private String myQualifiedName;
    private final PsiElement myElement;

    public JSNamedElementPresenter(@NotNull PsiElement element) {
        if (element == null) {
            JSNamedElementPresenter.$$$reportNull$$$0(0);
        }
        this(element, Capitalization.LowerCase);
    }

    public JSNamedElementPresenter(@NotNull PsiElement element, @NotNull Capitalization capitalization) {
        if (element == null) {
            JSNamedElementPresenter.$$$reportNull$$$0(1);
        }
        if (capitalization == null) {
            JSNamedElementPresenter.$$$reportNull$$$0(2);
        }
        this.myKind = JSNamedElementKind.kind(element);
        this.myCapitalization = capitalization;
        this.myElement = element;
    }

    void overrideShortName(@NotNull String name) {
        if (name == null) {
            JSNamedElementPresenter.$$$reportNull$$$0(3);
        }
        this.myShortName = name;
    }

    @NotNull
    public String getQualifiedName() {
        if (this.myQualifiedName != null) {
            String string = this.myQualifiedName;
            if (string == null) {
                JSNamedElementPresenter.$$$reportNull$$$0(4);
            }
            return string;
        }
        this.myQualifiedName = this.computePresentableName(true);
        if (this.myQualifiedName == null) {
            JSNamedElementPresenter.$$$reportNull$$$0(5);
        }
        return this.myQualifiedName;
    }

    @NotNull
    public String getShortName() {
        if (this.myShortName != null) {
            String string = this.myShortName;
            if (string == null) {
                JSNamedElementPresenter.$$$reportNull$$$0(6);
            }
            return string;
        }
        this.myShortName = this.computePresentableName(false);
        if (this.myShortName == null) {
            JSNamedElementPresenter.$$$reportNull$$$0(7);
        }
        return this.myShortName;
    }

    @NotNull
    public String describeElementKind() {
        String message = JSBundle.message((String)this.myKind.humanReadableKey(), (Object[])new Object[0]);
        switch (this.myCapitalization) {
            case UpperCase: {
                String string = StringUtil.capitalize((String)message);
                if (string == null) {
                    JSNamedElementPresenter.$$$reportNull$$$0(8);
                }
                return string;
            }
            case LowerCase: {
                String string = message;
                if (string == null) {
                    JSNamedElementPresenter.$$$reportNull$$$0(9);
                }
                return string;
            }
        }
        String string = StringUtil.capitalizeWords((String)message, (boolean)true);
        if (string == null) {
            JSNamedElementPresenter.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    private String computePresentableName(boolean qualified) {
        if (qualified) {
            String name;
            if (this.myElement instanceof JSQualifiedNamedElement && (name = ((JSQualifiedNamedElement)this.myElement).getQualifiedName()) != null) {
                String string = name;
                if (string == null) {
                    JSNamedElementPresenter.$$$reportNull$$$0(11);
                }
                return string;
            }
            String string = this.getShortName();
            if (string == null) {
                JSNamedElementPresenter.$$$reportNull$$$0(12);
            }
            return string;
        }
        String name = null;
        if (this.myElement instanceof JSPsiNamedElementBase) {
            name = this.myElement instanceof JSImplicitElementImpl ? ((JSImplicitElementImpl)this.myElement).getName() : JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)this.myElement, true);
        } else if (this.myElement instanceof PsiNamedElement) {
            name = ((PsiNamedElement)this.myElement).getName();
        }
        String string = name != null ? name : JSFormatUtil.getAnonymousName(this.myElement);
        if (string == null) {
            JSNamedElementPresenter.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public String describeWithShortName() {
        String string = this.describeWithShortName(false);
        if (string == null) {
            JSNamedElementPresenter.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public String describeWithShortName(boolean htmlEmphasize) {
        if (this.myKind == JSNamedElementKind.ES6_DEFAULT_EXPORT) {
            String string = this.describeElementKind();
            if (string == null) {
                JSNamedElementPresenter.$$$reportNull$$$0(15);
            }
            return string;
        }
        String name = this.getShortName();
        if (this.myKind == JSNamedElementKind.CONSTRUCTOR && "constructor".equals(name)) {
            String string = this.describeElementKind();
            if (string == null) {
                JSNamedElementPresenter.$$$reportNull$$$0(16);
            }
            return string;
        }
        if (htmlEmphasize) {
            String string = this.describeElementKind() + " " + StringUtil.htmlEmphasize((String)name);
            if (string == null) {
                JSNamedElementPresenter.$$$reportNull$$$0(17);
            }
            return string;
        }
        String string = this.describeElementKind() + " '" + name + "'";
        if (string == null) {
            JSNamedElementPresenter.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public String describeWithQualifiedName() {
        if (this.myKind == JSNamedElementKind.ES6_DEFAULT_EXPORT) {
            String string = this.describeElementKind();
            if (string == null) {
                JSNamedElementPresenter.$$$reportNull$$$0(19);
            }
            return string;
        }
        String string = this.describeElementKind() + " " + this.getQualifiedName();
        if (string == null) {
            JSNamedElementPresenter.$$$reportNull$$$0(20);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "capitalization";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/presentable/JSNamedElementPresenter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/presentable/JSNamedElementPresenter";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "describeElementKind";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "computePresentableName";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "describeWithShortName";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "describeWithQualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "overrideShortName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

