/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.settings;

import com.intellij.execution.ExecutionException;
import com.intellij.javascript.nodejs.NodeFileTransfer;
import com.intellij.javascript.nodejs.NodeProfilingRuntimeSettings;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class NodeProfilingRuntimeSettingsImpl
implements NodeProfilingRuntimeSettings {
    public static final String REMOTE_LOG_FOLDER = "v8logs";
    private String myNodeParameters = "";
    private final String myLogFileName;
    private final String myFileSuffix;
    private final File myLocalLogFolder;
    private final String myWorkingDir;
    private final NodeFileTransfer myTransfer;
    private final Set<String> myBeforeFileNames;
    private final Condition<String> myNameCondition;

    public NodeProfilingRuntimeSettingsImpl(String fileSuffix, File localLogFolder, String workingDir, NodeFileTransfer transfer) throws ExecutionException, IOException {
        this.myFileSuffix = fileSuffix;
        this.myLocalLogFolder = localLogFolder;
        this.myWorkingDir = workingDir;
        this.myTransfer = transfer;
        this.myNameCondition = s -> s.contains("v8") && s.contains(this.myFileSuffix);
        List names = this.myTransfer.listDirectoryContents(this.myWorkingDir);
        this.myBeforeFileNames = new HashSet<String>(ContainerUtil.filter((Collection)names, this.myNameCondition));
        this.myLogFileName = this.generateLogFileName();
    }

    private String generateLogFileName() throws ExecutionException {
        String prefix = "v8-" + this.myFileSuffix;
        String extension = ".log";
        if (!this.myBeforeFileNames.contains(prefix + ".log")) {
            return prefix + ".log";
        }
        Random random = new Random(17L);
        for (int i = 0; i < 1000; ++i) {
            String name = prefix + random.nextInt() + ".log";
            if (this.myBeforeFileNames.contains(name)) continue;
            return name;
        }
        throw new ExecutionException("Can not generate log file name");
    }

    public List<File> getLogFiles() throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        this.myTransfer.grouped("Fetching log files", transfer -> {
            List names = this.myTransfer.listDirectoryContents(this.myWorkingDir);
            List createdNames = ContainerUtil.filter((Collection)names, name -> this.myNameCondition.value(name) && !this.myBeforeFileNames.contains(name));
            if (createdNames.isEmpty()) {
                return;
            }
            HashSet namesSet = new HashSet(createdNames);
            if (!this.myTransfer.isLocal()) {
                this.myTransfer.copy(this.myWorkingDir, namesSet, this.myWorkingDir + "/" + REMOTE_LOG_FOLDER);
            }
            this.myTransfer.fetch(this.myWorkingDir, namesSet, this.myLocalLogFolder.getAbsolutePath());
            try {
                if (!FileUtil.pathsEqual((String)this.myWorkingDir, (String)this.myTransfer.getMappingFor(this.myLocalLogFolder.getAbsolutePath()))) {
                    this.myTransfer.delete(this.myWorkingDir, namesSet);
                }
            }
            catch (ExecutionException e) {
                throw new IOException(e);
            }
            for (String name2 : createdNames) {
                files.add(new File(this.myLocalLogFolder, name2));
            }
        });
        if (files.isEmpty()) {
            return Collections.emptyList();
        }
        LocalFileSystem.getInstance().refreshIoFiles(files);
        return files;
    }

    public String getLogFileName() {
        return this.myLogFileName;
    }

    public void setNodeParameters(String nodeParameters) {
        this.myNodeParameters = nodeParameters;
    }

    public String getNodeParameters() {
        return this.myNodeParameters;
    }

    public File getLogFolder() {
        return this.myLocalLogFolder;
    }
}

